/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.schedule.queue.multilevelqueue;

import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.multilevelqueue.MultilevelPriorityQueue;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.multilevelqueue.Priority;

public class DriverTaskHandle {
    private final int driverTaskHandleId;
    @GuardedBy(value="this")
    private long scheduledTimeInNanos;
    private final MultilevelPriorityQueue driverTaskQueue;
    private final OptionalInt maxDriversPerTask;
    private final AtomicReference<Priority> priority = new AtomicReference<Priority>(new Priority(0, 0L));

    public DriverTaskHandle(int driverTaskHandleId, MultilevelPriorityQueue driverTaskQueue, OptionalInt maxDriversPerTask) {
        this.driverTaskHandleId = driverTaskHandleId;
        this.driverTaskQueue = Objects.requireNonNull(driverTaskQueue, "driverTaskQueue is null");
        this.maxDriversPerTask = Objects.requireNonNull(maxDriversPerTask, "maxDriversPerTask is null");
    }

    public synchronized Priority addScheduledTimeInNanos(long durationNanos) {
        this.scheduledTimeInNanos += durationNanos;
        Priority newPriority = this.driverTaskQueue.updatePriority(this.priority.get(), durationNanos, this.scheduledTimeInNanos);
        this.priority.set(newPriority);
        return newPriority;
    }

    public synchronized Priority resetLevelScheduledTime() {
        long levelMinScheduledTime = this.driverTaskQueue.getLevelMinScheduledTime(this.priority.get().getLevel(), this.scheduledTimeInNanos);
        if (this.priority.get().getLevelScheduledTime() < levelMinScheduledTime) {
            Priority newPriority = new Priority(this.priority.get().getLevel(), levelMinScheduledTime);
            this.priority.set(newPriority);
            return newPriority;
        }
        return this.priority.get();
    }

    public Priority getPriority() {
        return this.priority.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriverTaskHandle that = (DriverTaskHandle)o;
        return this.driverTaskHandleId == that.driverTaskHandleId;
    }

    public int hashCode() {
        return Objects.hash(this.driverTaskHandleId);
    }
}

