/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryGroup;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryManager;

public class FIFOCacheEntryManager<FK, SK, V>
implements ICacheEntryManager<FK, SK, V, FIFOCacheEntry<SK, V>> {
    private static final int SLOT_NUM = 128;
    private final FIFOLinkedList[] fifoLinkedLists = new FIFOLinkedList[128];
    private final AtomicInteger cachePutRoundRobinIndex = new AtomicInteger(0);
    private final AtomicInteger cacheEvictRoundRobinIndex = new AtomicInteger(0);

    @Override
    public FIFOCacheEntry<SK, V> createCacheEntry(SK secondKey, V value, ICacheEntryGroup<FK, SK, V, FIFOCacheEntry<SK, V>> cacheEntryGroup) {
        return new FIFOCacheEntry(secondKey, value, cacheEntryGroup);
    }

    @Override
    public void access(FIFOCacheEntry<SK, V> cacheEntry) {
    }

    @Override
    public void put(FIFOCacheEntry<SK, V> cacheEntry) {
        this.getNextList(this.cachePutRoundRobinIndex).add(cacheEntry);
    }

    @Override
    public FIFOCacheEntry<SK, V> evict() {
        int startIndex = this.getNextIndex(this.cacheEvictRoundRobinIndex);
        for (int i = 0; i < 128; ++i) {
            FIFOCacheEntry cacheEntry;
            FIFOLinkedList fifoLinkedList;
            if (startIndex == 128) {
                startIndex = 0;
            }
            if ((fifoLinkedList = this.fifoLinkedLists[startIndex]) != null && (cacheEntry = fifoLinkedList.evict()) != null) {
                return cacheEntry;
            }
            ++startIndex;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        FIFOLinkedList[] fIFOLinkedListArray = this.fifoLinkedLists;
        synchronized (this.fifoLinkedLists) {
            for (int i = 0; i < 128; ++i) {
                this.fifoLinkedLists[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FIFOLinkedList getNextList(AtomicInteger roundRobinIndex) {
        int listIndex = this.getNextIndex(roundRobinIndex);
        FIFOLinkedList fifoLinkedList = this.fifoLinkedLists[listIndex];
        if (fifoLinkedList != null) return fifoLinkedList;
        FIFOLinkedList[] fIFOLinkedListArray = this.fifoLinkedLists;
        synchronized (this.fifoLinkedLists) {
            fifoLinkedList = this.fifoLinkedLists[listIndex];
            if (fifoLinkedList != null) return fifoLinkedList;
            this.fifoLinkedLists[listIndex] = fifoLinkedList = new FIFOLinkedList();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return fifoLinkedList;
        }
    }

    private int getNextIndex(AtomicInteger roundRobinIndex) {
        return roundRobinIndex.getAndUpdate(currentValue -> ++currentValue >= 128 ? 0 : currentValue);
    }

    private static class FIFOLinkedList {
        private FIFOCacheEntry head;
        private FIFOCacheEntry tail;

        private FIFOLinkedList() {
        }

        synchronized void add(FIFOCacheEntry cacheEntry) {
            if (this.head == null) {
                this.head = cacheEntry;
                this.tail = cacheEntry;
                return;
            }
            this.head.pre = cacheEntry;
            this.head = cacheEntry;
        }

        synchronized FIFOCacheEntry evict() {
            if (this.tail == null) {
                return null;
            }
            FIFOCacheEntry cacheEntry = this.tail;
            this.tail = this.tail.pre;
            if (this.tail == null) {
                this.head = null;
            }
            cacheEntry.pre = null;
            return cacheEntry;
        }
    }

    static class FIFOCacheEntry<SK, V>
    implements ICacheEntry<SK, V> {
        private final SK secondKey;
        private final ICacheEntryGroup cacheEntryGroup;
        private V value;
        private FIFOCacheEntry<SK, V> pre;

        private FIFOCacheEntry(SK secondKey, V value, ICacheEntryGroup cacheEntryGroup) {
            this.secondKey = secondKey;
            this.value = value;
            this.cacheEntryGroup = cacheEntryGroup;
        }

        @Override
        public SK getSecondKey() {
            return this.secondKey;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public ICacheEntryGroup getBelongedGroup() {
            return this.cacheEntryGroup;
        }

        @Override
        public void replaceValue(V newValue) {
            this.value = newValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FIFOCacheEntry that = (FIFOCacheEntry)o;
            return Objects.equals(this.secondKey, that.secondKey) && Objects.equals(this.cacheEntryGroup, that.cacheEntryGroup);
        }

        public int hashCode() {
            return this.cacheEntryGroup.hashCode() * 31 + this.secondKey.hashCode();
        }
    }
}

