/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata.model;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ShowModelsTask
implements IConfigTask {
    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showModels();
    }

    public static void buildTsBlock(List<ByteBuffer> modelInfoList, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showModelsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        for (ByteBuffer modelInfo : modelInfoList) {
            int i;
            String modelId = ReadWriteIOUtils.readString((ByteBuffer)modelInfo);
            String modelTask = ReadWriteIOUtils.readString((ByteBuffer)modelInfo);
            String modelType = ReadWriteIOUtils.readString((ByteBuffer)modelInfo);
            String queryBody = ReadWriteIOUtils.readString((ByteBuffer)modelInfo);
            String trainingState = ReadWriteIOUtils.readString((ByteBuffer)modelInfo);
            String modelPath = ReadWriteIOUtils.readString((ByteBuffer)modelInfo);
            int listSize = ReadWriteIOUtils.readInt((ByteBuffer)modelInfo);
            ArrayList<String> modelHyperparameter = new ArrayList<String>();
            for (i = 0; i < listSize; ++i) {
                modelHyperparameter.add(ReadWriteIOUtils.readString((ByteBuffer)modelInfo));
            }
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(Binary.valueOf((String)modelId));
            builder.getColumnBuilder(1).writeBinary(Binary.valueOf((String)modelTask));
            builder.getColumnBuilder(2).writeBinary(Binary.valueOf((String)modelType));
            builder.getColumnBuilder(3).writeBinary(Binary.valueOf((String)queryBody));
            builder.getColumnBuilder(4).writeBinary(Binary.valueOf((String)trainingState));
            builder.getColumnBuilder(5).writeBinary(Binary.valueOf((String)modelPath));
            builder.getColumnBuilder(6).writeBinary(Binary.valueOf((String)((String)modelHyperparameter.get(0))));
            builder.declarePosition();
            for (i = 1; i < listSize; ++i) {
                builder.getTimeColumnBuilder().writeLong(0L);
                for (int columnIndex = 0; columnIndex <= 5; ++columnIndex) {
                    builder.getColumnBuilder(columnIndex).writeBinary(Binary.valueOf((String)""));
                }
                builder.getColumnBuilder(6).writeBinary(Binary.valueOf((String)((String)modelHyperparameter.get(i))));
                builder.declarePosition();
            }
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowModelsHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

