/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateTimeSeriesPlan;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class CreateTimeSeriesNode
extends WritePlanNode
implements ICreateTimeSeriesPlan {
    private PartialPath path;
    private TSDataType dataType;
    private TSEncoding encoding;
    private CompressionType compressor;
    private String alias;
    private Map<String, String> props = null;
    private Map<String, String> tags = null;
    private Map<String, String> attributes = null;
    private long tagOffset = -1L;
    private TRegionReplicaSet regionReplicaSet;

    public CreateTimeSeriesNode(PlanNodeId id, PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String alias) {
        super(id);
        this.path = path;
        this.dataType = dataType;
        this.encoding = encoding;
        this.compressor = compressor;
        this.tags = tags;
        this.attributes = attributes;
        this.alias = alias;
        if (props != null) {
            this.props = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            this.props.putAll(props);
        }
    }

    @Override
    public PartialPath getPath() {
        return this.path;
    }

    @Override
    public void setPath(PartialPath path) {
        this.path = path;
    }

    @Override
    public TSDataType getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public CompressionType getCompressor() {
        return this.compressor;
    }

    @Override
    public void setCompressor(CompressionType compressor) {
        this.compressor = compressor;
    }

    @Override
    public TSEncoding getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(TSEncoding encoding) {
        this.encoding = encoding;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Override
    public Map<String, String> getProps() {
        return this.props;
    }

    @Override
    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    @Override
    public long getTagOffset() {
        return this.tagOffset;
    }

    @Override
    public void setTagOffset(long tagOffset) {
        this.tagOffset = tagOffset;
    }

    @Override
    public List<PlanNode> getChildren() {
        return new ArrayList<PlanNode>();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("Clone of CreateTimeSeriesNode is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    public static CreateTimeSeriesNode deserialize(ByteBuffer byteBuffer) {
        byte label;
        PartialPath path = null;
        String alias = null;
        HashMap<String, String> props = null;
        HashMap<String, String> tags = null;
        HashMap<String, String> attributes = null;
        int length = byteBuffer.getInt();
        byte[] bytes = new byte[length];
        byteBuffer.get(bytes);
        try {
            path = new PartialPath(new String(bytes));
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize CreateTimeSeriesNode", e);
        }
        TSDataType dataType = TSDataType.values()[byteBuffer.get()];
        TSEncoding encoding = TSEncoding.values()[byteBuffer.get()];
        CompressionType compressor = CompressionType.deserialize((byte)byteBuffer.get());
        if (byteBuffer.get() == 1) {
            alias = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        }
        if ((label = byteBuffer.get()) == 0) {
            props = new HashMap();
        } else if (label == 1) {
            props = ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
        }
        label = byteBuffer.get();
        if (label == 0) {
            tags = new HashMap();
        } else if (label == 1) {
            tags = ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
        }
        label = byteBuffer.get();
        if (label == 0) {
            attributes = new HashMap();
        } else if (label == 1) {
            attributes = ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
        }
        String id = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        return new CreateTimeSeriesNode(new PlanNodeId(id), path, dataType, encoding, compressor, props, tags, attributes, alias);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.CREATE_TIME_SERIES.serialize(byteBuffer);
        byte[] bytes = this.path.getFullPath().getBytes();
        byteBuffer.putInt(bytes.length);
        byteBuffer.put(bytes);
        byteBuffer.put((byte)this.dataType.ordinal());
        byteBuffer.put((byte)this.encoding.ordinal());
        byteBuffer.put(this.compressor.serialize());
        if (this.alias != null) {
            byteBuffer.put((byte)1);
            ReadWriteIOUtils.write((String)this.alias, (ByteBuffer)byteBuffer);
        } else {
            byteBuffer.put((byte)0);
        }
        if (this.props == null) {
            byteBuffer.put((byte)-1);
        } else if (this.props.isEmpty()) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            ReadWriteIOUtils.write(this.props, (ByteBuffer)byteBuffer);
        }
        if (this.tags == null) {
            byteBuffer.put((byte)-1);
        } else if (this.tags.isEmpty()) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            ReadWriteIOUtils.write(this.tags, (ByteBuffer)byteBuffer);
        }
        if (this.attributes == null) {
            byteBuffer.put((byte)-1);
        } else if (this.attributes.isEmpty()) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            ReadWriteIOUtils.write(this.attributes, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.CREATE_TIME_SERIES.serialize(stream);
        byte[] bytes = this.path.getFullPath().getBytes();
        stream.writeInt(bytes.length);
        stream.write(bytes);
        stream.write((byte)this.dataType.ordinal());
        stream.write((byte)this.encoding.ordinal());
        stream.write(this.compressor.serialize());
        if (this.alias != null) {
            stream.write(1);
            ReadWriteIOUtils.write((String)this.alias, (OutputStream)stream);
        } else {
            stream.write(0);
        }
        if (this.props == null) {
            stream.write(-1);
        } else if (this.props.isEmpty()) {
            stream.write(0);
        } else {
            stream.write(1);
            ReadWriteIOUtils.write(this.props, (OutputStream)stream);
        }
        if (this.tags == null) {
            stream.write(-1);
        } else if (this.tags.isEmpty()) {
            stream.write(0);
        } else {
            stream.write(1);
            ReadWriteIOUtils.write(this.tags, (OutputStream)stream);
        }
        if (this.attributes == null) {
            stream.write(-1);
        } else if (this.attributes.isEmpty()) {
            stream.write(0);
        } else {
            stream.write(1);
            ReadWriteIOUtils.write(this.attributes, (OutputStream)stream);
        }
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C schemaRegion) {
        return visitor.visitCreateTimeSeries(this, schemaRegion);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CreateTimeSeriesNode that = (CreateTimeSeriesNode)o;
        return this.path.equals((Object)that.path) && this.dataType == that.dataType && this.encoding == that.encoding && this.compressor == that.compressor && (this.alias == null && that.alias == null || this.alias != null && this.alias.equals(that.alias)) && (this.props == null && that.props == null || this.props != null && this.props.equals(that.props)) && (this.tags == null && that.tags == null || this.tags != null && this.tags.equals(that.tags)) && (this.attributes == null && that.attributes == null || this.attributes != null && this.attributes.equals(that.attributes));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.path, this.dataType, this.encoding, this.compressor, this.alias, this.props, this.tags, this.attributes);
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        TRegionReplicaSet regionReplicaSet = analysis.getSchemaPartitionInfo().getSchemaRegionReplicaSet(this.path.getDevice());
        this.setRegionReplicaSet(regionReplicaSet);
        return ImmutableList.of((Object)this);
    }

    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }
}

