/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.consensus.index.ComparableConsensusRequest;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IDeviceID;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public abstract class InsertNode
extends WritePlanNode
implements ComparableConsensusRequest {
    public static final long NO_CONSENSUS_INDEX = -1L;
    protected PartialPath devicePath;
    protected boolean isAligned;
    protected MeasurementSchema[] measurementSchemas;
    protected String[] measurements;
    protected TSDataType[] dataTypes;
    protected int failedMeasurementNumber = 0;
    protected IDeviceID deviceID;
    protected long searchIndex = -1L;
    protected TRegionReplicaSet dataRegionReplicaSet;
    protected ProgressIndex progressIndex;

    protected InsertNode(PlanNodeId id) {
        super(id);
    }

    protected InsertNode(PlanNodeId id, PartialPath devicePath, boolean isAligned, String[] measurements, TSDataType[] dataTypes) {
        super(id);
        this.devicePath = devicePath;
        this.isAligned = isAligned;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
    }

    public TRegionReplicaSet getDataRegionReplicaSet() {
        return this.dataRegionReplicaSet;
    }

    public void setDataRegionReplicaSet(TRegionReplicaSet dataRegionReplicaSet) {
        this.dataRegionReplicaSet = dataRegionReplicaSet;
    }

    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    public void setDevicePath(PartialPath devicePath) {
        this.devicePath = devicePath;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public void setAligned(boolean aligned) {
        this.isAligned = aligned;
    }

    public MeasurementSchema[] getMeasurementSchemas() {
        return this.measurementSchemas;
    }

    public void setMeasurementSchemas(MeasurementSchema[] measurementSchemas) {
        this.measurementSchemas = measurementSchemas;
    }

    public String[] getMeasurements() {
        return this.measurements;
    }

    public TSDataType[] getDataTypes() {
        return this.dataTypes;
    }

    public TSDataType getDataType(int index) {
        return this.dataTypes[index];
    }

    public void setDataTypes(TSDataType[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    public IDeviceID getDeviceID() {
        return this.deviceID;
    }

    public void setDeviceID(IDeviceID deviceID) {
        this.deviceID = deviceID;
    }

    public long getSearchIndex() {
        return this.searchIndex;
    }

    public void setSearchIndex(long searchIndex) {
        this.searchIndex = searchIndex;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        throw new NotImplementedException("serializeAttributes of InsertNode is not implemented");
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        throw new NotImplementedException("serializeAttributes of InsertNode is not implemented");
    }

    protected int serializeMeasurementSchemasSize() {
        int byteLen = 0;
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            if (IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
                byteLen += WALWriteUtils.sizeToWrite(this.measurementSchemas[i]);
                continue;
            }
            byteLen += ReadWriteIOUtils.sizeToWrite((String)this.measurements[i]);
            ++byteLen;
        }
        return byteLen;
    }

    protected void serializeMeasurementSchemasToWAL(IWALByteBufferView buffer) {
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            if (IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
                WALWriteUtils.write(this.measurementSchemas[i], buffer);
                continue;
            }
            WALWriteUtils.write(this.measurements[i], buffer);
            WALWriteUtils.write(this.dataTypes[i], buffer);
        }
    }

    protected void deserializeMeasurementSchemas(DataInputStream stream) throws IOException {
        for (int i = 0; i < this.measurements.length; ++i) {
            if (IoTDBDescriptor.getInstance().getConfig().isClusterMode()) {
                this.measurementSchemas[i] = MeasurementSchema.deserializeFrom((InputStream)stream);
                this.measurements[i] = this.measurementSchemas[i].getMeasurementId();
                this.dataTypes[i] = this.measurementSchemas[i].getType();
                continue;
            }
            this.measurements[i] = ReadWriteIOUtils.readString((InputStream)stream);
            this.dataTypes[i] = TSDataType.deserialize((byte)ReadWriteIOUtils.readByte((InputStream)stream));
        }
    }

    protected void deserializeMeasurementSchemas(ByteBuffer buffer) {
        for (int i = 0; i < this.measurements.length; ++i) {
            this.measurementSchemas[i] = MeasurementSchema.deserializeFrom((ByteBuffer)buffer);
            this.measurements[i] = this.measurementSchemas[i].getMeasurementId();
        }
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.dataRegionReplicaSet;
    }

    public abstract long getMinTime();

    public boolean isSyncFromLeaderWhenUsingIoTConsensus() {
        return this.searchIndex == -1L;
    }

    public void markFailedMeasurement(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean hasValidMeasurements() {
        for (String o : this.measurements) {
            if (o == null) continue;
            return true;
        }
        return false;
    }

    public void setFailedMeasurementNumber(int failedMeasurementNumber) {
        this.failedMeasurementNumber = failedMeasurementNumber;
    }

    public int getFailedMeasurementNumber() {
        return this.failedMeasurementNumber;
    }

    public final ProgressIndex getProgressIndex() {
        return this.progressIndex;
    }

    public void setProgressIndex(ProgressIndex progressIndex) {
        this.progressIndex = progressIndex;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertNode that = (InsertNode)o;
        return this.isAligned == that.isAligned && Objects.equals(this.devicePath, that.devicePath) && Arrays.equals(this.measurementSchemas, that.measurementSchemas) && Arrays.equals(this.measurements, that.measurements) && Arrays.equals(this.dataTypes, that.dataTypes) && Objects.equals(this.deviceID, that.deviceID) && Objects.equals(this.dataRegionReplicaSet, that.dataRegionReplicaSet);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.devicePath, this.isAligned, this.deviceID, this.dataRegionReplicaSet);
        result = 31 * result + Arrays.hashCode(this.measurementSchemas);
        result = 31 * result + Arrays.hashCode(this.measurements);
        result = 31 * result + Arrays.hashCode(this.dataTypes);
        return result;
    }
}

