/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.crud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.operator.window.WindowType;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.component.FillComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.FromComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByLevelComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByTagComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.HavingCondition;
import org.apache.iotdb.db.queryengine.plan.statement.component.IntoComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.OrderByComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.queryengine.plan.statement.component.ResultSetFormat;
import org.apache.iotdb.db.queryengine.plan.statement.component.SelectComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.apache.iotdb.db.queryengine.plan.statement.component.WhereCondition;

public class QueryStatement
extends Statement {
    private SelectComponent selectComponent;
    private FromComponent fromComponent;
    private WhereCondition whereCondition;
    private HavingCondition havingCondition;
    private long rowLimit = 0L;
    private long rowOffset = 0L;
    private long seriesLimit = 0L;
    private long seriesOffset = 0L;
    private FillComponent fillComponent;
    private OrderByComponent orderByComponent;
    private ResultSetFormat resultSetFormat = ResultSetFormat.ALIGN_BY_TIME;
    private GroupByTimeComponent groupByTimeComponent;
    private GroupByLevelComponent groupByLevelComponent;
    private GroupByTagComponent groupByTagComponent;
    private GroupByComponent groupByComponent;
    private IntoComponent intoComponent;
    private boolean isCqQueryBody;
    private boolean isOutputEndTime = false;
    private boolean useWildcard = true;
    public static final String RAW_AGGREGATION_HYBRID_QUERY_ERROR_MSG = "Raw data and aggregation hybrid query is not supported.";

    public QueryStatement() {
        this.statementType = StatementType.QUERY;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public List<PartialPath> getPaths() {
        HashSet<PartialPath> authPaths = new HashSet<PartialPath>();
        List<PartialPath> prefixPaths = this.fromComponent.getPrefixPaths();
        List<ResultColumn> resultColumns = this.selectComponent.getResultColumns();
        for (ResultColumn resultColumn : resultColumns) {
            Expression expression = resultColumn.getExpression();
            authPaths.addAll(ExpressionAnalyzer.concatExpressionWithSuffixPaths(expression, prefixPaths));
        }
        return new ArrayList<PartialPath>(authPaths);
    }

    public SelectComponent getSelectComponent() {
        return this.selectComponent;
    }

    public void setSelectComponent(SelectComponent selectComponent) {
        this.selectComponent = selectComponent;
    }

    public FromComponent getFromComponent() {
        return this.fromComponent;
    }

    public void setFromComponent(FromComponent fromComponent) {
        this.fromComponent = fromComponent;
    }

    public boolean hasWhere() {
        return this.whereCondition != null;
    }

    public WhereCondition getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(WhereCondition whereCondition) {
        this.whereCondition = whereCondition;
    }

    public boolean hasHaving() {
        return this.havingCondition != null;
    }

    public HavingCondition getHavingCondition() {
        return this.havingCondition;
    }

    public void setHavingCondition(HavingCondition havingCondition) {
        this.havingCondition = havingCondition;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public long getRowOffset() {
        return this.rowOffset;
    }

    public void setRowOffset(long rowOffset) {
        this.rowOffset = rowOffset;
    }

    public long getSeriesLimit() {
        return this.seriesLimit;
    }

    public void setSeriesLimit(long seriesLimit) {
        this.seriesLimit = seriesLimit;
    }

    public long getSeriesOffset() {
        return this.seriesOffset;
    }

    public void setSeriesOffset(long seriesOffset) {
        this.seriesOffset = seriesOffset;
    }

    public FillComponent getFillComponent() {
        return this.fillComponent;
    }

    public void setFillComponent(FillComponent fillComponent) {
        this.fillComponent = fillComponent;
    }

    public OrderByComponent getOrderByComponent() {
        return this.orderByComponent;
    }

    public void setOrderByComponent(OrderByComponent orderByComponent) {
        this.orderByComponent = orderByComponent;
    }

    public void setResultSetFormat(ResultSetFormat resultSetFormat) {
        this.resultSetFormat = resultSetFormat;
    }

    public GroupByTimeComponent getGroupByTimeComponent() {
        return this.groupByTimeComponent;
    }

    public void setGroupByTimeComponent(GroupByTimeComponent groupByTimeComponent) {
        this.groupByTimeComponent = groupByTimeComponent;
    }

    public GroupByLevelComponent getGroupByLevelComponent() {
        return this.groupByLevelComponent;
    }

    public void setGroupByLevelComponent(GroupByLevelComponent groupByLevelComponent) {
        this.groupByLevelComponent = groupByLevelComponent;
    }

    public GroupByTagComponent getGroupByTagComponent() {
        return this.groupByTagComponent;
    }

    public void setGroupByTagComponent(GroupByTagComponent groupByTagComponent) {
        this.groupByTagComponent = groupByTagComponent;
    }

    public GroupByComponent getGroupByComponent() {
        return this.groupByComponent;
    }

    public void setGroupByComponent(GroupByComponent groupByComponent) {
        this.groupByComponent = groupByComponent;
    }

    public void setOutputEndTime(boolean outputEndTime) {
        this.isOutputEndTime = outputEndTime;
    }

    public boolean isOutputEndTime() {
        return this.isOutputEndTime;
    }

    public boolean isLastQuery() {
        return this.selectComponent.hasLast();
    }

    public boolean isAggregationQuery() {
        return this.selectComponent.isHasBuiltInAggregationFunction();
    }

    public boolean isGroupByLevel() {
        return this.groupByLevelComponent != null;
    }

    public boolean isGroupByTag() {
        return this.groupByTagComponent != null;
    }

    public boolean isGroupByTime() {
        return this.groupByTimeComponent != null;
    }

    public boolean isGroupBy() {
        return this.isGroupByTime() || this.groupByComponent != null;
    }

    private boolean isGroupByVariation() {
        return this.groupByComponent != null && this.groupByComponent.getWindowType() == WindowType.VARIATION_WINDOW;
    }

    private boolean isGroupByCondition() {
        return this.groupByComponent != null && this.groupByComponent.getWindowType() == WindowType.CONDITION_WINDOW;
    }

    private boolean isGroupByCount() {
        return this.groupByComponent != null && this.groupByComponent.getWindowType() == WindowType.COUNT_WINDOW;
    }

    private boolean hasAggregationFunction(Expression expression) {
        if (expression instanceof FunctionExpression) {
            return expression.isBuiltInAggregationFunctionExpression();
        }
        if (expression instanceof TimeSeriesOperand) {
            return false;
        }
        for (Expression subExpression : expression.getExpressions()) {
            if (subExpression.isBuiltInAggregationFunctionExpression()) continue;
            return false;
        }
        return true;
    }

    public boolean hasGroupByExpression() {
        return this.isGroupByVariation() || this.isGroupByCondition() || this.isGroupByCount();
    }

    public boolean hasOrderByExpression() {
        return !this.getExpressionSortItemList().isEmpty();
    }

    public boolean isAlignByDevice() {
        return this.resultSetFormat == ResultSetFormat.ALIGN_BY_DEVICE;
    }

    public boolean isOrderByTime() {
        return this.orderByComponent != null && this.orderByComponent.isOrderByTime();
    }

    public boolean isOrderByTimeseries() {
        return this.orderByComponent != null && this.orderByComponent.isOrderByTimeseries();
    }

    public boolean onlyOrderByTimeseries() {
        return this.isOrderByTimeseries() && this.orderByComponent.getSortItemList().size() == 1;
    }

    public boolean isOrderByDevice() {
        return this.orderByComponent != null && this.orderByComponent.isOrderByDevice();
    }

    public IntoComponent getIntoComponent() {
        return this.intoComponent;
    }

    public void setIntoComponent(IntoComponent intoComponent) {
        this.intoComponent = intoComponent;
    }

    public Ordering getResultTimeOrder() {
        if (this.orderByComponent == null || !this.orderByComponent.isOrderByTime()) {
            return Ordering.ASC;
        }
        return this.orderByComponent.getTimeOrder();
    }

    public Ordering getResultDeviceOrder() {
        if (this.orderByComponent == null || !this.orderByComponent.isOrderByDevice()) {
            return Ordering.ASC;
        }
        return this.orderByComponent.getDeviceOrder();
    }

    public boolean needPushDownSort() {
        return !this.isAggregationQuery() && this.hasOrderByExpression() && this.isOrderByBasedOnDevice();
    }

    public boolean isOrderByBasedOnDevice() {
        return this.orderByComponent != null && this.orderByComponent.isBasedOnDevice();
    }

    public boolean isOrderByBasedOnTime() {
        return this.orderByComponent != null && this.orderByComponent.isBasedOnTime();
    }

    public List<SortItem> getSortItemList() {
        if (this.orderByComponent == null) {
            return Collections.emptyList();
        }
        return this.orderByComponent.getSortItemList();
    }

    public List<Expression> getExpressionSortItemList() {
        if (this.orderByComponent == null) {
            return Collections.emptyList();
        }
        return this.orderByComponent.getExpressionSortItemList();
    }

    public void updateSortItems(Set<Expression> orderByExpressions) {
        Expression[] sortItemExpressions = orderByExpressions.toArray(new Expression[0]);
        List<SortItem> sortItems = this.getSortItemList();
        int expressionIndex = 0;
        for (int i = 0; i < sortItems.size() && expressionIndex < sortItemExpressions.length; ++i) {
            SortItem sortItem = sortItems.get(i);
            if (!sortItem.isExpression()) continue;
            sortItem.setExpression(sortItemExpressions[expressionIndex]);
            ++expressionIndex;
        }
    }

    public List<SortItem> getUpdatedSortItems(Set<Expression> orderByExpressions) {
        Expression[] sortItemExpressions = orderByExpressions.toArray(new Expression[0]);
        List<SortItem> sortItems = this.getSortItemList();
        ArrayList<SortItem> newSortItems = new ArrayList<SortItem>();
        int expressionIndex = 0;
        for (SortItem sortItem : sortItems) {
            SortItem newSortItem = new SortItem(sortItem.getSortKey(), sortItem.getOrdering(), sortItem.getNullOrdering());
            if (sortItem.isExpression()) {
                newSortItem.setExpression(sortItemExpressions[expressionIndex]);
                ++expressionIndex;
            }
            newSortItems.add(newSortItem);
        }
        return newSortItems;
    }

    public boolean hasFill() {
        return this.fillComponent != null;
    }

    public boolean hasOrderBy() {
        return this.orderByComponent != null;
    }

    public boolean isSelectInto() {
        return this.intoComponent != null;
    }

    public boolean isCqQueryBody() {
        return this.isCqQueryBody;
    }

    public void setCqQueryBody(boolean cqQueryBody) {
        this.isCqQueryBody = cqQueryBody;
    }

    public boolean hasLimit() {
        return this.rowLimit > 0L;
    }

    public boolean hasOffset() {
        return this.rowOffset > 0L;
    }

    public void setUseWildcard(boolean useWildcard) {
        this.useWildcard = useWildcard;
    }

    public boolean useWildcard() {
        return this.useWildcard;
    }

    public void semanticCheck() {
        Expression whereExpression;
        if (this.isAggregationQuery()) {
            List<Expression> list;
            if (this.groupByComponent != null && this.isGroupByLevel()) {
                throw new SemanticException("GROUP BY CLAUSES doesn't support GROUP BY LEVEL now.");
            }
            if (this.isGroupByLevel() && this.isAlignByDevice()) {
                throw new SemanticException("GROUP BY LEVEL does not support align by device now.");
            }
            if (this.isGroupByTag() && this.isAlignByDevice()) {
                throw new SemanticException("GROUP BY TAGS does not support align by device now.");
            }
            HashSet outputColumn = new HashSet();
            for (ResultColumn resultColumn : this.selectComponent.getResultColumns()) {
                if (resultColumn.getColumnType() != ResultColumn.ColumnType.AGGREGATION) {
                    throw new SemanticException(RAW_AGGREGATION_HYBRID_QUERY_ERROR_MSG);
                }
                outputColumn.add(resultColumn.getAlias() != null ? resultColumn.getAlias() : resultColumn.getExpression().getExpressionString());
            }
            for (Expression expression : this.getExpressionSortItemList()) {
                if (this.hasAggregationFunction(expression)) continue;
                throw new SemanticException(RAW_AGGREGATION_HYBRID_QUERY_ERROR_MSG);
            }
            if (this.isGroupByTag()) {
                if (this.hasHaving()) {
                    throw new SemanticException("Having clause is not supported yet in GROUP BY TAGS query");
                }
                for (String s : this.getGroupByTagComponent().getTagKeys()) {
                    if (!outputColumn.contains(s)) continue;
                    throw new SemanticException("Output column is duplicated with the tag key: " + s);
                }
                if (this.rowLimit > 0L || this.rowOffset > 0L || this.seriesLimit > 0L || this.seriesOffset > 0L) {
                    throw new SemanticException("Limit or slimit are not supported yet in GROUP BY TAGS");
                }
                for (ResultColumn resultColumn : this.selectComponent.getResultColumns()) {
                    Expression expression = resultColumn.getExpression();
                    if (expression instanceof FunctionExpression && expression.getExpressions().get(0) instanceof TimeSeriesOperand && expression.isBuiltInAggregationFunctionExpression()) continue;
                    throw new SemanticException(expression + " can't be used in group by tag. It will be supported in the future.");
                }
            }
            if (this.hasGroupByExpression() && (list = ExpressionAnalyzer.searchAggregationExpressions(this.groupByComponent.getControlColumnExpression())) != null && !list.isEmpty()) {
                throw new SemanticException("Aggregation expression shouldn't exist in group by clause");
            }
        } else {
            if (this.isGroupBy() || this.isGroupByLevel() || this.isGroupByTag()) {
                throw new SemanticException("Common queries and aggregated queries are not allowed to appear at the same time");
            }
            for (Expression expression : this.getExpressionSortItemList()) {
                if (!this.hasAggregationFunction(expression)) continue;
                throw new SemanticException(RAW_AGGREGATION_HYBRID_QUERY_ERROR_MSG);
            }
        }
        if (this.hasWhere() && ExpressionAnalyzer.identifyOutputColumnType(whereExpression = this.getWhereCondition().getPredicate(), true) == ResultColumn.ColumnType.AGGREGATION) {
            throw new SemanticException("aggregate functions are not supported in WHERE clause");
        }
        if (this.hasHaving()) {
            Expression havingExpression = this.getHavingCondition().getPredicate();
            if (ExpressionAnalyzer.identifyOutputColumnType(havingExpression, true) != ResultColumn.ColumnType.AGGREGATION) {
                throw new SemanticException("Expression of HAVING clause must to be an Aggregation");
            }
            if (!this.isAggregationQuery()) {
                throw new SemanticException("Expression of HAVING clause can not be used in NonAggregationQuery");
            }
            try {
                if (this.isGroupByLevel()) {
                    for (ResultColumn resultColumn : this.getSelectComponent().getResultColumns()) {
                        ExpressionAnalyzer.checkIsAllMeasurement(resultColumn.getExpression());
                    }
                    ExpressionAnalyzer.checkIsAllMeasurement(havingExpression);
                }
            }
            catch (SemanticException semanticException) {
                throw new SemanticException("When Having used with GroupByLevel: " + semanticException.getMessage());
            }
        }
        if (this.isAlignByDevice()) {
            try {
                for (ResultColumn resultColumn : this.selectComponent.getResultColumns()) {
                    ExpressionAnalyzer.checkIsAllMeasurement(resultColumn.getExpression());
                }
                if (this.hasGroupByExpression()) {
                    ExpressionAnalyzer.checkIsAllMeasurement(this.getGroupByComponent().getControlColumnExpression());
                }
                if (this.hasOrderByExpression()) {
                    for (Expression expression : this.getExpressionSortItemList()) {
                        ExpressionAnalyzer.checkIsAllMeasurement(expression);
                    }
                }
                if (this.getWhereCondition() != null) {
                    ExpressionAnalyzer.checkIsAllMeasurement(this.getWhereCondition().getPredicate());
                }
                if (this.hasHaving()) {
                    ExpressionAnalyzer.checkIsAllMeasurement(this.getHavingCondition().getPredicate());
                }
            }
            catch (SemanticException e) {
                throw new SemanticException("ALIGN BY DEVICE: " + e.getMessage());
            }
            if (this.isOrderByTimeseries()) {
                throw new SemanticException("Sorting by timeseries is only supported in last queries.");
            }
        }
        if (this.isLastQuery()) {
            if (this.isAlignByDevice()) {
                throw new SemanticException("Last query doesn't support align by device.");
            }
            for (ResultColumn resultColumn : this.selectComponent.getResultColumns()) {
                Expression expression;
                expression = resultColumn.getExpression();
                if (expression instanceof TimeSeriesOperand) continue;
                throw new SemanticException("Last queries can only be applied on raw time series.");
            }
            if (this.isOrderByDevice()) {
                throw new SemanticException("Sorting by device is only supported in ALIGN BY DEVICE queries.");
            }
            if (this.seriesLimit != 0L || this.seriesOffset != 0L) {
                throw new SemanticException("SLIMIT and SOFFSET can not be used in LastQuery.");
            }
        }
        if (!this.isAlignByDevice() && !this.isLastQuery()) {
            if (this.isOrderByTimeseries()) {
                throw new SemanticException("Sorting by timeseries is only supported in last queries.");
            }
            if (this.isOrderByDevice()) {
                throw new SemanticException("Sorting by device is only supported in ALIGN BY DEVICE queries.");
            }
        }
        if (this.isSelectInto()) {
            if (this.getSeriesLimit() > 0L) {
                throw new SemanticException("select into: slimit clauses are not supported.");
            }
            if (this.getSeriesOffset() > 0L) {
                throw new SemanticException("select into: soffset clauses are not supported.");
            }
            if (this.isLastQuery()) {
                throw new SemanticException("select into: last clauses are not supported.");
            }
            if (this.isGroupByTag()) {
                throw new SemanticException("select into: GROUP BY TAGS clause are not supported.");
            }
        }
    }

    public String constructFormattedSQL() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(this.selectComponent.toSQLString()).append("\n");
        if (this.isSelectInto()) {
            sqlBuilder.append("\t").append(this.intoComponent.toSQLString()).append("\n");
        }
        sqlBuilder.append("\t").append(this.fromComponent.toSQLString()).append("\n");
        if (this.hasWhere()) {
            sqlBuilder.append("\t").append(this.whereCondition.toSQLString()).append("\n");
        }
        if (this.isGroupByTime()) {
            sqlBuilder.append("\t").append(this.groupByTimeComponent.toSQLString()).append("\n");
        }
        if (this.isGroupByLevel()) {
            sqlBuilder.append("\t").append(this.groupByLevelComponent.toSQLString(this.isGroupByTime())).append("\n");
        }
        if (this.hasHaving()) {
            sqlBuilder.append("\t").append(this.havingCondition.toSQLString()).append("\n");
        }
        if (this.hasFill()) {
            sqlBuilder.append("\t").append(this.fillComponent.toSQLString()).append("\n");
        }
        if (this.hasOrderBy()) {
            sqlBuilder.append("\t").append(this.orderByComponent.toSQLString()).append("\n");
        }
        if (this.rowLimit != 0L) {
            sqlBuilder.append("\t").append("LIMIT").append(' ').append(this.rowLimit).append("\n");
        }
        if (this.rowOffset != 0L) {
            sqlBuilder.append("\t").append("OFFSET").append(' ').append(this.rowOffset).append("\n");
        }
        if (this.seriesLimit != 0L) {
            sqlBuilder.append("\t").append("SLIMIT").append(' ').append(this.seriesLimit).append("\n");
        }
        if (this.seriesOffset != 0L) {
            sqlBuilder.append("\t").append("SOFFSET").append(' ').append(this.seriesOffset).append("\n");
        }
        if (this.isAlignByDevice()) {
            sqlBuilder.append("\t").append("ALIGN BY DEVICE").append("\n");
        }
        sqlBuilder.append(';');
        return sqlBuilder.toString();
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitQuery(this, context);
    }
}

