/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata.view;

import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.schemaengine.schemaregion.view.ViewPathType;
import org.apache.iotdb.db.schemaengine.schemaregion.view.ViewPaths;

public class AlterLogicalViewStatement
extends Statement
implements IConfigStatement {
    private ViewPaths targetPaths;
    private ViewPaths sourcePaths;
    private QueryStatement queryStatement;

    public AlterLogicalViewStatement() {
        this.statementType = StatementType.ALTER_LOGICAL_VIEW;
        this.sourcePaths = new ViewPaths();
        this.targetPaths = new ViewPaths();
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.getTargetPathList();
    }

    public ViewPaths getTargetPaths() {
        return this.targetPaths;
    }

    public ViewPaths getSourcePaths() {
        return this.sourcePaths;
    }

    public List<PartialPath> getTargetPathList() {
        return this.targetPaths.fullPathList;
    }

    public QueryStatement getQueryStatement() {
        return this.queryStatement;
    }

    public void setSourceFullPaths(List<PartialPath> paths) {
        this.sourcePaths.setViewPathType(ViewPathType.FULL_PATH_LIST);
        this.sourcePaths.setFullPathList(paths);
    }

    public void setSourcePathsGroup(PartialPath prefixPath, List<PartialPath> suffixPaths) {
        this.sourcePaths.setViewPathType(ViewPathType.PATHS_GROUP);
        this.sourcePaths.setPrefixOfPathsGroup(prefixPath);
        this.sourcePaths.setSuffixOfPathsGroup(suffixPaths);
        this.sourcePaths.generateFullPathsFromPathsGroup();
    }

    public void setSourceQueryStatement(QueryStatement queryStatement) {
        this.sourcePaths.setViewPathType(ViewPathType.QUERY_STATEMENT);
        this.queryStatement = queryStatement;
    }

    public void setTargetFullPaths(List<PartialPath> paths) {
        this.targetPaths.setViewPathType(ViewPathType.FULL_PATH_LIST);
        this.targetPaths.setFullPathList(paths);
    }

    public void setTargetPathsGroup(PartialPath prefixPath, List<PartialPath> suffixPaths) {
        this.targetPaths.setViewPathType(ViewPathType.PATHS_GROUP);
        this.targetPaths.setPrefixOfPathsGroup(prefixPath);
        this.targetPaths.setSuffixOfPathsGroup(suffixPaths);
        this.targetPaths.generateFullPathsFromPathsGroup();
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitAlterLogicalView(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }
}

