/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.metric;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.schemaengine.metric.ISchemaEngineMetric;
import org.apache.iotdb.db.schemaengine.metric.SchemaEngineMemMetric;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.cache.CacheMemoryManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class SchemaEngineCachedMetric
implements ISchemaEngineMetric {
    private static final String RELEASE_THRESHOLD = "schema_file_release_threshold";
    private static final String FLUSH_THRESHOLD = "schema_file_flush_threshold";
    private static final String PINNED_NODE_NUM = "schema_file_pinned_num";
    private static final String UNPINNED_NODE_NUM = "schema_file_unpinned_num";
    private static final String PINNED_MEM_SIZE = "schema_file_pinned_mem";
    private static final String UNPINNED_MEM_SIZE = "schema_file_unpinned_mem";
    private static final String RELEASE_TIMER = "schema_file_release";
    private static final String FLUSH_TIMER = "schema_file_flush";
    private static final String RELEASE_THREAD_NUM = "schema_file_release_thread_num";
    private static final String FLUSH_THREAD_NUM = "schema_file_flush_thread_num";
    private final CachedSchemaEngineStatistics engineStatistics;
    private final SchemaEngineMemMetric schemaEngineMemMetric;

    public SchemaEngineCachedMetric(CachedSchemaEngineStatistics engineStatistics) {
        this.engineStatistics = engineStatistics;
        this.schemaEngineMemMetric = new SchemaEngineMemMetric(engineStatistics);
    }

    public void bindTo(AbstractMetricService metricService) {
        this.schemaEngineMemMetric.bindTo(metricService);
        metricService.gauge((long)((double)IoTDBDescriptor.getInstance().getConfig().getAllocateMemoryForSchemaRegion() * 0.6), Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RELEASE_THRESHOLD});
        metricService.gauge((long)((double)IoTDBDescriptor.getInstance().getConfig().getAllocateMemoryForSchemaRegion() * 0.75), Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), FLUSH_THRESHOLD});
        metricService.createAutoGauge(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, (Object)this.engineStatistics, CachedSchemaEngineStatistics::getPinnedMNodeNum, new String[]{Tag.NAME.toString(), PINNED_NODE_NUM});
        metricService.createAutoGauge(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, (Object)this.engineStatistics, CachedSchemaEngineStatistics::getUnpinnedMNodeNum, new String[]{Tag.NAME.toString(), UNPINNED_NODE_NUM});
        metricService.createAutoGauge(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, (Object)this.engineStatistics, CachedSchemaEngineStatistics::getPinnedMemorySize, new String[]{Tag.NAME.toString(), PINNED_MEM_SIZE});
        metricService.createAutoGauge(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, (Object)this.engineStatistics, CachedSchemaEngineStatistics::getUnpinnedMemorySize, new String[]{Tag.NAME.toString(), UNPINNED_MEM_SIZE});
        metricService.getOrCreateTimer(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RELEASE_TIMER});
        metricService.getOrCreateTimer(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), FLUSH_TIMER});
        metricService.createAutoGauge(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, (Object)CacheMemoryManager.getInstance(), CacheMemoryManager::getReleaseThreadNum, new String[]{Tag.NAME.toString(), RELEASE_THREAD_NUM});
        metricService.createAutoGauge(Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, (Object)CacheMemoryManager.getInstance(), CacheMemoryManager::getFlushThreadNum, new String[]{Tag.NAME.toString(), FLUSH_THREAD_NUM});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.schemaEngineMemMetric.unbindFrom(metricService);
        metricService.remove(MetricType.GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), RELEASE_THRESHOLD});
        metricService.remove(MetricType.GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), FLUSH_THRESHOLD});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), PINNED_NODE_NUM});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), UNPINNED_NODE_NUM});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), PINNED_MEM_SIZE});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), UNPINNED_MEM_SIZE});
        metricService.remove(MetricType.TIMER, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), RELEASE_TIMER});
        metricService.remove(MetricType.TIMER, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), FLUSH_TIMER});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), RELEASE_THREAD_NUM});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_ENGINE.toString(), new String[]{Tag.NAME.toString(), FLUSH_THREAD_NUM});
    }

    public void recordFlush(long milliseconds) {
        MetricService.getInstance().timer(milliseconds, TimeUnit.MILLISECONDS, Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), FLUSH_TIMER});
    }

    public void recordRelease(long milliseconds) {
        MetricService.getInstance().timer(milliseconds, TimeUnit.MILLISECONDS, Metric.SCHEMA_ENGINE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RELEASE_TIMER});
    }
}

