/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector;

import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.MNodeCollector;

public abstract class MNodeAboveDBCollector<T, N extends IMNode<N>>
extends MNodeCollector<T, N> {
    protected Set<PartialPath> involvedDatabaseMNodes = new HashSet<PartialPath>();

    protected MNodeAboveDBCollector(N startNode, PartialPath path, IMTreeStore<N> store, boolean isPrefixMatch) throws MetadataException {
        super(startNode, path, store, isPrefixMatch);
    }

    @Override
    protected boolean shouldVisitSubtreeOfFullMatchedNode(N node) {
        if (node.isDatabase()) {
            this.involvedDatabaseMNodes.add(this.getParentPartialPath().concatNode(node.getName()));
            return false;
        }
        return super.shouldVisitSubtreeOfFullMatchedNode(node);
    }

    @Override
    protected boolean shouldVisitSubtreeOfInternalMatchedNode(N node) {
        if (node.isDatabase()) {
            this.involvedDatabaseMNodes.add(this.getParentPartialPath().concatNode(node.getName()));
            return false;
        }
        return super.shouldVisitSubtreeOfInternalMatchedNode(node);
    }

    public Set<PartialPath> getInvolvedDatabaseMNodes() {
        return this.involvedDatabaseMNodes;
    }
}

