/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.validator;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.validator.CompactionValidator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class ResourceOnlyCompactionValidator
implements CompactionValidator {
    private ResourceOnlyCompactionValidator() {
    }

    public static ResourceOnlyCompactionValidator getInstance() {
        return ResourceOnlyCompactionValidatorHolder.INSTANCE;
    }

    @Override
    public boolean validateCompaction(TsFileManager manager, List<TsFileResource> targetTsFileList, String storageGroupName, long timePartition, boolean isInnerUnSequenceSpaceTask) throws IOException {
        if (isInnerUnSequenceSpaceTask) {
            return true;
        }
        return CompactionUtils.validateTsFileResources(manager, storageGroupName, timePartition);
    }

    private static class ResourceOnlyCompactionValidatorHolder {
        private static final ResourceOnlyCompactionValidator INSTANCE = new ResourceOnlyCompactionValidator();

        private ResourceOnlyCompactionValidatorHolder() {
        }
    }
}

