/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.modification;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class Deletion
extends Modification
implements Cloneable {
    private TimeRange timeRange;

    public Deletion(PartialPath path, long fileOffset, long endTime) {
        super(Modification.Type.DELETION, path, fileOffset);
        this.timeRange = new TimeRange(Long.MIN_VALUE, endTime);
        this.timeRange.setLeftClose(false);
        if (endTime == Long.MAX_VALUE) {
            this.timeRange.setRightClose(false);
        }
    }

    public Deletion(PartialPath path, long fileOffset, long startTime, long endTime) {
        super(Modification.Type.DELETION, path, fileOffset);
        this.timeRange = new TimeRange(startTime, endTime);
        if (startTime == Long.MIN_VALUE) {
            this.timeRange.setLeftClose(false);
        }
        if (endTime == Long.MAX_VALUE) {
            this.timeRange.setRightClose(false);
        }
    }

    public long getStartTime() {
        return this.timeRange.getMin();
    }

    public void setStartTime(long timestamp) {
        this.timeRange.setMin(timestamp);
    }

    public long getEndTime() {
        return this.timeRange.getMax();
    }

    public void setEndTime(long timestamp) {
        this.timeRange.setMax(timestamp);
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public boolean intersects(Deletion deletion) {
        if (super.equals(deletion)) {
            return this.timeRange.intersects(deletion.getTimeRange());
        }
        return false;
    }

    public void merge(Deletion deletion) {
        this.timeRange.merge(deletion.getTimeRange());
    }

    public long serializeWithoutFileOffset(DataOutputStream stream) throws IOException {
        long serializeSize = 0L;
        stream.writeLong(this.getStartTime());
        serializeSize += 8L;
        stream.writeLong(this.getEndTime());
        serializeSize += 8L;
        return serializeSize += (long)ReadWriteIOUtils.write((String)this.getPathString(), (OutputStream)stream);
    }

    public static Deletion deserializeWithoutFileOffset(DataInputStream stream) throws IOException, IllegalPathException {
        long startTime = stream.readLong();
        long endTime = stream.readLong();
        return new Deletion(new PartialPath(ReadWriteIOUtils.readString((InputStream)stream)), 0L, startTime, endTime);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Deletion)) {
            return false;
        }
        Deletion del = (Deletion)obj;
        return super.equals(obj) && del.timeRange.equals((Object)this.timeRange);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.timeRange);
    }

    public String toString() {
        return "Deletion{startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", type=" + (Object)((Object)this.type) + ", path=" + this.path + ", fileOffset=" + this.fileOffset + '}';
    }

    public Deletion clone() {
        return new Deletion(this.getPath(), this.getFileOffset(), this.getStartTime(), this.getEndTime());
    }
}

