/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.CheckpointType;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.MemTableInfo;
import org.apache.iotdb.db.utils.SerializedSize;

public class Checkpoint
implements SerializedSize {
    private static final int FIXED_SERIALIZED_SIZE = 5;
    private final CheckpointType type;
    private final List<MemTableInfo> memTableInfos;

    public Checkpoint(CheckpointType type, List<MemTableInfo> memTableInfos) {
        this.type = type;
        this.memTableInfos = memTableInfos;
    }

    @Override
    public int serializedSize() {
        int size = 5;
        for (MemTableInfo memTableInfo : this.memTableInfos) {
            size += memTableInfo.serializedSize();
        }
        return size;
    }

    public void serialize(ByteBuffer buffer) {
        buffer.put(this.type.getCode());
        buffer.putInt(this.memTableInfos.size());
        for (MemTableInfo memTableInfo : this.memTableInfos) {
            memTableInfo.serialize(buffer);
        }
    }

    public static Checkpoint deserialize(DataInputStream stream) throws IOException {
        byte typeNum = stream.readByte();
        CheckpointType type = CheckpointType.valueOf(typeNum);
        if (type == null) {
            throw new IOException("unrecognized checkpoint type " + typeNum);
        }
        int cnt = stream.readInt();
        ArrayList<MemTableInfo> memTableInfos = new ArrayList<MemTableInfo>(cnt);
        for (int i = 0; i < cnt; ++i) {
            MemTableInfo memTableInfo = MemTableInfo.deserialize(stream);
            memTableInfos.add(memTableInfo);
        }
        return new Checkpoint(type, memTableInfos);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.memTableInfos});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Checkpoint)) {
            return false;
        }
        Checkpoint other = (Checkpoint)obj;
        return this.type == other.type && Objects.equals(this.memTableInfos, other.memTableInfos);
    }

    public CheckpointType getType() {
        return this.type;
    }

    public List<MemTableInfo> getMemTableInfos() {
        return this.memTableInfos;
    }
}

