/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.receiver;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.receiver.airgap.IoTDBAirGapReceiverAgent;
import org.apache.iotdb.db.pipe.receiver.legacy.IoTDBLegacyPipeReceiverAgent;
import org.apache.iotdb.db.pipe.receiver.thrift.IoTDBThriftReceiverAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeReceiverAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeReceiverAgent.class);
    private final IoTDBThriftReceiverAgent thriftAgent = new IoTDBThriftReceiverAgent();
    private final IoTDBAirGapReceiverAgent airGapAgent = new IoTDBAirGapReceiverAgent();
    private final IoTDBLegacyPipeReceiverAgent legacyAgent = new IoTDBLegacyPipeReceiverAgent();

    public IoTDBThriftReceiverAgent thrift() {
        return this.thriftAgent;
    }

    public IoTDBAirGapReceiverAgent airGap() {
        return this.airGapAgent;
    }

    public IoTDBLegacyPipeReceiverAgent legacy() {
        return this.legacyAgent;
    }

    public void cleanPipeReceiverDir() {
        File receiverFileDir = new File(IoTDBDescriptor.getInstance().getConfig().getPipeReceiverFileDir());
        try {
            FileUtils.deleteDirectory((File)receiverFileDir);
            LOGGER.info("Clean pipe receiver dir {} successfully.", (Object)receiverFileDir);
        }
        catch (Exception e) {
            LOGGER.warn("Clean pipe receiver dir {} failed.", (Object)receiverFileDir, (Object)e);
        }
        try {
            FileUtils.forceMkdir((File)receiverFileDir);
            LOGGER.info("Create pipe receiver dir {} successfully.", (Object)receiverFileDir);
        }
        catch (IOException e) {
            LOGGER.warn("Create pipe receiver dir {} failed.", (Object)receiverFileDir, (Object)e);
        }
    }
}

