/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.runtime;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.db.pipe.extractor.realtime.listener.PipeInsertionDataNodeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeCronEventInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeCronEventInjector.class);
    private static final int CRON_EVENT_INJECTOR_INTERVAL_SECONDS = 1;
    private static final ScheduledExecutorService CRON_EVENT_INJECTOR_EXECUTOR = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.PIPE_RUNTIME_CRON_EVENT_INJECTOR.getName());
    private Future<?> injectorFuture;

    public synchronized void start() {
        if (this.injectorFuture == null) {
            this.injectorFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)CRON_EVENT_INJECTOR_EXECUTOR, this::inject, (long)1L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
            LOGGER.info("Pipe cron event injector is started successfully.");
        }
    }

    private synchronized void inject() {
        PipeInsertionDataNodeListener.getInstance().listenToHeartbeat(false);
    }

    public synchronized void stop() {
        if (this.injectorFuture != null) {
            this.injectorFuture.cancel(false);
            this.injectorFuture = null;
            LOGGER.info("Pipe cron event injector is stopped successfully.");
        }
    }
}

