/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.pipe.api.event.Event;

public abstract class EnrichedEvent
implements Event {
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    protected final PipeTaskMeta pipeTaskMeta;
    private final String pattern;
    protected boolean isPatternAndTimeParsed;

    protected EnrichedEvent(PipeTaskMeta pipeTaskMeta, String pattern) {
        this.pipeTaskMeta = pipeTaskMeta;
        this.pattern = pattern;
        this.isPatternAndTimeParsed = this.getPattern().equals("root");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean increaseReferenceCount(String holderMessage) {
        boolean isSuccessful = true;
        EnrichedEvent enrichedEvent = this;
        synchronized (enrichedEvent) {
            if (this.referenceCount.get() == 0) {
                isSuccessful = this.internallyIncreaseResourceReferenceCount(holderMessage);
            }
            this.referenceCount.incrementAndGet();
        }
        return isSuccessful;
    }

    public abstract boolean internallyIncreaseResourceReferenceCount(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decreaseReferenceCount(String holderMessage, boolean shouldReport) {
        boolean isSuccessful = true;
        EnrichedEvent enrichedEvent = this;
        synchronized (enrichedEvent) {
            if (this.referenceCount.get() == 1) {
                isSuccessful = this.internallyDecreaseResourceReferenceCount(holderMessage);
                if (shouldReport) {
                    this.reportProgress();
                }
            }
            this.referenceCount.decrementAndGet();
        }
        return isSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearReferenceCount(String holderMessage) {
        boolean isSuccessful = true;
        EnrichedEvent enrichedEvent = this;
        synchronized (enrichedEvent) {
            if (this.referenceCount.get() >= 1) {
                isSuccessful = this.internallyDecreaseResourceReferenceCount(holderMessage);
            }
            this.referenceCount.set(0);
        }
        return isSuccessful;
    }

    public abstract boolean internallyDecreaseResourceReferenceCount(String var1);

    protected void reportProgress() {
        if (this.pipeTaskMeta != null) {
            ProgressIndex progressIndex = this.getProgressIndex();
            this.pipeTaskMeta.updateProgressIndex((ProgressIndex)(progressIndex == null ? MinimumProgressIndex.INSTANCE : progressIndex));
        }
    }

    public abstract ProgressIndex getProgressIndex();

    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    public final String getPattern() {
        return this.pattern == null ? "root" : this.pattern;
    }

    public boolean shouldParsePatternOrTime() {
        return !this.isPatternAndTimeParsed;
    }

    public abstract EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(PipeTaskMeta var1, String var2);

    public void reportException(PipeRuntimeException pipeRuntimeException) {
        if (this.pipeTaskMeta != null) {
            PipeAgent.runtime().report(this.pipeTaskMeta, pipeRuntimeException);
        }
    }

    public abstract boolean isGeneratedByPipe();
}

