/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.connection;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlockingPendingQueue<E extends Event> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockingPendingQueue.class);
    private static final long MAX_BLOCKING_TIME_MS = PipeConfig.getInstance().getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs();
    protected final BlockingQueue<E> pendingQueue;

    protected BlockingPendingQueue(BlockingQueue<E> pendingQueue) {
        this.pendingQueue = pendingQueue;
    }

    public boolean waitedOffer(E event) {
        try {
            return this.pendingQueue.offer(event, MAX_BLOCKING_TIME_MS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.info("pending queue offer is interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean directOffer(E event) {
        return this.pendingQueue.offer(event);
    }

    public boolean put(E event) {
        try {
            this.pendingQueue.put(event);
            return true;
        }
        catch (InterruptedException e) {
            LOGGER.info("pending queue put is interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public E directPoll() {
        return (E)((Event)this.pendingQueue.poll());
    }

    public E waitedPoll() {
        Event event = null;
        try {
            event = (Event)this.pendingQueue.poll(MAX_BLOCKING_TIME_MS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.info("pending queue poll is interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return (E)event;
    }

    public void clear() {
        this.pendingQueue.clear();
    }

    public void forEach(Consumer<? super E> action) {
        this.pendingQueue.forEach(action);
    }

    public int size() {
        return this.pendingQueue.size();
    }
}

