/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.thrift.impl;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.TimeZone;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.protocol.session.InternalClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.protocol.thrift.OperationType;
import org.apache.iotdb.db.protocol.thrift.impl.IMLNodeRPCServiceWithHandler;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.TFetchMoreDataReq;
import org.apache.iotdb.mpp.rpc.thrift.TFetchMoreDataResp;
import org.apache.iotdb.mpp.rpc.thrift.TFetchTimeseriesReq;
import org.apache.iotdb.mpp.rpc.thrift.TFetchTimeseriesResp;
import org.apache.iotdb.mpp.rpc.thrift.TFetchWindowBatchReq;
import org.apache.iotdb.mpp.rpc.thrift.TFetchWindowBatchResp;
import org.apache.iotdb.mpp.rpc.thrift.TRecordModelMetricsReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.TException;

public class MLNodeRPCServiceImpl
implements IMLNodeRPCServiceWithHandler {
    public static final String ML_METRICS_PATH_PREFIX = "root.__system.ml.exp";
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private final IPartitionFetcher partitionFetcher = ClusterPartitionFetcher.getInstance();
    private final ISchemaFetcher schemaFetcher = ClusterSchemaFetcher.getInstance();
    private final IClientSession session = new InternalClientSession("MLNodeService");

    public MLNodeRPCServiceImpl() {
        SESSION_MANAGER.registerSession(this.session);
        SESSION_MANAGER.supplySession(this.session, "MLNode", TimeZone.getDefault().getID(), IoTDBConstant.ClientVersion.V_1_0);
    }

    public TFetchTimeseriesResp fetchTimeseries(TFetchTimeseriesReq req) throws TException {
        boolean finished = false;
        TFetchTimeseriesResp resp = new TFetchTimeseriesResp();
        Throwable t = null;
        try {
            QueryStatement s = (QueryStatement)StatementGenerator.createStatement(req, this.session.getZoneId());
            long queryId = SESSION_MANAGER.requestQueryId(this.session, SESSION_MANAGER.requestStatementId(this.session));
            ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(this.session), "", this.partitionFetcher, this.schemaFetcher, req.getTimeout());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.status.code != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                resp.setStatus(result.status);
                TFetchTimeseriesResp tFetchTimeseriesResp = resp;
                return tFetchTimeseriesResp;
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            SetThreadName threadName = new SetThreadName(result.queryId.getId());
            try {
                DatasetHeader header = queryExecution.getDatasetHeader();
                resp.setStatus(result.status);
                resp.setColumnNameList(header.getRespColumns());
                resp.setColumnTypeList(header.getRespDataTypeList());
                resp.setColumnNameIndexMap(header.getColumnNameIndexMap());
                resp.setQueryId(queryId);
                Pair<List<ByteBuffer>, Boolean> pair = QueryDataSetUtils.convertQueryResultByFetchSize(queryExecution, req.fetchSize);
                resp.setTsDataset((List)pair.left);
                finished = (Boolean)pair.right;
                resp.setHasMoreData(!finished);
                TFetchTimeseriesResp tFetchTimeseriesResp = resp;
                threadName.close();
                return tFetchTimeseriesResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    t = e;
                    resp.setStatus(ErrorHandlingUtils.onQueryException(e, OperationType.EXECUTE_STATEMENT));
                    TFetchTimeseriesResp tFetchTimeseriesResp = resp;
                    return tFetchTimeseriesResp;
                }
                catch (Error error) {
                    t = error;
                    throw error;
                }
            }
        }
        finally {
            if (finished) {
                COORDINATOR.cleanupQueryExecution(resp.queryId, t);
            }
        }
    }

    public TFetchMoreDataResp fetchMoreData(TFetchMoreDataReq req) throws TException {
        TFetchMoreDataResp resp = new TFetchMoreDataResp();
        boolean finished = false;
        Throwable t = null;
        try {
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(req.queryId);
            resp.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
            if (queryExecution == null) {
                resp.setHasMoreData(false);
                TFetchMoreDataResp tFetchMoreDataResp = resp;
                return tFetchMoreDataResp;
            }
            SetThreadName queryName = new SetThreadName(queryExecution.getQueryId());
            try {
                Pair<List<ByteBuffer>, Boolean> pair = QueryDataSetUtils.convertQueryResultByFetchSize(queryExecution, req.fetchSize);
                List result = (List)pair.left;
                finished = (Boolean)pair.right;
                resp.setTsDataset(result);
                resp.setHasMoreData(!finished);
                TFetchMoreDataResp tFetchMoreDataResp = resp;
                queryName.close();
                return tFetchMoreDataResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        queryName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    t = e;
                    resp.setStatus(ErrorHandlingUtils.onQueryException(e, OperationType.FETCH_RESULTS));
                    TFetchMoreDataResp tFetchMoreDataResp = resp;
                    return tFetchMoreDataResp;
                }
                catch (Error error) {
                    t = error;
                    throw error;
                }
            }
        }
        finally {
            if (finished) {
                COORDINATOR.cleanupQueryExecution(req.queryId, t);
            }
        }
    }

    public TSStatus recordModelMetrics(TRecordModelMetricsReq req) throws TException {
        try {
            InsertRowStatement insertRowStatement = StatementGenerator.createStatement(req);
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(insertRowStatement, queryId, SESSION_MANAGER.getSessionInfo(this.session), "", this.partitionFetcher, this.schemaFetcher);
            return result.status;
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onQueryException(e, OperationType.INSERT_RECORD);
        }
    }

    public TFetchWindowBatchResp fetchWindowBatch(TFetchWindowBatchReq req) throws TException {
        throw new TException(new UnsupportedOperationException().getCause());
    }

    @Override
    public void handleExit() {
        SESSION_MANAGER.closeSession(this.session, COORDINATOR::cleanupQueryExecution);
    }
}

