/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.common.schematree.IMeasurementSchemaInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaComputation;
import org.apache.iotdb.db.schemaengine.template.ITemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceUsingTemplateSchemaCache {
    private static final Logger logger = LoggerFactory.getLogger(DeviceUsingTemplateSchemaCache.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Cache<PartialPath, DeviceCacheEntry> cache;
    private final ITemplateManager templateManager;

    DeviceUsingTemplateSchemaCache(ITemplateManager templateManager) {
        this.templateManager = templateManager;
        this.cache = Caffeine.newBuilder().maximumWeight(config.getAllocateMemoryForSchemaCache()).weigher((key, val) -> PartialPath.estimateSize((PartialPath)key) + 32).recordStats().build();
    }

    public long getHitCount() {
        return this.cache.stats().hitCount();
    }

    public long getRequestCount() {
        return this.cache.stats().requestCount();
    }

    public ClusterSchemaTree get(PartialPath fullPath) {
        Template template;
        IMeasurementSchema measurementSchema;
        DeviceCacheEntry deviceCacheEntry = (DeviceCacheEntry)this.cache.getIfPresent((Object)fullPath.getDevicePath());
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        if (deviceCacheEntry != null && (measurementSchema = (template = this.templateManager.getTemplate(deviceCacheEntry.getTemplateId())).getSchema(fullPath.getMeasurement())) != null) {
            schemaTree.appendSingleMeasurement(fullPath, (IMeasurementSchema)((MeasurementSchema)measurementSchema), null, null, template.isDirectAligned());
            schemaTree.setDatabases(Collections.singleton(deviceCacheEntry.getDatabase()));
        }
        return schemaTree;
    }

    public ClusterSchemaTree getMatchedSchemaWithTemplate(PartialPath path) {
        PartialPath devicePath = path.getDevicePath();
        DeviceCacheEntry deviceCacheEntry = (DeviceCacheEntry)this.cache.getIfPresent((Object)devicePath);
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        if (deviceCacheEntry != null) {
            Template template = this.templateManager.getTemplate(deviceCacheEntry.getTemplateId());
            String measurement = path.getMeasurement();
            if (PathPatternUtil.hasWildcard((String)measurement)) {
                for (Map.Entry<String, IMeasurementSchema> entry : template.getSchemaMap().entrySet()) {
                    if (!PathPatternUtil.isNodeMatch((String)measurement, (String)entry.getKey())) continue;
                    schemaTree.appendSingleMeasurement(devicePath.concatNode(entry.getKey()), entry.getValue(), null, null, template.isDirectAligned());
                    schemaTree.setDatabases(Collections.singleton(deviceCacheEntry.getDatabase()));
                }
            } else {
                IMeasurementSchema measurementSchema = template.getSchema(measurement);
                if (measurementSchema != null) {
                    schemaTree.appendSingleMeasurement(path, measurementSchema, null, null, template.isDirectAligned());
                    schemaTree.setDatabases(Collections.singleton(deviceCacheEntry.getDatabase()));
                }
            }
        }
        return schemaTree;
    }

    public List<Integer> compute(ISchemaComputation computation) {
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        PartialPath devicePath = computation.getDevicePath();
        String[] measurements = computation.getMeasurements();
        DeviceCacheEntry deviceCacheEntry = (DeviceCacheEntry)this.cache.getIfPresent((Object)devicePath);
        if (deviceCacheEntry == null) {
            for (int i = 0; i < measurements.length; ++i) {
                indexOfMissingMeasurements.add(i);
            }
            return indexOfMissingMeasurements;
        }
        computation.computeDevice(this.templateManager.getTemplate(deviceCacheEntry.getTemplateId()).isDirectAligned());
        Map<String, IMeasurementSchema> templateSchema = this.templateManager.getTemplate(deviceCacheEntry.getTemplateId()).getSchemaMap();
        for (int i = 0; i < measurements.length; ++i) {
            if (!templateSchema.containsKey(measurements[i])) {
                indexOfMissingMeasurements.add(i);
                continue;
            }
            final IMeasurementSchema schema = templateSchema.get(measurements[i]);
            computation.computeMeasurement(i, new IMeasurementSchemaInfo(){

                @Override
                public String getName() {
                    return schema.getMeasurementId();
                }

                @Override
                public IMeasurementSchema getSchema() {
                    if (this.isLogicalView()) {
                        return new LogicalViewSchema(schema.getMeasurementId(), ((LogicalViewSchema)schema).getExpression());
                    }
                    return this.getSchemaAsMeasurementSchema();
                }

                @Override
                public MeasurementSchema getSchemaAsMeasurementSchema() {
                    return new MeasurementSchema(schema.getMeasurementId(), schema.getType(), schema.getEncodingType(), schema.getCompressor());
                }

                @Override
                public LogicalViewSchema getSchemaAsLogicalViewSchema() {
                    throw new RuntimeException(new UnsupportedOperationException("Function getSchemaAsLogicalViewSchema is not supported in DeviceUsingTemplateSchemaCache."));
                }

                @Override
                public String getAlias() {
                    return null;
                }

                @Override
                public boolean isLogicalView() {
                    return schema.isLogicalView();
                }
            });
        }
        return indexOfMissingMeasurements;
    }

    public void put(PartialPath path, String database, Integer id) {
        this.cache.put((Object)path, (Object)new DeviceCacheEntry(database, id));
    }

    public void invalidateCache() {
        this.cache.invalidateAll();
    }

    private static class DeviceCacheEntry {
        private final String database;
        private final int templateId;

        private DeviceCacheEntry(String database, int templateId) {
            this.database = database.intern();
            this.templateId = templateId;
        }

        public int getTemplateId() {
            return this.templateId;
        }

        public String getDatabase() {
            return this.database;
        }
    }
}

