/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowDataNodesResp;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowDataNodesStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class ShowDataNodesTask
implements IConfigTask {
    private ShowDataNodesStatement showDataNodesStatement;

    public ShowDataNodesTask() {
    }

    public ShowDataNodesTask(ShowDataNodesStatement showDataNodesStatement) {
        this.showDataNodesStatement = showDataNodesStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showDataNodes(this.showDataNodesStatement);
    }

    public static void buildTSBlock(TShowDataNodesResp showDataNodesResp, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showDataNodesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        if (showDataNodesResp.getDataNodesInfoList() != null) {
            for (TDataNodeInfo dataNodeInfo : showDataNodesResp.getDataNodesInfoList()) {
                builder.getTimeColumnBuilder().writeLong(0L);
                builder.getColumnBuilder(0).writeInt(dataNodeInfo.getDataNodeId());
                builder.getColumnBuilder(1).writeBinary(Binary.valueOf((String)(dataNodeInfo.getStatus() == null ? "" : dataNodeInfo.getStatus())));
                builder.getColumnBuilder(2).writeBinary(Binary.valueOf((String)dataNodeInfo.getRpcAddresss()));
                builder.getColumnBuilder(3).writeInt(dataNodeInfo.getRpcPort());
                builder.getColumnBuilder(4).writeInt(dataNodeInfo.getDataRegionNum());
                builder.getColumnBuilder(5).writeInt(dataNodeInfo.getSchemaRegionNum());
                builder.declarePosition();
            }
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowDataNodesHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

