/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.udf;

import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.udf.service.UDFManagementService;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDTFExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDTFExecutor.class);
    protected final String functionName;
    protected final UDTFConfigurations configurations;
    protected UDTF udtf;
    protected ElasticSerializableTVList collector;
    protected Object currentValue;

    public UDTFExecutor(String functionName, ZoneId zoneId) {
        this.functionName = functionName;
        this.configurations = new UDTFConfigurations(zoneId);
    }

    public void beforeStart(String queryId, float collectorMemoryBudgetInMB, List<String> childExpressions, List<TSDataType> childExpressionDataTypes, Map<String, String> attributes) {
        this.reflectAndValidateUDF(childExpressions, childExpressionDataTypes, attributes);
        this.configurations.check();
        if (!AccessStrategy.AccessStrategyType.MAPPABLE_ROW_BY_ROW.equals((Object)this.configurations.getAccessStrategy().getAccessStrategyType())) {
            this.collector = ElasticSerializableTVList.newElasticSerializableTVList(UDFDataTypeTransformer.transformToTsDataType((Type)this.configurations.getOutputDataType()), queryId, collectorMemoryBudgetInMB, 1);
        }
    }

    private void reflectAndValidateUDF(List<String> childExpressions, List<TSDataType> childExpressionDataTypes, Map<String, String> attributes) {
        this.udtf = (UDTF)UDFManagementService.getInstance().reflect(this.functionName);
        UDFParameters parameters = new UDFParameters(childExpressions, UDFDataTypeTransformer.transformToUDFDataTypeList(childExpressionDataTypes), attributes);
        try {
            this.udtf.validate(new UDFParameterValidator(parameters));
        }
        catch (Exception e) {
            this.onError("validate(UDFParameterValidator)", e);
        }
        try {
            this.udtf.beforeStart(parameters, this.configurations);
        }
        catch (Exception e) {
            this.onError("beforeStart(UDFParameters, UDTFConfigurations)", e);
        }
    }

    public void execute(Row row, boolean isCurrentRowNull) {
        try {
            if (isCurrentRowNull) {
                this.collector.putNull(row.getTime());
            } else {
                this.udtf.transform(row, (PointCollector)this.collector);
            }
        }
        catch (Exception e) {
            this.onError("transform(Row, PointCollector)", e);
        }
    }

    public void execute(Row row) {
        try {
            this.currentValue = this.udtf.transform(row);
        }
        catch (Exception e) {
            this.onError("transform(Row)", e);
        }
    }

    public void execute(RowWindow rowWindow) {
        try {
            this.udtf.transform(rowWindow, (PointCollector)this.collector);
        }
        catch (Exception e) {
            this.onError("transform(RowWindow, PointCollector)", e);
        }
    }

    public Object getCurrentValue() {
        return this.currentValue;
    }

    public void terminate() {
        try {
            this.udtf.terminate((PointCollector)this.collector);
        }
        catch (Exception e) {
            this.onError("terminate(PointCollector)", e);
        }
    }

    public void beforeDestroy() {
        if (this.udtf != null) {
            this.udtf.beforeDestroy();
        }
    }

    private void onError(String methodName, Exception e) {
        LOGGER.warn("Error occurred during executing UDTF, please check whether the implementation of UDF is correct according to the udf-api description.", (Throwable)e);
        throw new RuntimeException(String.format("Error occurred during executing UDTF#%s: %s, please check whether the implementation of UDF is correct according to the udf-api description.", methodName, System.lineSeparator()) + e);
    }

    public UDTFConfigurations getConfigurations() {
        return this.configurations;
    }

    public ElasticSerializableTVList getCollector() {
        return this.collector;
    }
}

