/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.ResourceByPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IDeviceID;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.VectorMeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;

class AlignedResourceByPathUtils
extends ResourceByPathUtils {
    AlignedPath partialPath;

    public AlignedResourceByPathUtils(PartialPath partialPath) {
        this.partialPath = (AlignedPath)partialPath;
    }

    public AlignedTimeSeriesMetadata generateTimeSeriesMetadata(List<ReadOnlyMemChunk> readOnlyMemChunk, List<IChunkMetadata> chunkMetadataList) {
        int i;
        AlignedChunkMetadata alignedChunkMetadata;
        TimeseriesMetadata timeTimeSeriesMetadata = new TimeseriesMetadata();
        timeTimeSeriesMetadata.setOffsetOfChunkMetaDataList(-1L);
        timeTimeSeriesMetadata.setDataSizeOfChunkMetaDataList(-1);
        timeTimeSeriesMetadata.setMeasurementId("");
        timeTimeSeriesMetadata.setTsDataType(TSDataType.VECTOR);
        Statistics timeStatistics = Statistics.getStatsByType((TSDataType)timeTimeSeriesMetadata.getTsDataType());
        ArrayList<TimeseriesMetadata> valueTimeSeriesMetadataList = new ArrayList<TimeseriesMetadata>();
        for (Object valueChunkMetadata : this.partialPath.getSchemaList()) {
            TimeseriesMetadata valueMetadata = new TimeseriesMetadata();
            valueMetadata.setOffsetOfChunkMetaDataList(-1L);
            valueMetadata.setDataSizeOfChunkMetaDataList(-1);
            valueMetadata.setMeasurementId(valueChunkMetadata.getMeasurementId());
            valueMetadata.setTsDataType(valueChunkMetadata.getType());
            valueMetadata.setStatistics(Statistics.getStatsByType((TSDataType)valueChunkMetadata.getType()));
            valueTimeSeriesMetadataList.add(valueMetadata);
        }
        boolean[] exist = new boolean[this.partialPath.getSchemaList().size()];
        for (IChunkMetadata chunkMetadata : chunkMetadataList) {
            alignedChunkMetadata = (AlignedChunkMetadata)chunkMetadata;
            timeStatistics.mergeStatistics(alignedChunkMetadata.getTimeChunkMetadata().getStatistics());
            for (i = 0; i < valueTimeSeriesMetadataList.size(); ++i) {
                if (alignedChunkMetadata.getValueChunkMetadataList().get(i) == null) continue;
                exist[i] = true;
                ((TimeseriesMetadata)valueTimeSeriesMetadataList.get(i)).getStatistics().mergeStatistics(((IChunkMetadata)alignedChunkMetadata.getValueChunkMetadataList().get(i)).getStatistics());
            }
        }
        for (ReadOnlyMemChunk memChunk : readOnlyMemChunk) {
            if (memChunk.isEmpty()) continue;
            alignedChunkMetadata = (AlignedChunkMetadata)memChunk.getChunkMetaData();
            timeStatistics.mergeStatistics(alignedChunkMetadata.getTimeChunkMetadata().getStatistics());
            for (i = 0; i < valueTimeSeriesMetadataList.size(); ++i) {
                if (alignedChunkMetadata.getValueChunkMetadataList().get(i) == null) continue;
                exist[i] = true;
                ((TimeseriesMetadata)valueTimeSeriesMetadataList.get(i)).getStatistics().mergeStatistics(((IChunkMetadata)alignedChunkMetadata.getValueChunkMetadataList().get(i)).getStatistics());
            }
        }
        timeTimeSeriesMetadata.setStatistics(timeStatistics);
        for (int i2 = 0; i2 < valueTimeSeriesMetadataList.size(); ++i2) {
            if (exist[i2]) continue;
            valueTimeSeriesMetadataList.set(i2, null);
        }
        return new AlignedTimeSeriesMetadata(timeTimeSeriesMetadata, valueTimeSeriesMetadataList);
    }

    @Override
    public ReadOnlyMemChunk getReadOnlyMemChunkFromMemTable(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound) throws QueryProcessException, IOException {
        IDeviceID deviceID;
        Map<IDeviceID, IWritableMemChunkGroup> memTableMap = memTable.getMemTableMap();
        if (!memTableMap.containsKey(deviceID = DeviceIDFactory.getInstance().getDeviceID((PartialPath)this.partialPath))) {
            return null;
        }
        AlignedWritableMemChunk alignedMemChunk = ((AlignedWritableMemChunkGroup)memTableMap.get(deviceID)).getAlignedMemChunk();
        boolean containsMeasurement = false;
        for (String measurement : this.partialPath.getMeasurementList()) {
            if (!alignedMemChunk.containsMeasurement(measurement)) continue;
            containsMeasurement = true;
            break;
        }
        if (!containsMeasurement) {
            return null;
        }
        TVList alignedTvListCopy = alignedMemChunk.getSortedTvListForQuery(this.partialPath.getSchemaList());
        List<List<TimeRange>> deletionList = null;
        if (modsToMemtable != null) {
            deletionList = this.constructDeletionList(memTable, modsToMemtable, timeLowerBound);
        }
        return new AlignedReadOnlyMemChunk((IMeasurementSchema)this.getMeasurementSchema(), alignedTvListCopy, deletionList);
    }

    public VectorMeasurementSchema getMeasurementSchema() {
        List measurementList = this.partialPath.getMeasurementList();
        TSDataType[] types = new TSDataType[measurementList.size()];
        TSEncoding[] encodings = new TSEncoding[measurementList.size()];
        for (int i = 0; i < measurementList.size(); ++i) {
            types[i] = ((IMeasurementSchema)this.partialPath.getSchemaList().get(i)).getType();
            encodings[i] = ((IMeasurementSchema)this.partialPath.getSchemaList().get(i)).getEncodingType();
        }
        String[] array = new String[measurementList.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (String)measurementList.get(i);
        }
        return new VectorMeasurementSchema("", array, types, encodings, ((IMeasurementSchema)this.partialPath.getSchemaList().get(0)).getCompressor());
    }

    private List<List<TimeRange>> constructDeletionList(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound) {
        ArrayList<List<TimeRange>> deletionList = new ArrayList<List<TimeRange>>();
        for (String measurement : this.partialPath.getMeasurementList()) {
            ArrayList<TimeRange> columnDeletionList = new ArrayList<TimeRange>();
            columnDeletionList.add(new TimeRange(Long.MIN_VALUE, timeLowerBound));
            for (Modification modification : this.getModificationsForMemtable(memTable, modsToMemtable)) {
                if (!(modification instanceof Deletion)) continue;
                Deletion deletion = (Deletion)modification;
                PartialPath fullPath = this.partialPath.concatNode(measurement);
                if (!deletion.getPath().matchFullPath(fullPath) || deletion.getEndTime() <= timeLowerBound) continue;
                long lowerBound = Math.max(deletion.getStartTime(), timeLowerBound);
                columnDeletionList.add(new TimeRange(lowerBound, deletion.getEndTime()));
            }
            deletionList.add(TimeRange.sortAndMerge(columnDeletionList));
        }
        return deletionList;
    }

    @Override
    public List<IChunkMetadata> getVisibleMetadataListFromWriter(RestorableTsFileIOWriter writer, TsFileResource tsFileResource, QueryContext context) {
        int i;
        ModificationFile modificationFile = tsFileResource.getModFile();
        List<List<Modification>> modifications = context.getPathModifications(modificationFile, this.partialPath);
        ArrayList<AlignedChunkMetadata> chunkMetadataList = new ArrayList<AlignedChunkMetadata>();
        List timeChunkMetadataList = writer.getVisibleMetadataList(this.partialPath.getDevice(), "", this.partialPath.getSeriesType());
        ArrayList<List> valueChunkMetadataList = new ArrayList<List>();
        for (i = 0; i < this.partialPath.getMeasurementList().size(); ++i) {
            valueChunkMetadataList.add(writer.getVisibleMetadataList(this.partialPath.getDevice(), (String)this.partialPath.getMeasurementList().get(i), ((IMeasurementSchema)this.partialPath.getSchemaList().get(i)).getType()));
        }
        for (i = 0; i < timeChunkMetadataList.size(); ++i) {
            if (this.partialPath.getMeasurementList().isEmpty()) {
                chunkMetadataList.add(new AlignedChunkMetadata((IChunkMetadata)timeChunkMetadataList.get(i), Collections.emptyList()));
                continue;
            }
            ArrayList<IChunkMetadata> valueChunkMetadata = new ArrayList<IChunkMetadata>();
            boolean exits = false;
            for (List chunkMetadata : valueChunkMetadataList) {
                boolean currentExist = i < chunkMetadata.size();
                exits = exits || currentExist;
                valueChunkMetadata.add(currentExist ? (IChunkMetadata)chunkMetadata.get(i) : null);
            }
            if (!exits) continue;
            chunkMetadataList.add(new AlignedChunkMetadata((IChunkMetadata)timeChunkMetadataList.get(i), valueChunkMetadata));
        }
        ModificationUtils.modifyAlignedChunkMetaData(chunkMetadataList, modifications);
        chunkMetadataList.removeIf(context::chunkNotSatisfy);
        return new ArrayList<AlignedChunkMetadata>(chunkMetadataList);
    }
}

