/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceList;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.rescon.memory.TsFileResourceManager;
import org.apache.iotdb.tsfile.utils.TsFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");

    private CompactionExceptionHandler() {
    }

    public static void handleException(String fullStorageGroupName, File logFile, List<TsFileResource> targetResourceList, List<TsFileResource> seqResourceList, List<TsFileResource> unseqResourceList, TsFileManager tsFileManager, long timePartition, boolean isInnerSpace, boolean isTargetSequence) {
        String compactionType = isInnerSpace ? "inner" : "cross";
        try {
            if (logFile == null || !logFile.exists()) {
                return;
            }
            LOGGER.info("{} [Compaction][ExceptionHandler] {} space compaction start handling exception, source seqFiles is {}, source unseqFiles is {}.", new Object[]{fullStorageGroupName, compactionType, seqResourceList, unseqResourceList});
            boolean handleSuccess = true;
            ArrayList<TsFileResource> lostSourceFiles = new ArrayList<TsFileResource>();
            boolean allSourceSeqFilesExist = CompactionExceptionHandler.checkAllSourceFileExists(seqResourceList, lostSourceFiles);
            boolean allSourceUnseqFilesExist = CompactionExceptionHandler.checkAllSourceFileExists(unseqResourceList, lostSourceFiles);
            handleSuccess = allSourceSeqFilesExist && allSourceUnseqFilesExist ? CompactionExceptionHandler.handleWhenAllSourceFilesExist(targetResourceList, seqResourceList, unseqResourceList, tsFileManager, timePartition, isTargetSequence, fullStorageGroupName) : CompactionExceptionHandler.handleWhenSomeSourceFilesLost(targetResourceList, seqResourceList, unseqResourceList, lostSourceFiles, fullStorageGroupName);
            if (!handleSuccess) {
                LOGGER.error("[Compaction][ExceptionHandler] Fail to handle {} space compaction exception, set allowCompaction to false in {}", (Object)compactionType, (Object)fullStorageGroupName);
                tsFileManager.setAllowCompaction(false);
            } else {
                FileUtils.delete((File)logFile);
            }
        }
        catch (IOException e) {
            LOGGER.error("[Compaction][ExceptionHandler] exception occurs when handling exception in {} space compaction. Set allowCompaction to false in {}", new Object[]{compactionType, fullStorageGroupName, e});
            tsFileManager.setAllowCompaction(false);
        }
    }

    private static boolean checkAllSourceFileExists(List<TsFileResource> tsFileResources, List<TsFileResource> lostFiles) {
        for (TsFileResource tsFileResource : tsFileResources) {
            if (tsFileResource.getTsFile().exists() && tsFileResource.resourceFileExists()) continue;
            lostFiles.add(tsFileResource);
        }
        return lostFiles.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handleWhenAllSourceFilesExist(List<TsFileResource> targetResourceList, List<TsFileResource> sourceSeqResourceList, List<TsFileResource> sourceUnseqResourceList, TsFileManager tsFileManager, long timePartition, boolean isTargetSequence, String fullStorageGroupName) throws IOException {
        TsFileResourceList unseqTsFileResourceList = tsFileManager.getOrCreateUnsequenceListByTimePartition(timePartition);
        TsFileResourceList seqTsFileResourceList = tsFileManager.getOrCreateSequenceListByTimePartition(timePartition);
        CompactionUtils.deleteCompactionModsFile(sourceSeqResourceList, sourceUnseqResourceList);
        boolean removeAllTargetFile = true;
        tsFileManager.writeLock("CompactionExceptionHandler");
        try {
            for (TsFileResource targetTsFile : targetResourceList) {
                if (targetTsFile == null) continue;
                targetTsFile.writeLock();
                if (!targetTsFile.remove()) {
                    LOGGER.error("{} [Compaction][Exception] fail to delete target tsfile {} when handling exception", (Object)fullStorageGroupName, (Object)targetTsFile);
                    removeAllTargetFile = false;
                }
                targetTsFile.writeUnlock();
                if (!targetTsFile.isFileInList()) continue;
                if (isTargetSequence) {
                    seqTsFileResourceList.remove(targetTsFile);
                } else {
                    unseqTsFileResourceList.remove(targetTsFile);
                }
                TsFileResourceManager.getInstance().removeTsFileResource(targetTsFile);
            }
            for (TsFileResource tsFileResource : sourceSeqResourceList) {
                if (tsFileResource.isFileInList()) continue;
                seqTsFileResourceList.keepOrderInsert(tsFileResource);
                TsFileResourceManager.getInstance().registerSealedTsFileResource(tsFileResource);
            }
            for (TsFileResource tsFileResource : sourceUnseqResourceList) {
                if (tsFileResource.isFileInList()) continue;
                unseqTsFileResourceList.keepOrderInsert(tsFileResource);
                TsFileResourceManager.getInstance().registerSealedTsFileResource(tsFileResource);
            }
        }
        finally {
            tsFileManager.writeUnlock();
        }
        return removeAllTargetFile;
    }

    private static boolean handleWhenSomeSourceFilesLost(List<TsFileResource> targetResourceList, List<TsFileResource> sourceSeqResourceList, List<TsFileResource> sourceUnseqResourceList, List<TsFileResource> lostSourceResourceList, String fullStorageGroupName) throws IOException {
        if (!CompactionExceptionHandler.checkIsTargetFilesComplete(targetResourceList, lostSourceResourceList, fullStorageGroupName)) {
            return false;
        }
        for (TsFileResource resource : sourceSeqResourceList) {
            resource.remove();
        }
        for (TsFileResource resource : sourceUnseqResourceList) {
            resource.remove();
        }
        CompactionUtils.deleteCompactionModsFile(sourceSeqResourceList, sourceUnseqResourceList);
        return true;
    }

    private static boolean checkIsTargetFilesComplete(List<TsFileResource> targetResources, List<TsFileResource> lostSourceResources, String fullStorageGroupName) throws IOException {
        for (TsFileResource targetResource : targetResources) {
            if (targetResource.isDeleted()) {
                targetResource.remove();
                continue;
            }
            targetResource.setStatus(TsFileResourceStatus.NORMAL);
            if (TsFileUtils.isTsFileComplete((File)targetResource.getTsFile())) continue;
            LOGGER.error("{} [Compaction][ExceptionHandler] target file {} is not complete, and some source files {} is lost, do nothing. Set allowCompaction to false", new Object[]{fullStorageGroupName, targetResource, lostSourceResources});
            return false;
        }
        return true;
    }
}

