/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.BatchDataFactory;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.series.PaginationController;
import org.apache.iotdb.tsfile.utils.Binary;

public class MemPageReader
implements IPageReader {
    private final TsBlock tsBlock;
    private final IChunkMetadata chunkMetadata;
    private Filter valueFilter;
    private PaginationController paginationController = PaginationController.UNLIMITED_PAGINATION_CONTROLLER;

    public MemPageReader(TsBlock tsBlock, IChunkMetadata chunkMetadata, Filter filter) {
        this.tsBlock = tsBlock;
        this.chunkMetadata = chunkMetadata;
        this.valueFilter = filter;
    }

    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        TSDataType dataType = this.chunkMetadata.getDataType();
        BatchData batchData = BatchDataFactory.createBatchData((TSDataType)dataType, (boolean)ascending, (boolean)false);
        block8: for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
            if (this.valueFilter != null && !this.valueFilter.satisfy(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getObject(i))) continue;
            switch (dataType) {
                case BOOLEAN: {
                    batchData.putBoolean(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getBoolean(i));
                    continue block8;
                }
                case INT32: {
                    batchData.putInt(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getInt(i));
                    continue block8;
                }
                case INT64: {
                    batchData.putLong(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getLong(i));
                    continue block8;
                }
                case DOUBLE: {
                    batchData.putDouble(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getDouble(i));
                    continue block8;
                }
                case FLOAT: {
                    batchData.putFloat(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getFloat(i));
                    continue block8;
                }
                case TEXT: {
                    batchData.putBinary(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getBinary(i));
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.valueOf(dataType));
                }
            }
        }
        return batchData.flip();
    }

    private boolean pageSatisfy() {
        Statistics<? extends Serializable> statistics = this.getStatistics();
        if (this.valueFilter == null || this.valueFilter.allSatisfy(statistics)) {
            long rowCount = statistics.getCount();
            if (this.paginationController.hasCurOffset(rowCount)) {
                this.paginationController.consumeOffset(rowCount);
                return false;
            }
            return true;
        }
        return this.valueFilter.satisfy(statistics);
    }

    public TsBlock getAllSatisfiedData() {
        TSDataType dataType = this.chunkMetadata.getDataType();
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(dataType));
        TimeColumnBuilder timeBuilder = builder.getTimeColumnBuilder();
        ColumnBuilder valueBuilder = builder.getColumnBuilder(0);
        if (this.pageSatisfy()) {
            switch (dataType) {
                case BOOLEAN: {
                    this.doWithBoolean(builder, timeBuilder, valueBuilder);
                    break;
                }
                case INT32: {
                    this.doWithInt32(builder, timeBuilder, valueBuilder);
                    break;
                }
                case INT64: {
                    this.doWithInt64(builder, timeBuilder, valueBuilder);
                    break;
                }
                case FLOAT: {
                    this.doWithFloat(builder, timeBuilder, valueBuilder);
                    break;
                }
                case DOUBLE: {
                    this.doWithDouble(builder, timeBuilder, valueBuilder);
                    break;
                }
                case TEXT: {
                    this.doWithText(builder, timeBuilder, valueBuilder);
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.valueOf(dataType));
                }
            }
        }
        return builder.build();
    }

    private void doWithBoolean(TsBlockBuilder builder, TimeColumnBuilder timeBuilder, ColumnBuilder valueBuilder) {
        int endIndex = this.tsBlock.getPositionCount();
        for (int i = 0; i < endIndex; ++i) {
            boolean value;
            long time = this.tsBlock.getTimeColumn().getLong(i);
            if (!this.needCurrentBooleanRow(time, value = this.tsBlock.getColumn(0).getBoolean(i))) continue;
            if (this.paginationController.hasCurLimit()) {
                timeBuilder.writeLong(time);
                valueBuilder.writeBoolean(value);
                builder.declarePosition();
                this.paginationController.consumeLimit();
                continue;
            }
            endIndex = i;
        }
    }

    private boolean needCurrentBooleanRow(long time, boolean value) {
        if (this.valueFilter != null && !this.valueFilter.satisfy(time, (Object)value)) {
            return false;
        }
        if (this.paginationController.hasCurOffset()) {
            this.paginationController.consumeOffset();
            return false;
        }
        return true;
    }

    private void doWithInt32(TsBlockBuilder builder, TimeColumnBuilder timeBuilder, ColumnBuilder valueBuilder) {
        int endIndex = this.tsBlock.getPositionCount();
        for (int i = 0; i < endIndex; ++i) {
            int value;
            long time = this.tsBlock.getTimeColumn().getLong(i);
            if (!this.needCurrentInt32Row(time, value = this.tsBlock.getColumn(0).getInt(i))) continue;
            if (this.paginationController.hasCurLimit()) {
                timeBuilder.writeLong(time);
                valueBuilder.writeInt(value);
                builder.declarePosition();
                this.paginationController.consumeLimit();
                continue;
            }
            endIndex = i;
        }
    }

    private boolean needCurrentInt32Row(long time, int value) {
        if (this.valueFilter != null && !this.valueFilter.satisfy(time, (Object)value)) {
            return false;
        }
        if (this.paginationController.hasCurOffset()) {
            this.paginationController.consumeOffset();
            return false;
        }
        return true;
    }

    private void doWithInt64(TsBlockBuilder builder, TimeColumnBuilder timeBuilder, ColumnBuilder valueBuilder) {
        int endIndex = this.tsBlock.getPositionCount();
        for (int i = 0; i < endIndex; ++i) {
            long value;
            long time = this.tsBlock.getTimeColumn().getLong(i);
            if (!this.needCurrentInt64Row(time, value = this.tsBlock.getColumn(0).getLong(i))) continue;
            if (this.paginationController.hasCurLimit()) {
                timeBuilder.writeLong(time);
                valueBuilder.writeLong(value);
                builder.declarePosition();
                this.paginationController.consumeLimit();
                continue;
            }
            endIndex = i;
        }
    }

    private boolean needCurrentInt64Row(long time, long value) {
        if (this.valueFilter != null && !this.valueFilter.satisfy(time, (Object)value)) {
            return false;
        }
        if (this.paginationController.hasCurOffset()) {
            this.paginationController.consumeOffset();
            return false;
        }
        return true;
    }

    private void doWithFloat(TsBlockBuilder builder, TimeColumnBuilder timeBuilder, ColumnBuilder valueBuilder) {
        int endIndex = this.tsBlock.getPositionCount();
        for (int i = 0; i < endIndex; ++i) {
            float value;
            long time = this.tsBlock.getTimeColumn().getLong(i);
            if (!this.needCurrentFloatRow(time, value = this.tsBlock.getColumn(0).getFloat(i))) continue;
            if (this.paginationController.hasCurLimit()) {
                timeBuilder.writeLong(time);
                valueBuilder.writeFloat(value);
                builder.declarePosition();
                this.paginationController.consumeLimit();
                continue;
            }
            endIndex = i;
        }
    }

    private boolean needCurrentFloatRow(long time, float value) {
        if (this.valueFilter != null && !this.valueFilter.satisfy(time, (Object)Float.valueOf(value))) {
            return false;
        }
        if (this.paginationController.hasCurOffset()) {
            this.paginationController.consumeOffset();
            return false;
        }
        return true;
    }

    private void doWithDouble(TsBlockBuilder builder, TimeColumnBuilder timeBuilder, ColumnBuilder valueBuilder) {
        int endIndex = this.tsBlock.getPositionCount();
        for (int i = 0; i < endIndex; ++i) {
            double value;
            long time = this.tsBlock.getTimeColumn().getLong(i);
            if (!this.needCurrentDoubleRow(time, value = this.tsBlock.getColumn(0).getDouble(i))) continue;
            if (this.paginationController.hasCurLimit()) {
                timeBuilder.writeLong(time);
                valueBuilder.writeDouble(value);
                builder.declarePosition();
                this.paginationController.consumeLimit();
                continue;
            }
            endIndex = i;
        }
    }

    private boolean needCurrentDoubleRow(long time, double value) {
        if (this.valueFilter != null && !this.valueFilter.satisfy(time, (Object)value)) {
            return false;
        }
        if (this.paginationController.hasCurOffset()) {
            this.paginationController.consumeOffset();
            return false;
        }
        return true;
    }

    private void doWithText(TsBlockBuilder builder, TimeColumnBuilder timeBuilder, ColumnBuilder valueBuilder) {
        int endIndex = this.tsBlock.getPositionCount();
        for (int i = 0; i < endIndex; ++i) {
            Binary value;
            long time = this.tsBlock.getTimeColumn().getLong(i);
            if (!this.needCurrentTextRow(time, value = this.tsBlock.getColumn(0).getBinary(i))) continue;
            if (this.paginationController.hasCurLimit()) {
                timeBuilder.writeLong(time);
                valueBuilder.writeBinary(value);
                builder.declarePosition();
                this.paginationController.consumeLimit();
                continue;
            }
            endIndex = i;
        }
    }

    private boolean needCurrentTextRow(long time, Binary value) {
        if (this.valueFilter != null && !this.valueFilter.satisfy(time, (Object)value)) {
            return false;
        }
        if (this.paginationController.hasCurOffset()) {
            this.paginationController.consumeOffset();
            return false;
        }
        return true;
    }

    public Statistics<? extends Serializable> getStatistics() {
        return this.chunkMetadata.getStatistics();
    }

    public void setFilter(Filter filter) {
        this.valueFilter = this.valueFilter == null ? filter : new AndFilter(this.valueFilter, filter);
    }

    public void setLimitOffset(PaginationController paginationController) {
        this.paginationController = paginationController;
    }

    public boolean isModified() {
        return false;
    }

    public void initTsBlockBuilder(List<TSDataType> dataTypes) {
    }
}

