/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.utils;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryType;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALByteBufReader;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryPosition;
import org.apache.iotdb.tsfile.utils.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALInsertNodeCache {
    private static final Logger logger = LoggerFactory.getLogger(WALInsertNodeCache.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final LoadingCache<WALEntryPosition, Pair<ByteBuffer, InsertNode>> lruCache;
    private final boolean isBatchLoadEnabled;
    private final Set<Long> memTablesNeedSearch = ConcurrentHashMap.newKeySet();

    private WALInsertNodeCache() {
        this.lruCache = Caffeine.newBuilder().maximumWeight(config.getAllocateMemoryForWALPipeCache()).weigher((position, pair) -> position.getSize()).build((CacheLoader)new WALInsertNodeCacheLoader());
        this.isBatchLoadEnabled = config.getAllocateMemoryForWALPipeCache() >= 3L * config.getWalFileSizeThresholdInByte();
    }

    public boolean isBatchLoadEnabled() {
        return this.isBatchLoadEnabled;
    }

    public InsertNode getInsertNode(WALEntryPosition position) {
        Pair pair;
        Pair pair2 = pair = this.isBatchLoadEnabled ? (Pair)this.lruCache.getAll(Collections.singleton(position)).get(position) : (Pair)this.lruCache.get((Object)position);
        if (pair == null) {
            throw new IllegalStateException();
        }
        if (pair.getRight() == null) {
            pair.setRight((Object)this.parse((ByteBuffer)pair.getLeft()));
        }
        return (InsertNode)pair.getRight();
    }

    private InsertNode parse(ByteBuffer buffer) {
        PlanNode node = WALEntry.deserializeForConsensus(buffer);
        if (node instanceof InsertNode) {
            return (InsertNode)node;
        }
        return null;
    }

    public ByteBuffer getByteBuffer(WALEntryPosition position) {
        Pair pair;
        Pair pair2 = pair = this.isBatchLoadEnabled ? (Pair)this.lruCache.getAll(Collections.singleton(position)).get(position) : (Pair)this.lruCache.get((Object)position);
        if (pair == null) {
            throw new IllegalStateException();
        }
        return (ByteBuffer)pair.getLeft();
    }

    boolean contains(WALEntryPosition position) {
        return this.lruCache.getIfPresent((Object)position) != null;
    }

    public void addMemTable(long memTableId) {
        this.memTablesNeedSearch.add(memTableId);
    }

    public void removeMemTable(long memTableId) {
        this.memTablesNeedSearch.remove(memTableId);
    }

    public void clear() {
        this.lruCache.invalidateAll();
        this.memTablesNeedSearch.clear();
    }

    public static WALInsertNodeCache getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static class InstanceHolder {
        private static final WALInsertNodeCache INSTANCE = new WALInsertNodeCache();

        private InstanceHolder() {
        }
    }

    class WALInsertNodeCacheLoader
    implements CacheLoader<WALEntryPosition, Pair<ByteBuffer, InsertNode>> {
        WALInsertNodeCacheLoader() {
        }

        public @Nullable Pair<ByteBuffer, InsertNode> load(@NonNull WALEntryPosition key) throws Exception {
            return new Pair((Object)key.read(), null);
        }

        public @NonNull Map<@NonNull WALEntryPosition, @NonNull Pair<ByteBuffer, InsertNode>> loadAll(@NonNull Iterable<? extends @NonNull WALEntryPosition> keys) {
            HashMap<WALEntryPosition, Pair<ByteBuffer, InsertNode>> res = new HashMap<WALEntryPosition, Pair<ByteBuffer, InsertNode>>();
            for (WALEntryPosition wALEntryPosition : keys) {
                if (res.containsKey(wALEntryPosition) || !wALEntryPosition.canRead()) continue;
                long walFileVersionId = wALEntryPosition.getWalFileVersionId();
                if (!wALEntryPosition.isInSealedFile()) {
                    try {
                        res.put(wALEntryPosition, this.load(wALEntryPosition));
                    }
                    catch (Exception e) {
                        logger.info("Fail to cache wal entries from the wal file with version id {}", (Object)walFileVersionId, (Object)e);
                    }
                    continue;
                }
                long position = 0L;
                try {
                    FileChannel channel = wALEntryPosition.openReadFileChannel();
                    try (WALByteBufReader walByteBufReader = new WALByteBufReader(wALEntryPosition.getWalFile(), channel);){
                        while (walByteBufReader.hasNext()) {
                            ByteBuffer buffer = walByteBufReader.next();
                            int size = buffer.capacity();
                            WALEntryType type = WALEntryType.valueOf(buffer.get());
                            long memTableId = buffer.getLong();
                            if ((WALInsertNodeCache.this.memTablesNeedSearch.contains(memTableId) || wALEntryPosition.getPosition() == position) && type.needSearch()) {
                                buffer.clear();
                                res.put(new WALEntryPosition(wALEntryPosition.getIdentifier(), walFileVersionId, position, size), (Pair<ByteBuffer, InsertNode>)new Pair((Object)buffer, null));
                            }
                            position += (long)size;
                        }
                    }
                    finally {
                        if (channel == null) continue;
                        channel.close();
                    }
                }
                catch (IOException e) {
                    logger.info("Fail to cache wal entries from the wal file with version id {}", (Object)walFileVersionId, (Object)e);
                }
            }
            return res;
        }
    }
}

