/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.disk;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.utils.ProcessIdUtils;
import org.apache.iotdb.tsfile.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryChecker {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryChecker.class);
    private static final String LOCK_FILE_NAME = ".iotdb-lock";
    private final List<RandomAccessFile> randomAccessFileList = new ArrayList<RandomAccessFile>();
    private final List<File> fileList = new ArrayList<File>();

    private DirectoryChecker() {
    }

    public static DirectoryChecker getInstance() {
        return DirectoryCheckerHolder.INSTANCE;
    }

    public void registerDirectory(File dir) throws ConfigurationException, IOException {
        if (dir.exists() && !dir.isDirectory()) {
            throw new ConfigurationException(String.format("Unable to create directory %s because there is file under the path, please check configuration and restart.", dir.getAbsolutePath()));
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new ConfigurationException(String.format("Unable to create directory %s, please check configuration and restart.", dir.getAbsolutePath()));
        }
        File file = new File(dir, LOCK_FILE_NAME);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        FileChannel channel = randomAccessFile.getChannel();
        FileLock lock = null;
        try {
            lock = channel.tryLock();
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            // empty catch block
        }
        if (lock == null) {
            throw new ConfigurationException(String.format("Conflict is detected in directory %s, which may be being used by another IoTDB (ProcessId=%s). Please check configuration and restart.", dir.getAbsolutePath(), randomAccessFile.readLine()));
        }
        randomAccessFile.writeBytes(ProcessIdUtils.getProcessId());
        this.fileList.add(file);
        this.randomAccessFileList.add(randomAccessFile);
    }

    public boolean isCrossDisk(String[] dirs) throws IOException {
        if (dirs.length < 2) {
            return false;
        }
        Path root = this.mountOf(new File(dirs[0]).toPath());
        for (int i = 1; i < dirs.length; ++i) {
            if (!FSUtils.isLocal((String)dirs[i])) {
                return true;
            }
            Path path = this.mountOf(new File(dirs[i]).toPath());
            if (path.equals(root)) continue;
            return true;
        }
        return false;
    }

    private Path mountOf(Path p) throws IOException {
        Path temp;
        FileStore fs = Files.getFileStore(p);
        Path mountp = temp = p.toAbsolutePath();
        while ((temp = temp.getParent()) != null && fs.equals(Files.getFileStore(temp))) {
            mountp = temp;
        }
        return mountp;
    }

    public void deregisterAll() {
        try {
            for (RandomAccessFile randomAccessFile : this.randomAccessFileList) {
                randomAccessFile.close();
            }
            for (File file : this.fileList) {
                FileUtils.delete((File)file);
            }
        }
        catch (IOException e) {
            logger.warn("Failed to deregister file lock because {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static class DirectoryCheckerHolder {
        private static final DirectoryChecker INSTANCE = new DirectoryChecker();

        private DirectoryCheckerHolder() {
        }
    }
}

