/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata.DiskAlignedChunkMetadataLoader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata.DiskChunkMetadataLoader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata.MemAlignedChunkMetadataLoader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata.MemChunkMetadataLoader;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class FileLoaderUtils {
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();

    private FileLoaderUtils() {
    }

    public static void updateTsFileResource(TsFileSequenceReader reader, TsFileResource tsFileResource) throws IOException {
        FileLoaderUtils.updateTsFileResource(reader.getAllTimeseriesMetadata(false), tsFileResource);
        tsFileResource.updatePlanIndexes(reader.getMinPlanIndex());
        tsFileResource.updatePlanIndexes(reader.getMaxPlanIndex());
    }

    public static void updateTsFileResource(Map<String, List<TimeseriesMetadata>> device2Metadata, TsFileResource tsFileResource) {
        for (Map.Entry<String, List<TimeseriesMetadata>> entry : device2Metadata.entrySet()) {
            for (TimeseriesMetadata timeseriesMetaData : entry.getValue()) {
                tsFileResource.updateStartTime(entry.getKey(), timeseriesMetaData.getStatistics().getStartTime());
                tsFileResource.updateEndTime(entry.getKey(), timeseriesMetaData.getStatistics().getEndTime());
            }
        }
    }

    public static TsFileResource generateTsFileResource(TsFileIOWriter writer) {
        TsFileResource resource = new TsFileResource(writer.getFile());
        for (ChunkGroupMetadata chunkGroupMetadata : writer.getChunkGroupMetadataList()) {
            String device = chunkGroupMetadata.getDevice();
            for (ChunkMetadata chunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                resource.updateStartTime(device, chunkMetadata.getStartTime());
                resource.updateEndTime(device, chunkMetadata.getEndTime());
            }
        }
        resource.setStatus(TsFileResourceStatus.NORMAL);
        PipeAgent.runtime().assignRecoverProgressIndexForTsFileRecovery(resource);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TimeseriesMetadata loadTimeSeriesMetadata(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter filter, Set<String> allSensors) throws IOException {
        TimeseriesMetadata timeSeriesMetadata;
        boolean loadFromMem;
        long t1;
        block12: {
            long t2;
            block13: {
                t1 = System.nanoTime();
                loadFromMem = false;
                try {
                    if (resource.isClosed()) {
                        timeSeriesMetadata = TimeSeriesMetadataCache.getInstance().get(new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(resource.getTsFilePath(), seriesPath.getDevice(), seriesPath.getMeasurement()), allSensors, resource.getTimeIndexType() != 1, context.isDebug());
                        if (timeSeriesMetadata != null) {
                            timeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new DiskChunkMetadataLoader(resource, seriesPath, context, filter));
                        }
                    } else {
                        loadFromMem = true;
                        timeSeriesMetadata = (TimeseriesMetadata)resource.getTimeSeriesMetadata(seriesPath);
                        if (timeSeriesMetadata != null) {
                            timeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new MemChunkMetadataLoader(resource, seriesPath, context, filter));
                        }
                    }
                    if (timeSeriesMetadata == null) break block12;
                    t2 = System.nanoTime();
                    try {
                        List<Modification> pathModifications = context.getPathModifications(resource.getModFile(), seriesPath);
                        timeSeriesMetadata.setModified(!pathModifications.isEmpty());
                        if (timeSeriesMetadata.getStatistics().getStartTime() > timeSeriesMetadata.getStatistics().getEndTime()) {
                            TimeseriesMetadata timeseriesMetadata = null;
                            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("timeseries_metadata_modification_non_aligned", System.nanoTime() - t2);
                            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(loadFromMem ? "load_timeseries_metadata_non_aligned_mem" : "load_timeseries_metadata_non_aligned_disk", System.nanoTime() - t1);
                            return timeseriesMetadata;
                        }
                    }
                    catch (Throwable throwable) {
                        SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("timeseries_metadata_modification_non_aligned", System.nanoTime() - t2);
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(loadFromMem ? "load_timeseries_metadata_non_aligned_mem" : "load_timeseries_metadata_non_aligned_disk", System.nanoTime() - t1);
                    throw throwable;
                }
                {
                    if (filter == null || filter.satisfyStartEndTime(timeSeriesMetadata.getStatistics().getStartTime(), timeSeriesMetadata.getStatistics().getEndTime())) break block13;
                    TimeseriesMetadata timeseriesMetadata = null;
                    SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("timeseries_metadata_modification_non_aligned", System.nanoTime() - t2);
                    SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(loadFromMem ? "load_timeseries_metadata_non_aligned_mem" : "load_timeseries_metadata_non_aligned_disk", System.nanoTime() - t1);
                    return timeseriesMetadata;
                }
            }
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("timeseries_metadata_modification_non_aligned", System.nanoTime() - t2);
        }
        TimeseriesMetadata timeseriesMetadata = timeSeriesMetadata;
        SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(loadFromMem ? "load_timeseries_metadata_non_aligned_mem" : "load_timeseries_metadata_non_aligned_disk", System.nanoTime() - t1);
        return timeseriesMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AlignedTimeSeriesMetadata loadTimeSeriesMetadata(TsFileResource resource, AlignedPath alignedPath, QueryContext context, Filter filter, boolean queryAllSensors) throws IOException {
        block13: {
            block14: {
                t1 = System.nanoTime();
                loadFromMem = false;
                try {
                    if (resource.isClosed()) {
                        alignedTimeSeriesMetadata = FileLoaderUtils.loadFromDisk(resource, alignedPath, context, filter, queryAllSensors);
                    } else {
                        loadFromMem = true;
                        alignedTimeSeriesMetadata = (AlignedTimeSeriesMetadata)resource.getTimeSeriesMetadata((PartialPath)alignedPath);
                        if (alignedTimeSeriesMetadata != null) {
                            alignedTimeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new MemAlignedChunkMetadataLoader(resource, (PartialPath)alignedPath, context, filter, queryAllSensors));
                        }
                    }
                    if (alignedTimeSeriesMetadata == null) break block13;
                    t2 = System.nanoTime();
                    if (alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getStartTime() > alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getEndTime()) {
                        var11_10 = null;
                        FileLoaderUtils.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("timeseries_metadata_modification_aligned", System.nanoTime() - t2);
                        FileLoaderUtils.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(loadFromMem != false ? "load_timeseries_metadata_aligned_mem" : "load_timeseries_metadata_aligned_disk", System.nanoTime() - t1);
                        return var11_10;
                    }
                }
                catch (Throwable var13_13) {
                    FileLoaderUtils.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(loadFromMem != false ? "load_timeseries_metadata_aligned_mem" : "load_timeseries_metadata_aligned_disk", System.nanoTime() - t1);
                    throw var13_13;
                }
                {
                    if (filter == null || filter.satisfyStartEndTime(alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getStartTime(), alignedTimeSeriesMetadata.getTimeseriesMetadata().getStatistics().getEndTime())) break block14;
                    var11_11 = null;
                    FileLoaderUtils.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("timeseries_metadata_modification_aligned", System.nanoTime() - t2);
                    FileLoaderUtils.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(loadFromMem != false ? "load_timeseries_metadata_aligned_mem" : "load_timeseries_metadata_aligned_disk", System.nanoTime() - t1);
                    return var11_11;
                }
            }
            ** try [egrp 5[TRYBLOCK] [2 : 224->232)] { 
lbl32:
            // 1 sources

            FileLoaderUtils.setModifications(resource, alignedTimeSeriesMetadata, alignedPath, context);
            break block13;
lbl34:
            // 1 sources

            finally {
                FileLoaderUtils.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("timeseries_metadata_modification_aligned", System.nanoTime() - t2);
            }
        }
        var9_9 = alignedTimeSeriesMetadata;
        FileLoaderUtils.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(loadFromMem != false ? "load_timeseries_metadata_aligned_mem" : "load_timeseries_metadata_aligned_disk", System.nanoTime() - t1);
        return var9_9;
    }

    private static AlignedTimeSeriesMetadata loadFromDisk(TsFileResource resource, AlignedPath alignedPath, QueryContext context, Filter filter, boolean queryAllSensors) throws IOException {
        AlignedTimeSeriesMetadata alignedTimeSeriesMetadata = null;
        TimeSeriesMetadataCache cache = TimeSeriesMetadataCache.getInstance();
        List valueMeasurementList = alignedPath.getMeasurementList();
        HashSet<String> allSensors = new HashSet<String>(valueMeasurementList);
        allSensors.add("");
        boolean isDebug = context.isDebug();
        String filePath = resource.getTsFilePath();
        String deviceId = alignedPath.getDevice();
        TimeseriesMetadata timeColumn = cache.get(new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(filePath, deviceId, ""), allSensors, resource.getTimeIndexType() != 1, isDebug);
        if (timeColumn != null) {
            if (valueMeasurementList.isEmpty()) {
                alignedTimeSeriesMetadata = new AlignedTimeSeriesMetadata(timeColumn, Collections.emptyList());
                alignedTimeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new DiskAlignedChunkMetadataLoader(resource, alignedPath, context, filter, queryAllSensors));
            } else {
                ArrayList<TimeseriesMetadata> valueTimeSeriesMetadataList = new ArrayList<TimeseriesMetadata>(valueMeasurementList.size());
                boolean exist = false;
                for (String valueMeasurement : valueMeasurementList) {
                    TimeseriesMetadata valueColumn = cache.get(new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(filePath, deviceId, valueMeasurement), allSensors, resource.getTimeIndexType() != 1, isDebug);
                    exist = exist || valueColumn != null;
                    valueTimeSeriesMetadataList.add(valueColumn);
                }
                if (exist) {
                    alignedTimeSeriesMetadata = new AlignedTimeSeriesMetadata(timeColumn, valueTimeSeriesMetadataList);
                    alignedTimeSeriesMetadata.setChunkMetadataLoader((IChunkMetadataLoader)new DiskAlignedChunkMetadataLoader(resource, alignedPath, context, filter, queryAllSensors));
                }
            }
        }
        return alignedTimeSeriesMetadata;
    }

    private static void setModifications(TsFileResource resource, AlignedTimeSeriesMetadata alignedTimeSeriesMetadata, AlignedPath alignedPath, QueryContext context) {
        List valueTimeSeriesMetadataList = alignedTimeSeriesMetadata.getValueTimeseriesMetadataList();
        boolean modified = false;
        for (int i = 0; i < valueTimeSeriesMetadataList.size(); ++i) {
            if (valueTimeSeriesMetadataList.get(i) == null) continue;
            List<Modification> pathModifications = context.getPathModifications(resource.getModFile(), alignedPath.getPathWithMeasurement(i));
            ((TimeseriesMetadata)valueTimeSeriesMetadataList.get(i)).setModified(!pathModifications.isEmpty());
            modified = modified || !pathModifications.isEmpty();
        }
        alignedTimeSeriesMetadata.getTimeseriesMetadata().setModified(modified);
    }

    public static List<IChunkMetadata> loadChunkMetadataList(ITimeSeriesMetadata timeSeriesMetadata) {
        return timeSeriesMetadata.loadChunkMetadataList();
    }

    public static List<IPageReader> loadPageReaderList(IChunkMetadata chunkMetaData, Filter timeFilter) throws IOException {
        if (chunkMetaData == null) {
            throw new IOException("Can't init null chunkMeta");
        }
        IChunkLoader chunkLoader = chunkMetaData.getChunkLoader();
        IChunkReader chunkReader = chunkLoader.getChunkReader(chunkMetaData, timeFilter);
        return chunkReader.loadPageReaderList();
    }
}

