/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler;

import java.util.Optional;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBThriftAsyncConnector;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeTransferTabletInsertionEventHandler<E extends TPipeTransferResp>
implements AsyncMethodCallback<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferTabletInsertionEventHandler.class);
    private final long requestCommitId;
    private final Event event;
    private final TPipeTransferReq req;
    private final IoTDBThriftAsyncConnector connector;

    protected PipeTransferTabletInsertionEventHandler(long requestCommitId, Event event, TPipeTransferReq req, IoTDBThriftAsyncConnector connector) {
        this.requestCommitId = requestCommitId;
        this.event = event;
        this.req = req;
        this.connector = connector;
        Optional.ofNullable(event).ifPresent(e -> {
            if (e instanceof EnrichedEvent) {
                ((EnrichedEvent)e).increaseReferenceCount(PipeTransferTabletInsertionEventHandler.class.getName());
            }
        });
    }

    public void transfer(AsyncPipeDataTransferServiceClient client) throws TException {
        this.doTransfer(client, this.req);
    }

    protected abstract void doTransfer(AsyncPipeDataTransferServiceClient var1, TPipeTransferReq var2) throws TException;

    public void onComplete(TPipeTransferResp response) {
        if (response == null) {
            this.onError((Exception)((Object)new PipeException("TPipeTransferResp is null")));
            return;
        }
        if (response.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.connector.commit(this.requestCommitId, this.event instanceof EnrichedEvent ? (EnrichedEvent)this.event : null);
        } else {
            this.onError((Exception)((Object)new PipeException(response.getStatus().getMessage())));
        }
    }

    public void onError(Exception exception) {
        LOGGER.warn("Failed to transfer TabletInsertionEvent {} (request commit id={}).", new Object[]{this.event, this.requestCommitId, exception});
        this.connector.addFailureEventToRetryQueue(this.requestCommitId, this.event);
    }
}

