/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.sync;

import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class IoTDBThriftSyncConnectorClient
extends IClientRPCService.Client
implements ThriftClient,
AutoCloseable {
    public IoTDBThriftSyncConnectorClient(ThriftClientProperty property, String ipAddress, int port) throws TTransportException {
        super(property.getProtocolFactory().getProtocol(RpcTransportFactory.INSTANCE.getTransport((TTransport)new TSocket(TConfigurationConst.defaultTConfiguration, ipAddress, port, (int)PipeConfig.getInstance().getPipeConnectorTimeoutMs()))));
        this.getInputProtocol().getTransport().open();
    }

    @Override
    public void close() throws Exception {
        this.invalidate();
    }

    public void invalidate() {
        if (this.getInputProtocol().getTransport().isOpen()) {
            this.getInputProtocol().getTransport().close();
        }
    }

    public void invalidateAll() {
        this.invalidate();
    }

    public boolean printLogWhenEncounterException() {
        return true;
    }
}

