/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.load;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.queryengine.execution.load.TsFileData;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class DeletionData
implements TsFileData {
    private final Deletion deletion;

    public DeletionData(Deletion deletion) {
        this.deletion = deletion;
    }

    @Override
    public long getDataSize() {
        return 8L;
    }

    @Override
    public void writeToFileWriter(TsFileIOWriter writer) throws IOException {
        File tsFile = writer.getFile();
        try (ModificationFile modificationFile = new ModificationFile(tsFile.getAbsolutePath() + ".mods");){
            writer.flush();
            this.deletion.setFileOffset(tsFile.length());
            modificationFile.write(this.deletion);
        }
    }

    @Override
    public boolean isModification() {
        return true;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((Boolean)this.isModification(), (OutputStream)stream);
        this.deletion.serializeWithoutFileOffset(stream);
    }

    public static DeletionData deserialize(InputStream stream) throws IllegalPathException, IOException {
        return new DeletionData(Deletion.deserializeWithoutFileOffset(new DataInputStream(stream)));
    }
}

