/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.literal;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.literal.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.statement.literal.DoubleLiteral;
import org.apache.iotdb.db.queryengine.plan.statement.literal.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.statement.literal.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.statement.literal.StringLiteral;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class Literal
extends StatementNode {
    public static Literal deserialize(ByteBuffer byteBuffer) {
        LiteralType type = LiteralType.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        switch (type) {
            case BOOLEAN: {
                return new BooleanLiteral(ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer));
            }
            case DOUBLE: {
                return new DoubleLiteral(ReadWriteIOUtils.readDouble((ByteBuffer)byteBuffer));
            }
            case LONG: {
                return new LongLiteral(ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer));
            }
            case STRING: {
                return new StringLiteral(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
            }
            case NULL: {
                return new NullLiteral();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown literal type: %s", new Object[]{type}));
    }

    public abstract void serialize(ByteBuffer var1);

    public abstract void serialize(DataOutputStream var1) throws IOException;

    public abstract boolean isDataTypeConsistency(TSDataType var1);

    public abstract String getDataTypeString();

    public boolean getBoolean() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public int getInt() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long getLong() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public float getFloat() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public double getDouble() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Binary getBinary() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public static enum LiteralType {
        BOOLEAN,
        DOUBLE,
        LONG,
        STRING,
        NULL;

    }
}

