/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.tool;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.Interval;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.OverlapStatistic;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.OverlapStatisticTool;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.PrintUtil;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.SequenceFileSubTaskThreadExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.SequenceFileTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.SingleSequenceFileTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.TsFileStatisticReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.UnseqSpaceStatistics;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.utils.Pair;

public class TimePartitionProcessTask {
    private final String timePartition;
    private final Pair<List<String>, List<String>> timePartitionFiles;
    private long sequenceSpaceCost = 0L;
    private long unsequenceSpaceCost = 0L;

    public TimePartitionProcessTask(String timePartition, Pair<List<String>, List<String>> timePartitionFiles) {
        this.timePartition = timePartition;
        this.timePartitionFiles = timePartitionFiles;
    }

    public OverlapStatistic processTimePartition(SequenceFileSubTaskThreadExecutor fileTaskExecutor) {
        long startTime = System.currentTimeMillis();
        UnseqSpaceStatistics unseqSpaceStatistics = this.buildUnseqSpaceStatistics((List)this.timePartitionFiles.right);
        OverlapStatistic partialRet = this.processSequenceSpaceAsync(fileTaskExecutor, unseqSpaceStatistics, (List)this.timePartitionFiles.left);
        OverlapStatisticTool.outputInfolock.lock();
        ++OverlapStatisticTool.processedTimePartitionCount;
        OverlapStatisticTool.processedSeqFileCount += partialRet.totalSequenceFile;
        PrintUtil.printOneStatistics(partialRet, this.timePartition);
        System.out.printf("Worker" + Thread.currentThread().getName() + " Time cost: %.2fs, Sequence space cost: %.2fs, Build unsequence space cost: %.2fs.\n", ((double)System.currentTimeMillis() - (double)startTime) / 1000.0, (double)this.sequenceSpaceCost / 1000.0, (double)this.unsequenceSpaceCost / 1000.0);
        OverlapStatisticTool.outputInfolock.unlock();
        return partialRet;
    }

    private UnseqSpaceStatistics buildUnseqSpaceStatistics(List<String> unseqFiles) {
        UnseqSpaceStatistics unseqSpaceStatistics = new UnseqSpaceStatistics();
        long startTime = System.currentTimeMillis();
        for (String unseqFile : unseqFiles) {
            File f = new File(unseqFile);
            if (!f.exists()) continue;
            unseqSpaceStatistics.unsequenceFileSize += f.length();
            try (TsFileStatisticReader reader = new TsFileStatisticReader(unseqFile);){
                List<TsFileStatisticReader.ChunkGroupStatistics> chunkGroupStatisticsList = reader.getChunkGroupStatisticsList();
                unseqSpaceStatistics.unsequenceChunkGroupNum += (long)chunkGroupStatisticsList.size();
                for (TsFileStatisticReader.ChunkGroupStatistics statistics : chunkGroupStatisticsList) {
                    long deviceStartTime = Long.MAX_VALUE;
                    long deviceEndTime = Long.MIN_VALUE;
                    for (ChunkMetadata chunkMetadata : statistics.getChunkMetadataList()) {
                        unseqSpaceStatistics.unsequenceChunkNum += chunkMetadata.getNumOfPoints();
                        deviceStartTime = Math.min(deviceStartTime, chunkMetadata.getStartTime());
                        deviceEndTime = Math.max(deviceEndTime, chunkMetadata.getEndTime());
                        unseqSpaceStatistics.setMinStartTime(deviceStartTime);
                        unseqSpaceStatistics.setMaxEndTime(deviceEndTime);
                        if (chunkMetadata.getStartTime() > chunkMetadata.getEndTime()) continue;
                        unseqSpaceStatistics.updateMeasurement(statistics.getDeviceID(), chunkMetadata.getMeasurementUid(), new Interval(chunkMetadata.getStartTime(), chunkMetadata.getEndTime()));
                    }
                    if (deviceStartTime > deviceEndTime) continue;
                    unseqSpaceStatistics.updateDevice(statistics.getDeviceID(), new Interval(deviceStartTime, deviceEndTime));
                }
            }
            catch (IOException e) {
                if (e instanceof NoSuchFileException) {
                    System.out.println(((NoSuchFileException)e).getFile() + " is not exist");
                    continue;
                }
                e.printStackTrace();
            }
        }
        this.unsequenceSpaceCost += System.currentTimeMillis() - startTime;
        unseqSpaceStatistics.unsequenceFileNum += (long)unseqFiles.size();
        return unseqSpaceStatistics;
    }

    public OverlapStatistic processSequenceSpaceAsync(SequenceFileSubTaskThreadExecutor executor, UnseqSpaceStatistics unseqSpaceStatistics, List<String> seqFiles) {
        long startTime = System.currentTimeMillis();
        OverlapStatistic overlapStatistic = new OverlapStatistic();
        ArrayList<Future<SequenceFileTaskSummary>> futures = new ArrayList<Future<SequenceFileTaskSummary>>();
        for (String string : seqFiles) {
            futures.add(executor.submit(new SingleSequenceFileTask(unseqSpaceStatistics, string)));
        }
        for (Future future : futures) {
            try {
                SequenceFileTaskSummary sequenceFileTaskSummary = (SequenceFileTaskSummary)future.get();
                overlapStatistic.mergeSingleSequenceFileTaskResult(sequenceFileTaskSummary);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        overlapStatistic.mergeUnSeqSpaceStatistics(unseqSpaceStatistics);
        this.sequenceSpaceCost += System.currentTimeMillis() - startTime;
        return overlapStatistic;
    }
}

