/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.flush.CompressionRatio;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class AlignedWritableMemChunk
implements IWritableMemChunk {
    private final Map<String, Integer> measurementIndexMap = new LinkedHashMap<String, Integer>();
    private final List<IMeasurementSchema> schemaList;
    private AlignedTVList list;
    private static final int MAX_NUMBER_OF_POINTS_IN_PAGE = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
    private static final String UNSUPPORTED_TYPE = "Unsupported data type:";
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();

    public AlignedWritableMemChunk(List<IMeasurementSchema> schemaList) {
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>();
        this.schemaList = schemaList;
        for (int i = 0; i < schemaList.size(); ++i) {
            this.measurementIndexMap.put(schemaList.get(i).getMeasurementId(), i);
            dataTypeList.add(schemaList.get(i).getType());
        }
        this.list = AlignedTVList.newAlignedList(dataTypeList);
    }

    private AlignedWritableMemChunk(List<IMeasurementSchema> schemaList, AlignedTVList list) {
        this.schemaList = schemaList;
        for (int i = 0; i < schemaList.size(); ++i) {
            this.measurementIndexMap.put(schemaList.get(i).getMeasurementId(), i);
        }
        this.list = list;
    }

    public Set<String> getAllMeasurements() {
        return this.measurementIndexMap.keySet();
    }

    public boolean containsMeasurement(String measurementId) {
        return this.measurementIndexMap.containsKey(measurementId);
    }

    @Override
    public void putLong(long t, long v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putInt(long t, int v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putFloat(long t, float v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putDouble(long t, double v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public boolean putBinaryWithFlushCheck(long t, Binary v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putBoolean(long t, boolean v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public boolean putAlignedValueWithFlushCheck(long t, Object[] v) {
        this.list.putAlignedValue(t, v);
        return this.list.reachMaxChunkSizeThreshold();
    }

    @Override
    public void putLongs(long[] t, long[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putInts(long[] t, int[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putFloats(long[] t, float[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putDoubles(long[] t, double[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public boolean putBinariesWithFlushCheck(long[] t, Binary[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public void putBooleans(long[] t, boolean[] v, BitMap bitMap, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public boolean putAlignedValuesWithFlushCheck(long[] t, Object[] v, BitMap[] bitMaps, int start, int end) {
        this.list.putAlignedValues(t, v, bitMaps, start, end);
        return this.list.reachMaxChunkSizeThreshold();
    }

    @Override
    public boolean writeWithFlushCheck(long insertTime, Object objectValue) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public boolean writeWithFlushCheck(long[] times, Object valueList, BitMap bitMap, TSDataType dataType, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + TSDataType.VECTOR);
    }

    @Override
    public boolean writeAlignedValueWithFlushCheck(long insertTime, Object[] objectValue, List<IMeasurementSchema> schemaList) {
        Object[] reorderedValue = (Object[])this.checkAndReorderColumnValuesInInsertPlan(schemaList, (Object[])objectValue, null).left;
        return this.putAlignedValueWithFlushCheck(insertTime, reorderedValue);
    }

    @Override
    public boolean writeAlignedValuesWithFlushCheck(long[] times, Object[] valueList, BitMap[] bitMaps, List<IMeasurementSchema> schemaList, int start, int end) {
        Pair<Object[], BitMap[]> pair = this.checkAndReorderColumnValuesInInsertPlan(schemaList, valueList, bitMaps);
        Object[] reorderedColumnValues = (Object[])pair.left;
        BitMap[] reorderedBitMaps = (BitMap[])pair.right;
        return this.putAlignedValuesWithFlushCheck(times, reorderedColumnValues, reorderedBitMaps, start, end);
    }

    private Pair<Object[], BitMap[]> checkAndReorderColumnValuesInInsertPlan(List<IMeasurementSchema> schemaListInInsertPlan, Object[] columnValues, BitMap[] bitMaps) {
        Object[] reorderedColumnValues = new Object[this.schemaList.size()];
        BitMap[] reorderedBitMaps = bitMaps == null ? null : new BitMap[this.schemaList.size()];
        for (int i = 0; i < schemaListInInsertPlan.size(); ++i) {
            IMeasurementSchema measurementSchema = schemaListInInsertPlan.get(i);
            if (measurementSchema == null) continue;
            Integer index = this.measurementIndexMap.get(measurementSchema.getMeasurementId());
            if (index == null) {
                index = this.measurementIndexMap.size();
                this.measurementIndexMap.put(schemaListInInsertPlan.get(i).getMeasurementId(), index);
                this.schemaList.add(schemaListInInsertPlan.get(i));
                this.list.extendColumn(schemaListInInsertPlan.get(i).getType());
                reorderedColumnValues = Arrays.copyOf(reorderedColumnValues, reorderedColumnValues.length + 1);
                if (reorderedBitMaps != null) {
                    reorderedBitMaps = Arrays.copyOf(reorderedBitMaps, reorderedBitMaps.length + 1);
                }
            }
            reorderedColumnValues[index.intValue()] = columnValues[i];
            if (bitMaps == null) continue;
            reorderedBitMaps[index.intValue()] = bitMaps[i];
        }
        return new Pair((Object)reorderedColumnValues, (Object)reorderedBitMaps);
    }

    @Override
    public TVList getTVList() {
        return this.list;
    }

    @Override
    public long count() {
        return (long)this.list.rowCount() * (long)this.measurementIndexMap.size();
    }

    public long alignedListSize() {
        return this.list.rowCount();
    }

    @Override
    public IMeasurementSchema getSchema() {
        return null;
    }

    @Override
    public long getMaxTime() {
        return this.list.getMaxTime();
    }

    @Override
    public synchronized TVList getSortedTvListForQuery() {
        this.sortTVList();
        this.list.increaseReferenceCount();
        return this.list;
    }

    @Override
    public synchronized TVList getSortedTvListForQuery(List<IMeasurementSchema> schemaList) {
        this.sortTVList();
        this.list.increaseReferenceCount();
        ArrayList<Integer> columnIndexList = new ArrayList<Integer>();
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>();
        for (IMeasurementSchema measurementSchema : schemaList) {
            columnIndexList.add(this.measurementIndexMap.getOrDefault(measurementSchema.getMeasurementId(), -1));
            dataTypeList.add(measurementSchema.getType());
        }
        return this.list.getTvListByColumnIndex(columnIndexList, dataTypeList);
    }

    private void sortTVList() {
        if (this.list.getReferenceCount() > 0 && !this.list.isSorted()) {
            this.list = this.list.clone();
        }
        if (!this.list.isSorted()) {
            this.list.sort();
        }
    }

    @Override
    public synchronized void sortTvListForFlush() {
        this.sortTVList();
    }

    @Override
    public int delete(long lowerBound, long upperBound) {
        return this.list.delete(lowerBound, upperBound);
    }

    public Pair<Integer, Boolean> deleteDataFromAColumn(long lowerBound, long upperBound, String measurementId) {
        return this.list.delete(lowerBound, upperBound, this.measurementIndexMap.get(measurementId));
    }

    public void removeColumn(String measurementId) {
        this.list.deleteColumn(this.measurementIndexMap.get(measurementId));
        IMeasurementSchema schemaToBeRemoved = this.schemaList.get(this.measurementIndexMap.get(measurementId));
        this.schemaList.remove(schemaToBeRemoved);
        this.measurementIndexMap.clear();
        for (int i = 0; i < this.schemaList.size(); ++i) {
            this.measurementIndexMap.put(this.schemaList.get(i).getMeasurementId(), i);
        }
    }

    @Override
    public IChunkWriter createIChunkWriter() {
        return new AlignedChunkWriterImpl(this.schemaList);
    }

    @Override
    public void encode(IChunkWriter chunkWriter) {
        AlignedChunkWriterImpl alignedChunkWriter = (AlignedChunkWriterImpl)chunkWriter;
        boolean[] timeDuplicateInfo = null;
        ArrayList<Integer> pageRange = new ArrayList<Integer>();
        int range = 0;
        for (int sortedRowIndex = 0; sortedRowIndex < this.list.rowCount(); ++sortedRowIndex) {
            long time = this.list.getTime(sortedRowIndex);
            if (range == 0) {
                pageRange.add(sortedRowIndex);
            }
            if (++range == MAX_NUMBER_OF_POINTS_IN_PAGE) {
                pageRange.add(sortedRowIndex);
                range = 0;
            }
            if (sortedRowIndex == this.list.rowCount() - 1 || time != this.list.getTime(sortedRowIndex + 1)) continue;
            if (Objects.isNull(timeDuplicateInfo)) {
                timeDuplicateInfo = new boolean[this.list.rowCount()];
            }
            timeDuplicateInfo[sortedRowIndex] = true;
        }
        if (range != 0) {
            pageRange.add(this.list.rowCount() - 1);
        }
        List<TSDataType> dataTypes = this.list.getTsDataTypes();
        Pair[] lastValidPointIndexForTimeDupCheck = new Pair[dataTypes.size()];
        for (int pageNum = 0; pageNum < pageRange.size() / 2; ++pageNum) {
            for (int columnIndex = 0; columnIndex < dataTypes.size(); ++columnIndex) {
                if (Objects.nonNull(timeDuplicateInfo) && lastValidPointIndexForTimeDupCheck[columnIndex] == null) {
                    lastValidPointIndexForTimeDupCheck[columnIndex] = new Pair((Object)Long.MIN_VALUE, null);
                }
                block11: for (int sortedRowIndex = ((Integer)pageRange.get(pageNum * 2)).intValue(); sortedRowIndex <= (Integer)pageRange.get(pageNum * 2 + 1); ++sortedRowIndex) {
                    TSDataType tsDataType = dataTypes.get(columnIndex);
                    long time = this.list.getTime(sortedRowIndex);
                    if (Objects.nonNull(timeDuplicateInfo)) {
                        if (!this.list.isNullValue(this.list.getValueIndex(sortedRowIndex), columnIndex)) {
                            lastValidPointIndexForTimeDupCheck[columnIndex].left = time;
                            lastValidPointIndexForTimeDupCheck[columnIndex].right = this.list.getValueIndex(sortedRowIndex);
                        }
                        if (timeDuplicateInfo[sortedRowIndex]) {
                            if (this.list.isNullValue(sortedRowIndex, columnIndex)) continue;
                            long recordSize = MemUtils.getRecordSize(tsDataType, tsDataType == TSDataType.TEXT ? this.list.getBinaryByValueIndex(sortedRowIndex, columnIndex) : null, CONFIG.isEnableMemControl());
                            CompressionRatio.decreaseDuplicatedMemorySize(recordSize);
                            continue;
                        }
                    }
                    int originRowIndex = Objects.nonNull(lastValidPointIndexForTimeDupCheck[columnIndex]) && time == (Long)lastValidPointIndexForTimeDupCheck[columnIndex].left ? ((Integer)lastValidPointIndexForTimeDupCheck[columnIndex].right).intValue() : this.list.getValueIndex(sortedRowIndex);
                    boolean isNull = this.list.isNullValue(originRowIndex, columnIndex);
                    switch (tsDataType) {
                        case BOOLEAN: {
                            alignedChunkWriter.writeByColumn(time, this.list.getBooleanByValueIndex(originRowIndex, columnIndex), isNull);
                            continue block11;
                        }
                        case INT32: {
                            alignedChunkWriter.writeByColumn(time, this.list.getIntByValueIndex(originRowIndex, columnIndex), isNull);
                            continue block11;
                        }
                        case INT64: {
                            alignedChunkWriter.writeByColumn(time, this.list.getLongByValueIndex(originRowIndex, columnIndex), isNull);
                            continue block11;
                        }
                        case FLOAT: {
                            alignedChunkWriter.writeByColumn(time, this.list.getFloatByValueIndex(originRowIndex, columnIndex), isNull);
                            continue block11;
                        }
                        case DOUBLE: {
                            alignedChunkWriter.writeByColumn(time, this.list.getDoubleByValueIndex(originRowIndex, columnIndex), isNull);
                            continue block11;
                        }
                        case TEXT: {
                            alignedChunkWriter.writeByColumn(time, this.list.getBinaryByValueIndex(originRowIndex, columnIndex), isNull);
                            continue block11;
                        }
                    }
                }
                alignedChunkWriter.nextColumn();
            }
            long[] times = new long[MAX_NUMBER_OF_POINTS_IN_PAGE];
            int pointsInPage = 0;
            for (int sortedRowIndex = ((Integer)pageRange.get(pageNum * 2)).intValue(); sortedRowIndex <= (Integer)pageRange.get(pageNum * 2 + 1); ++sortedRowIndex) {
                if (!Objects.isNull(timeDuplicateInfo) && timeDuplicateInfo[sortedRowIndex]) continue;
                times[pointsInPage++] = this.list.getTime(sortedRowIndex);
            }
            alignedChunkWriter.write(times, pointsInPage, 0);
        }
    }

    @Override
    public void release() {
        if (this.list.getReferenceCount() == 0) {
            this.list.clear();
        }
    }

    @Override
    public long getFirstPoint() {
        if (this.list.rowCount() == 0) {
            return Long.MAX_VALUE;
        }
        return this.getSortedTvListForQuery().getTimeValuePair(0).getTimestamp();
    }

    @Override
    public long getLastPoint() {
        if (this.list.rowCount() == 0) {
            return Long.MIN_VALUE;
        }
        return this.getSortedTvListForQuery().getTimeValuePair(this.getSortedTvListForQuery().rowCount() - 1).getTimestamp();
    }

    @Override
    public boolean isEmpty() {
        return this.list.rowCount() == 0;
    }

    @Override
    public int serializedSize() {
        int size = 0;
        size += 4;
        for (IMeasurementSchema schema : this.schemaList) {
            size += schema.serializedSize();
        }
        return size += this.list.serializedSize();
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        WALWriteUtils.write(this.schemaList.size(), buffer);
        for (IMeasurementSchema schema : this.schemaList) {
            byte[] bytes = new byte[schema.serializedSize()];
            schema.serializeTo(ByteBuffer.wrap(bytes));
            buffer.put(bytes);
        }
        this.list.serializeToWAL(buffer);
    }

    public static AlignedWritableMemChunk deserialize(DataInputStream stream) throws IOException {
        int schemaListSize = stream.readInt();
        ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>(schemaListSize);
        for (int i = 0; i < schemaListSize; ++i) {
            MeasurementSchema schema = MeasurementSchema.deserializeFrom((InputStream)stream);
            schemaList.add((IMeasurementSchema)schema);
        }
        AlignedTVList list = (AlignedTVList)TVList.deserialize(stream);
        return new AlignedWritableMemChunk(schemaList, list);
    }
}

