/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.wal;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.resource.wal.PipeWALResource;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeWALResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeWALResourceManager.class);
    protected final Map<Long, PipeWALResource> memtableIdToPipeWALResourceMap = new ConcurrentHashMap<Long, PipeWALResource>();
    private static final int SEGMENT_LOCK_COUNT = 32;
    private final ReentrantLock[] memtableIdSegmentLocks = new ReentrantLock[32];

    protected PipeWALResourceManager() {
        for (int i = 0; i < 32; ++i) {
            this.memtableIdSegmentLocks[i] = new ReentrantLock();
        }
        PipeAgent.runtime().registerPeriodicalJob("PipeWALResourceManager#ttlCheck()", this::ttlCheck, Math.max(20L, 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ttlCheck() {
        Iterator<Map.Entry<Long, PipeWALResource>> iterator = this.memtableIdToPipeWALResourceMap.entrySet().iterator();
        try {
            while (iterator.hasNext()) {
                Map.Entry<Long, PipeWALResource> entry = iterator.next();
                ReentrantLock lock = this.memtableIdSegmentLocks[(int)(entry.getKey() % 32L)];
                lock.lock();
                try {
                    if (entry.getValue().invalidateIfPossible()) {
                        iterator.remove();
                        continue;
                    }
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("WAL (memtableId {}) is still referenced {} times", (Object)entry.getKey(), (Object)entry.getValue().getReferenceCount());
                }
                finally {
                    lock.unlock();
                }
            }
        }
        catch (ConcurrentModificationException e) {
            LOGGER.error("Concurrent modification issues happened, skipping the WAL in this round of ttl check", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pin(WALEntryHandler walEntryHandler) throws IOException {
        long memtableId = walEntryHandler.getMemTableId();
        ReentrantLock lock = this.memtableIdSegmentLocks[(int)(memtableId % 32L)];
        lock.lock();
        try {
            this.pinInternal(memtableId, walEntryHandler);
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract void pinInternal(long var1, WALEntryHandler var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unpin(WALEntryHandler walEntryHandler) throws IOException {
        long memtableId = walEntryHandler.getMemTableId();
        ReentrantLock lock = this.memtableIdSegmentLocks[(int)(memtableId % 32L)];
        lock.lock();
        try {
            this.unpinInternal(memtableId, walEntryHandler);
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract void unpinInternal(long var1, WALEntryHandler var3) throws IOException;

    public int getPinnedWalCount() {
        return Objects.nonNull(this.memtableIdToPipeWALResourceMap) ? this.memtableIdToPipeWALResourceMap.size() : 0;
    }
}

