/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.BitMap;

public class MinTimeAccumulator
implements Accumulator {
    protected boolean hasCandidateResult;
    protected long minTime = Long.MAX_VALUE;

    @Override
    public void addInput(Column[] column, BitMap bitMap, int lastIndex) {
        for (int i = 0; i <= lastIndex; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateMinTime(column[0].getLong(i));
            return;
        }
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 1 ? 1 : 0) != 0, (Object)"partialResult of MinTime should be 1");
        if (partialResult[0].isNull(0)) {
            return;
        }
        this.updateMinTime(partialResult[0].getLong(0));
    }

    @Override
    public void addStatistics(Statistics statistics) {
        if (statistics == null) {
            return;
        }
        this.updateMinTime(statistics.getStartTime());
    }

    @Override
    public void setFinal(Column finalResult) {
        if (finalResult.isNull(0)) {
            return;
        }
        this.hasCandidateResult = true;
        this.minTime = finalResult.getLong(0);
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 1 ? 1 : 0) != 0, (Object)"partialResult of MinTime should be 1");
        if (!this.hasCandidateResult) {
            columnBuilders[0].appendNull();
        } else {
            columnBuilders[0].writeLong(this.minTime);
        }
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        if (!this.hasCandidateResult) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeLong(this.minTime);
        }
    }

    @Override
    public void reset() {
        this.hasCandidateResult = false;
        this.minTime = Long.MAX_VALUE;
    }

    @Override
    public boolean hasFinalResult() {
        return this.hasCandidateResult;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{TSDataType.INT64};
    }

    @Override
    public TSDataType getFinalType() {
        return TSDataType.INT64;
    }

    protected void updateMinTime(long curTime) {
        this.hasCandidateResult = true;
        this.minTime = Math.min(this.minTime, curTime);
    }
}

