/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeSchemaCacheMetrics;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DeviceUsingTemplateSchemaCache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.TimeSeriesSchemaCache;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaComputation;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.ITemplateManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeSchemaCache {
    private static final Logger logger = LoggerFactory.getLogger(DataNodeSchemaCache.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final ITemplateManager templateManager = ClusterTemplateManager.getInstance();
    private final DeviceUsingTemplateSchemaCache deviceUsingTemplateSchemaCache;
    private final TimeSeriesSchemaCache timeSeriesSchemaCache;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(false);
    private final ReentrantReadWriteLock insertDeletionLock = new ReentrantReadWriteLock(false);

    private DataNodeSchemaCache() {
        this.deviceUsingTemplateSchemaCache = new DeviceUsingTemplateSchemaCache(this.templateManager);
        this.timeSeriesSchemaCache = new TimeSeriesSchemaCache();
        MetricService.getInstance().addMetricSet((IMetricSet)new DataNodeSchemaCacheMetrics(this));
    }

    public long getHitCount() {
        return this.deviceUsingTemplateSchemaCache.getHitCount() + this.timeSeriesSchemaCache.getHitCount();
    }

    public long getRequestCount() {
        return this.deviceUsingTemplateSchemaCache.getRequestCount() + this.timeSeriesSchemaCache.getRequestCount();
    }

    public static DataNodeSchemaCache getInstance() {
        return DataNodeSchemaCacheHolder.INSTANCE;
    }

    public void takeReadLock() {
        this.readWriteLock.readLock().lock();
    }

    public void releaseReadLock() {
        this.readWriteLock.readLock().unlock();
    }

    public void takeWriteLock() {
        this.readWriteLock.writeLock().lock();
    }

    public void releaseWriteLock() {
        this.readWriteLock.writeLock().unlock();
    }

    public void takeInsertLock() {
        this.insertDeletionLock.readLock().lock();
    }

    public void releaseInsertLock() {
        this.insertDeletionLock.readLock().unlock();
    }

    public void takeDeleteLock() {
        this.insertDeletionLock.writeLock().lock();
    }

    public void releaseDeleteLock() {
        this.insertDeletionLock.writeLock().unlock();
    }

    public ClusterSchemaTree get(PartialPath devicePath, String[] measurements) {
        return this.timeSeriesSchemaCache.get(devicePath, measurements);
    }

    public ClusterSchemaTree get(PartialPath fullPath) {
        ClusterSchemaTree clusterSchemaTree = this.deviceUsingTemplateSchemaCache.get(fullPath.getDevicePath());
        if (clusterSchemaTree == null || clusterSchemaTree.isEmpty()) {
            return this.timeSeriesSchemaCache.get(fullPath);
        }
        return clusterSchemaTree;
    }

    public ClusterSchemaTree getMatchedSchemaWithTemplate(PartialPath devicePath) {
        return this.deviceUsingTemplateSchemaCache.getMatchedSchemaWithTemplate(devicePath);
    }

    public ClusterSchemaTree getMatchedSchemaWithoutTemplate(PartialPath fullPath) {
        return this.timeSeriesSchemaCache.get(fullPath);
    }

    public List<Integer> computeWithoutTemplate(ISchemaComputation schemaComputation) {
        List<Integer> result = this.timeSeriesSchemaCache.computeAndRecordLogicalView(schemaComputation);
        schemaComputation.recordRangeOfLogicalViewSchemaListNow();
        return result;
    }

    public Pair<List<Integer>, List<String>> computeSourceOfLogicalView(ISchemaComputation schemaComputation) {
        if (!schemaComputation.hasLogicalViewNeedProcess()) {
            return new Pair(new ArrayList(), new ArrayList());
        }
        return this.timeSeriesSchemaCache.computeSourceOfLogicalView(schemaComputation);
    }

    public List<Integer> computeWithTemplate(ISchemaComputation schemaComputation) {
        return this.deviceUsingTemplateSchemaCache.compute(schemaComputation);
    }

    public void put(ClusterSchemaTree tree) {
        for (DeviceSchemaInfo deviceSchemaInfo : tree.getAllDevices()) {
            PartialPath devicePath = deviceSchemaInfo.getDevicePath();
            if (deviceSchemaInfo.getTemplateId() != -1) {
                this.deviceUsingTemplateSchemaCache.put(devicePath, tree.getBelongedDatabase(devicePath), deviceSchemaInfo.getTemplateId());
                continue;
            }
            for (MeasurementPath measurementPath : deviceSchemaInfo.getMeasurementSchemaPathList()) {
                this.timeSeriesSchemaCache.putSingleMeasurementPath(tree.getBelongedDatabase(devicePath), measurementPath);
            }
        }
    }

    public TimeValuePair getLastCache(PartialPath seriesPath) {
        return this.timeSeriesSchemaCache.getLastCache(seriesPath);
    }

    public void updateLastCache(PartialPath devicePath, String measurement, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        this.timeSeriesSchemaCache.updateLastCache(devicePath, measurement, timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastCache(String database, PartialPath devicePath, String[] measurements, MeasurementSchema[] measurementSchemas, boolean isAligned, IntFunction<TimeValuePair> timeValuePairProvider, IntPredicate shouldUpdateProvider, boolean highPriorityUpdate, Long latestFlushedTime) {
        this.takeReadLock();
        try {
            this.timeSeriesSchemaCache.updateLastCache(database, devicePath, measurements, measurementSchemas, isAligned, timeValuePairProvider, shouldUpdateProvider, highPriorityUpdate, latestFlushedTime);
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void updateLastCacheWithoutLock(String database, PartialPath devicePath, String[] measurements, MeasurementSchema[] measurementSchemas, boolean isAligned, IntFunction<TimeValuePair> timeValuePairProvider, IntPredicate shouldUpdateProvider, boolean highPriorityUpdate, Long latestFlushedTime) {
        this.timeSeriesSchemaCache.updateLastCache(database, devicePath, measurements, measurementSchemas, isAligned, timeValuePairProvider, shouldUpdateProvider, highPriorityUpdate, latestFlushedTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastCache(String storageGroup, MeasurementPath measurementPath, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        this.takeReadLock();
        try {
            this.timeSeriesSchemaCache.updateLastCache(storageGroup, measurementPath, timeValuePair, highPriorityUpdate, latestFlushedTime);
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void invalidate(String database) {
        this.deviceUsingTemplateSchemaCache.invalidateCache(database);
        this.timeSeriesSchemaCache.invalidate(database);
    }

    public void invalidate(List<PartialPath> partialPathList) {
        boolean doPrecise = true;
        for (PartialPath partialPath : partialPathList) {
            if (!partialPath.getDevicePath().hasWildcard()) continue;
            doPrecise = false;
            break;
        }
        if (doPrecise) {
            this.deviceUsingTemplateSchemaCache.invalidateCache(partialPathList);
            this.timeSeriesSchemaCache.invalidate(partialPathList);
        } else {
            this.invalidateAll();
        }
    }

    public void invalidateAll() {
        this.deviceUsingTemplateSchemaCache.invalidateCache();
        this.timeSeriesSchemaCache.invalidateAll();
    }

    public void cleanUp() {
        this.deviceUsingTemplateSchemaCache.invalidateCache();
        this.timeSeriesSchemaCache.invalidateAll();
    }

    private static class DataNodeSchemaCacheHolder {
        private static final DataNodeSchemaCache INSTANCE = new DataNodeSchemaCache();

        private DataNodeSchemaCacheHolder() {
        }
    }
}

