/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.schema.node.utils.IMNodeIterator;
import org.apache.iotdb.commons.schema.tree.ITreeNode;
import org.apache.iotdb.commons.schema.tree.SchemaIterator;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.AlignedTimeseriesException;
import org.apache.iotdb.db.exception.metadata.MNodeTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.MeasurementInBlackListException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.template.DifferentTemplateException;
import org.apache.iotdb.db.exception.metadata.template.TemplateIsInUseException;
import org.apache.iotdb.db.exception.quota.ExceedQuotaException;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.schemaengine.metric.SchemaRegionMemMetric;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.MemMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.IMemMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.EntityCollector;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.MNodeCollector;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.MeasurementCollector;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.counter.EntityCounter;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.updater.EntityUpdater;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.updater.MeasurementUpdater;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowDevicesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowNodesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.INodeSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.ShowDevicesResult;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.ShowNodesResult;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.TimeseriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.impl.SchemaReaderLimitOffsetWrapper;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.impl.TimeseriesReaderWithViewFetch;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MetaFormatUtils;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.filter.DeviceFilterVisitor;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.storageengine.rescon.quotas.DataNodeSpaceQuotaManager;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MTreeBelowSGMemoryImpl {
    private final MemMTreeStore store;
    private volatile IMemMNode storageGroupMNode;
    private final IMemMNode rootNode;
    private final Function<IMeasurementMNode<IMemMNode>, Map<String, String>> tagGetter;
    private final IMNodeFactory<IMemMNode> nodeFactory = MNodeFactoryLoader.getInstance().getMemMNodeIMNodeFactory();
    private final int levelOfSG;
    private final MemSchemaRegionStatistics regionStatistics;

    public MTreeBelowSGMemoryImpl(PartialPath storageGroupPath, Function<IMeasurementMNode<IMemMNode>, Map<String, String>> tagGetter, MemSchemaRegionStatistics regionStatistics, SchemaRegionMemMetric metric) {
        this.store = new MemMTreeStore(storageGroupPath, regionStatistics, metric);
        this.regionStatistics = regionStatistics;
        this.storageGroupMNode = this.store.getRoot();
        this.rootNode = this.store.generatePrefix(storageGroupPath);
        this.levelOfSG = storageGroupPath.getNodeLength() - 1;
        this.tagGetter = tagGetter;
    }

    private MTreeBelowSGMemoryImpl(PartialPath storageGroupPath, MemMTreeStore store, Function<IMeasurementMNode<IMemMNode>, Map<String, String>> tagGetter, MemSchemaRegionStatistics regionStatistics) {
        this.store = store;
        this.regionStatistics = regionStatistics;
        this.storageGroupMNode = store.getRoot();
        this.rootNode = store.generatePrefix(storageGroupPath);
        this.levelOfSG = storageGroupPath.getNodeLength() - 1;
        this.tagGetter = tagGetter;
    }

    public void clear() {
        this.store.clear();
        this.storageGroupMNode = null;
    }

    public synchronized boolean createSnapshot(File snapshotDir) {
        return this.store.createSnapshot(snapshotDir);
    }

    public static MTreeBelowSGMemoryImpl loadFromSnapshot(File snapshotDir, String storageGroupFullPath, MemSchemaRegionStatistics regionStatistics, SchemaRegionMemMetric metric, Consumer<IMeasurementMNode<IMemMNode>> measurementProcess, Consumer<IDeviceMNode<IMemMNode>> deviceProcess, Function<IMeasurementMNode<IMemMNode>, Map<String, String>> tagGetter) throws IOException, IllegalPathException {
        return new MTreeBelowSGMemoryImpl(new PartialPath(storageGroupFullPath), MemMTreeStore.loadFromSnapshot(snapshotDir, measurementProcess, deviceProcess, regionStatistics, metric), tagGetter, regionStatistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMeasurementMNode<IMemMNode> createTimeseries(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, String alias) throws MetadataException {
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= 2) {
            throw new IllegalPathException(path.getFullPath());
        }
        MetaFormatUtils.checkTimeseries(path);
        PartialPath devicePath = path.getDevicePath();
        IMemMNode deviceParent = this.checkAndAutoCreateInternalPath(devicePath);
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            IMemMNode device = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), deviceParent);
            MetaFormatUtils.checkTimeseriesProps(path.getFullPath(), props);
            String leafName = path.getMeasurement();
            if (alias != null && device.hasChild(alias)) {
                throw new AliasAlreadyExistException(path.getFullPath(), alias);
            }
            if (device.hasChild(leafName)) {
                IMemMNode node = (IMemMNode)device.getChild(leafName);
                if (node.isMeasurement()) {
                    if (node.getAsMeasurementMNode().isPreDeleted()) {
                        throw new MeasurementInBlackListException(path);
                    }
                    throw new MeasurementAlreadyExistException(path.getFullPath(), node.getAsMeasurementMNode().getMeasurementPath());
                }
                throw new PathAlreadyExistException(path.getFullPath());
            }
            if (device.isDevice() && device.getAsDeviceMNode().isAlignedNullable() != null && device.getAsDeviceMNode().isAligned()) {
                throw new AlignedTimeseriesException("timeseries under this device is aligned, please use createAlignedTimeseries or change device.", device.getFullPath());
            }
            IDeviceMNode<IMemMNode> entityMNode = device.isDevice() ? device.getAsDeviceMNode() : this.store.setToEntity(device);
            if (entityMNode.isAlignedNullable() == null) {
                entityMNode.setAligned(Boolean.valueOf(false));
            }
            IMeasurementMNode measurementMNode = this.nodeFactory.createMeasurementMNode(entityMNode, leafName, (IMeasurementSchema)new MeasurementSchema(leafName, dataType, encoding, compressor, props), alias);
            this.store.addChild((IMemMNode)entityMNode.getAsMNode(), leafName, (IMemMNode)measurementMNode.getAsMNode());
            if (alias != null) {
                entityMNode.addAlias(alias, measurementMNode);
            }
            return measurementMNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMeasurementMNode<IMemMNode>> createAlignedTimeseries(PartialPath devicePath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> aliasList) throws MetadataException {
        ArrayList<IMeasurementMNode<IMemMNode>> measurementMNodeList = new ArrayList<IMeasurementMNode<IMemMNode>>();
        MetaFormatUtils.checkSchemaMeasurementNames(measurements);
        IMemMNode deviceParent = this.checkAndAutoCreateInternalPath(devicePath);
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            IDeviceMNode<IMemMNode> entityMNode;
            IMemMNode device = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), deviceParent);
            for (int i = 0; i < measurements.size(); ++i) {
                if (device.hasChild(measurements.get(i))) {
                    IMemMNode node = (IMemMNode)device.getChild(measurements.get(i));
                    if (node.isMeasurement()) {
                        if (node.getAsMeasurementMNode().isPreDeleted()) {
                            throw new MeasurementInBlackListException(devicePath.concatNode(measurements.get(i)));
                        }
                        throw new MeasurementAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i), node.getAsMeasurementMNode().getMeasurementPath());
                    }
                    throw new PathAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i));
                }
                if (aliasList == null || aliasList.get(i) == null || !device.hasChild(aliasList.get(i))) continue;
                throw new AliasAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i), aliasList.get(i));
            }
            if (device.isDevice() && device.getAsDeviceMNode().isAlignedNullable() != null && !device.getAsDeviceMNode().isAligned()) {
                throw new AlignedTimeseriesException("Timeseries under this device is not aligned, please use createTimeseries or change device.", devicePath.getFullPath());
            }
            if (device.isDevice()) {
                entityMNode = device.getAsDeviceMNode();
            } else {
                entityMNode = this.store.setToEntity(device);
                entityMNode.setAligned(Boolean.valueOf(true));
            }
            if (entityMNode.isAlignedNullable() == null) {
                entityMNode.setAligned(Boolean.valueOf(true));
            }
            for (int i = 0; i < measurements.size(); ++i) {
                IMeasurementMNode measurementMNode = this.nodeFactory.createMeasurementMNode(entityMNode, measurements.get(i), (IMeasurementSchema)new MeasurementSchema(measurements.get(i), dataTypes.get(i), encodings.get(i), compressors.get(i)), aliasList == null ? null : aliasList.get(i));
                this.store.addChild((IMemMNode)entityMNode.getAsMNode(), measurements.get(i), (IMemMNode)measurementMNode.getAsMNode());
                if (aliasList != null && aliasList.get(i) != null) {
                    entityMNode.addAlias(aliasList.get(i), measurementMNode);
                }
                measurementMNodeList.add((IMeasurementMNode<IMemMNode>)measurementMNode);
            }
            return measurementMNodeList;
        }
    }

    private IMemMNode checkAndAutoCreateInternalPath(PartialPath devicePath) throws MetadataException {
        String[] nodeNames = devicePath.getNodes();
        MetaFormatUtils.checkTimeseries(devicePath);
        if (nodeNames.length == this.levelOfSG + 1) {
            return null;
        }
        IMemMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodeNames.length - 1; ++i) {
            String childName = nodeNames[i];
            IMemMNode child = (IMemMNode)cur.getChild(childName);
            if (child == null) {
                child = this.store.addChild(cur, childName, (IMemMNode)this.nodeFactory.createInternalMNode((IMNode)cur, childName));
            }
            if (!(cur = child).isMeasurement()) continue;
            throw new PathAlreadyExistException(cur.getFullPath());
        }
        return cur;
    }

    private IMemMNode checkAndAutoCreateDeviceNode(String deviceName, IMemMNode deviceParent) throws PathAlreadyExistException, ExceedQuotaException {
        if (deviceParent == null) {
            return this.storageGroupMNode;
        }
        IMemMNode device = this.store.getChild(deviceParent, deviceName);
        if (device == null) {
            if (IoTDBDescriptor.getInstance().getConfig().isQuotaEnable() && !DataNodeSpaceQuotaManager.getInstance().checkDeviceLimit(this.storageGroupMNode.getName())) {
                throw new ExceedQuotaException("The number of devices has reached the upper limit", TSStatusCode.SPACE_QUOTA_EXCEEDED.getStatusCode());
            }
            device = this.store.addChild(deviceParent, deviceName, (IMemMNode)this.nodeFactory.createInternalMNode((IMNode)deviceParent, deviceName));
        }
        if (device.isMeasurement()) {
            throw new PathAlreadyExistException(device.getFullPath());
        }
        return device;
    }

    public Map<Integer, MetadataException> checkMeasurementExistence(PartialPath devicePath, List<String> measurementList, List<String> aliasList) {
        IMemMNode device;
        try {
            device = this.getNodeByPath(devicePath);
        }
        catch (PathNotExistException e) {
            return Collections.emptyMap();
        }
        if (!device.isDevice()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, MetadataException> failingMeasurementMap = new HashMap<Integer, MetadataException>();
        for (int i = 0; i < measurementList.size(); ++i) {
            if (device.hasChild(measurementList.get(i))) {
                IMemMNode node = (IMemMNode)device.getChild(measurementList.get(i));
                if (node.isMeasurement()) {
                    if (node.getAsMeasurementMNode().isPreDeleted()) {
                        failingMeasurementMap.put(i, new MeasurementInBlackListException(devicePath.concatNode(measurementList.get(i))));
                    } else {
                        failingMeasurementMap.put(i, new MeasurementAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i), node.getAsMeasurementMNode().getMeasurementPath()));
                    }
                } else {
                    failingMeasurementMap.put(i, new PathAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i)));
                }
            }
            if (aliasList != null && aliasList.get(i) != null && device.hasChild(aliasList.get(i))) {
                failingMeasurementMap.put(i, new AliasAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i), aliasList.get(i)));
            }
            if (!IoTDBDescriptor.getInstance().getConfig().isQuotaEnable() || DataNodeSpaceQuotaManager.getInstance().checkTimeSeriesNum(this.storageGroupMNode.getName())) continue;
            failingMeasurementMap.put(i, new ExceedQuotaException("The number of timeseries has reached the upper limit", TSStatusCode.SPACE_QUOTA_EXCEEDED.getStatusCode()));
        }
        return failingMeasurementMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeAlias(String alias, PartialPath fullPath) throws MetadataException {
        IMeasurementMNode<IMemMNode> measurementMNode = this.getMeasurementMNode(fullPath);
        if (alias != null && !alias.equals(measurementMNode.getAlias())) {
            MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
            synchronized (mTreeBelowSGMemoryImpl) {
                IDeviceMNode device = ((IMemMNode)measurementMNode.getParent()).getAsDeviceMNode();
                IMemMNode memMNode = this.store.getChild((IMemMNode)device.getAsMNode(), alias);
                if (memMNode != null) {
                    throw new MetadataException("The alias is duplicated with the name or alias of other measurement.");
                }
                if (measurementMNode.getAlias() != null) {
                    device.deleteAliasChild(measurementMNode.getAlias());
                }
                device.addAlias(alias, measurementMNode);
                this.setAlias(measurementMNode, alias);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMeasurementMNode<IMemMNode> deleteTimeseries(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0) {
            throw new IllegalPathException(path.getFullPath());
        }
        IMeasurementMNode<IMemMNode> deletedNode = this.getMeasurementMNode(path);
        IMemMNode parent = (IMemMNode)deletedNode.getParent();
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            this.store.deleteChild(parent, path.getMeasurement());
            if (deletedNode.getAlias() != null) {
                parent.getAsDeviceMNode().deleteAliasChild(deletedNode.getAlias());
            }
        }
        this.deleteEmptyInternalMNode((IDeviceMNode<IMemMNode>)parent.getAsDeviceMNode());
        return deletedNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEmptyInternalMNode(IDeviceMNode<IMemMNode> entityMNode) {
        IMemMNode curNode = (IMemMNode)entityMNode.getAsMNode();
        if (!entityMNode.isUseTemplate()) {
            boolean hasMeasurement = false;
            boolean hasNonViewMeasurement = false;
            IMNodeIterator<IMemMNode> iterator = this.store.getChildrenIterator(curNode);
            while (iterator.hasNext()) {
                IMemMNode child = (IMemMNode)iterator.next();
                if (!child.isMeasurement()) continue;
                hasMeasurement = true;
                if (child.getAsMeasurementMNode().isLogicalView()) continue;
                hasNonViewMeasurement = true;
                break;
            }
            if (!hasMeasurement) {
                MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
                synchronized (mTreeBelowSGMemoryImpl) {
                    curNode = this.store.setToInternal((IDeviceMNode)entityMNode);
                }
            } else if (!hasNonViewMeasurement) {
                entityMNode.setAligned(null);
            }
        }
        while (true) {
            if (curNode.isDatabase()) {
                return;
            }
            MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
            synchronized (mTreeBelowSGMemoryImpl) {
                if (!this.isEmptyInternalMNode(curNode)) {
                    break;
                }
                this.store.deleteChild((IMemMNode)curNode.getParent(), curNode.getName());
                curNode = (IMemMNode)curNode.getParent();
            }
        }
    }

    private boolean isEmptyInternalMNode(IMemMNode node) {
        return !"root".equals(node.getName()) && !node.isMeasurement() && (!node.isDevice() || !node.getAsDeviceMNode().isUseTemplate()) && node.getChildren().isEmpty();
    }

    public List<PartialPath> constructSchemaBlackList(PartialPath pathPattern) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater<IMemMNode> updater = new MeasurementUpdater<IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateMeasurement(IMeasurementMNode<IMemMNode> node) {
                node.setPreDeleted(true);
                result.add(this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())));
            }
        };){
            updater.update();
        }
        return result;
    }

    public List<PartialPath> rollbackSchemaBlackList(PartialPath pathPattern) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater<IMemMNode> updater = new MeasurementUpdater<IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateMeasurement(IMeasurementMNode<IMemMNode> node) {
                node.setPreDeleted(false);
                result.add(this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())));
            }
        };){
            updater.update();
        }
        return result;
    }

    public List<PartialPath> getPreDeletedTimeseries(PartialPath pathPattern) throws MetadataException {
        final LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        try (MeasurementCollector<Void, IMemMNode> collector = new MeasurementCollector<Void, IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMeasurement(IMeasurementMNode<IMemMNode> node) {
                if (node.isPreDeleted()) {
                    result.add(this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())));
                }
                return null;
            }
        };){
            collector.traverse();
        }
        return result;
    }

    public Set<PartialPath> getDevicesOfPreDeletedTimeseries(PartialPath pathPattern) throws MetadataException {
        final HashSet<PartialPath> result = new HashSet<PartialPath>();
        try (MeasurementCollector<Void, IMemMNode> collector = new MeasurementCollector<Void, IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMeasurement(IMeasurementMNode<IMemMNode> node) {
                if (node.isPreDeleted()) {
                    result.add(this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())).getDevicePath());
                }
                return null;
            }
        };){
            collector.traverse();
        }
        return result;
    }

    public void setAlias(IMeasurementMNode<IMemMNode> measurementMNode, String alias) throws MetadataException {
        this.store.setAlias(measurementMNode, alias);
    }

    public IMemMNode getDeviceNodeWithAutoCreating(PartialPath deviceId) throws MetadataException {
        MetaFormatUtils.checkTimeseries(deviceId);
        String[] nodeNames = deviceId.getNodes();
        IMemMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodeNames.length; ++i) {
            IMemMNode child = (IMemMNode)cur.getChild(nodeNames[i]);
            if (child == null) {
                child = this.store.addChild(cur, nodeNames[i], (IMemMNode)this.nodeFactory.createInternalMNode((IMNode)cur, nodeNames[i]));
            }
            cur = child;
        }
        return cur;
    }

    public boolean checkDeviceNodeExists(PartialPath deviceId) {
        try {
            IMemMNode deviceMNode = this.getNodeByPath(deviceId);
            return deviceMNode.isDevice();
        }
        catch (MetadataException e) {
            return false;
        }
    }

    public ClusterSchemaTree fetchSchema(PartialPath pathPattern, Map<Integer, Template> templateMap, final boolean withTags, final boolean withTemplate) throws MetadataException {
        final ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        try (MeasurementCollector<Void, IMemMNode> collector = new MeasurementCollector<Void, IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMeasurement(IMeasurementMNode<IMemMNode> node) {
                IDeviceMNode deviceMNode = ((IMemMNode)this.getParentOfNextMatchedNode()).getAsDeviceMNode();
                int templateId = deviceMNode.getSchemaTemplateIdWithState();
                if (withTemplate && templateId >= 0) {
                    schemaTree.appendTemplateDevice(deviceMNode.getPartialPath(), deviceMNode.isAligned(), templateId, null);
                    this.skipTemplateChildren(deviceMNode);
                } else {
                    MeasurementPath path = this.getCurrentMeasurementPathInTraverse(node);
                    if (this.nodes[this.nodes.length - 1].equals(node.getAlias())) {
                        path.setMeasurementAlias(node.getAlias());
                    }
                    if (withTags) {
                        path.setTagMap((Map)MTreeBelowSGMemoryImpl.this.tagGetter.apply(node));
                    }
                    schemaTree.appendSingleMeasurementPath(path);
                }
                return null;
            }
        };){
            collector.setTemplateMap(templateMap, this.nodeFactory);
            collector.setSkipPreDeletedSchema(true);
            collector.traverse();
        }
        return schemaTree;
    }

    public ClusterSchemaTree fetchSchemaWithoutWildcard(PathPatternTree patternTree, Map<Integer, Template> templateMap, final boolean withTags, final boolean withTemplate) throws MetadataException {
        final ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        try (MeasurementCollector<Void, IMemMNode> collector = new MeasurementCollector<Void, IMemMNode>(this.rootNode, patternTree, (IMTreeStore)this.store, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMeasurement(IMeasurementMNode<IMemMNode> node) {
                IDeviceMNode deviceMNode = ((IMemMNode)this.getParentOfNextMatchedNode()).getAsDeviceMNode();
                int templateId = deviceMNode.getSchemaTemplateIdWithState();
                if (withTemplate && templateId >= 0) {
                    schemaTree.appendTemplateDevice(deviceMNode.getPartialPath(), deviceMNode.isAligned(), templateId, null);
                    this.skipTemplateChildren(deviceMNode);
                } else {
                    MeasurementPath path = this.getCurrentMeasurementPathInTraverse(node);
                    path.setMeasurementAlias(node.getAlias());
                    if (withTags) {
                        path.setTagMap((Map)MTreeBelowSGMemoryImpl.this.tagGetter.apply(node));
                    }
                    schemaTree.appendSingleMeasurementPath(path);
                }
                return null;
            }
        };){
            collector.setTemplateMap(templateMap, this.nodeFactory);
            collector.setSkipPreDeletedSchema(true);
            collector.traverse();
        }
        return schemaTree;
    }

    public IMemMNode getNodeByPath(PartialPath path) throws PathNotExistException {
        String[] nodes = path.getNodes();
        IMemMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
            IMemMNode next = (IMemMNode)cur.getChild(nodes[i]);
            if (next == null) {
                throw new PathNotExistException(path.getFullPath(), true);
            }
            if (next.isMeasurement()) {
                if (i == nodes.length - 1) {
                    return next;
                }
                throw new PathNotExistException(path.getFullPath(), true);
            }
            cur = next;
        }
        return cur;
    }

    public IMeasurementMNode<IMemMNode> getMeasurementMNode(PartialPath path) throws MetadataException {
        IMemMNode node = this.getNodeByPath(path);
        if (node.isMeasurement()) {
            return node.getAsMeasurementMNode();
        }
        throw new MNodeTypeMismatchException(path.getFullPath(), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateTemplate(PartialPath activatePath, Template template) throws MetadataException {
        IDeviceMNode<IMemMNode> entityMNode;
        String[] nodes = activatePath.getNodes();
        IMemMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
            cur = (IMemMNode)cur.getChild(nodes[i]);
        }
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            entityMNode = cur.isDevice() ? cur.getAsDeviceMNode() : this.store.setToEntity(cur);
        }
        if (entityMNode.isUseTemplate()) {
            if (template.getId() == entityMNode.getSchemaTemplateId()) {
                throw new TemplateIsInUseException(cur.getFullPath());
            }
            throw new DifferentTemplateException(activatePath.getFullPath(), template.getName());
        }
        if (!entityMNode.isAligned()) {
            entityMNode.setAligned(Boolean.valueOf(template.isDirectAligned()));
        }
        entityMNode.setUseTemplate(true);
        entityMNode.setSchemaTemplateId(template.getId());
        this.regionStatistics.activateTemplate(template.getId());
    }

    public Map<PartialPath, List<Integer>> constructSchemaBlackListWithTemplate(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            try (EntityUpdater<IMemMNode> updater = new EntityUpdater<IMemMNode>(this.rootNode, entry.getKey(), (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

                @Override
                protected void updateEntity(IDeviceMNode<IMemMNode> node) {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId())) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        node.preDeactivateTemplate();
                    }
                }
            };){
                updater.update();
            }
        }
        return resultTemplateSetInfo;
    }

    public Map<PartialPath, List<Integer>> rollbackSchemaBlackListWithTemplate(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            try (EntityUpdater<IMemMNode> updater = new EntityUpdater<IMemMNode>(this.rootNode, entry.getKey(), (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

                @Override
                protected void updateEntity(IDeviceMNode<IMemMNode> node) {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId()) && node.isPreDeactivateTemplate()) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        node.rollbackPreDeactivateTemplate();
                    }
                }
            };){
                updater.update();
            }
        }
        return resultTemplateSetInfo;
    }

    public Map<PartialPath, List<Integer>> deactivateTemplateInBlackList(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            try (EntityUpdater<IMemMNode> collector = new EntityUpdater<IMemMNode>(this.rootNode, entry.getKey(), (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

                @Override
                protected void updateEntity(IDeviceMNode<IMemMNode> node) {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId()) && node.isPreDeactivateTemplate()) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        MTreeBelowSGMemoryImpl.this.regionStatistics.deactivateTemplate(node.getSchemaTemplateId());
                        node.deactivateTemplate();
                        MTreeBelowSGMemoryImpl.this.deleteEmptyInternalMNode(node);
                    }
                }
            };){
                collector.traverse();
            }
        }
        return resultTemplateSetInfo;
    }

    public void activateTemplateWithoutCheck(PartialPath activatePath, int templateId, boolean isAligned) {
        String[] nodes = activatePath.getNodes();
        IMemMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
            cur = (IMemMNode)cur.getChild(nodes[i]);
        }
        IDeviceMNode<IMemMNode> entityMNode = cur.isDevice() ? cur.getAsDeviceMNode() : this.store.setToEntity(cur);
        if (!entityMNode.isAligned()) {
            entityMNode.setAligned(Boolean.valueOf(isAligned));
        }
        entityMNode.setUseTemplate(true);
        entityMNode.setSchemaTemplateId(templateId);
        this.regionStatistics.activateTemplate(templateId);
    }

    public long countPathsUsingTemplate(PartialPath pathPattern, int templateId) throws MetadataException {
        try (EntityCounter<IMemMNode> counter = new EntityCounter<IMemMNode>(this.rootNode, pathPattern, this.store, false, SchemaConstant.ALL_MATCH_SCOPE);){
            counter.setSchemaTemplateFilter(templateId);
            long l = counter.count();
            return l;
        }
    }

    public ISchemaReader<IDeviceSchemaInfo> getDeviceReader(final IShowDevicesPlan showDevicesPlan) throws MetadataException {
        final EntityCollector<IDeviceSchemaInfo, IMemMNode> collector = new EntityCollector<IDeviceSchemaInfo, IMemMNode>(this.rootNode, showDevicesPlan.getPath(), (IMTreeStore)this.store, showDevicesPlan.isPrefixMatch(), showDevicesPlan.getScope()){

            @Override
            protected IDeviceSchemaInfo collectEntity(IDeviceMNode<IMemMNode> node) {
                PartialPath device = this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode()));
                return new ShowDevicesResult(device.getFullPath(), node.isAlignedNullable(), node.getSchemaTemplateId());
            }
        };
        if (showDevicesPlan.usingSchemaTemplate()) {
            collector.setSchemaTemplateFilter(showDevicesPlan.getSchemaTemplateId());
        }
        ISchemaReader<IDeviceSchemaInfo> reader = new ISchemaReader<IDeviceSchemaInfo>(){
            private final DeviceFilterVisitor filterVisitor = new DeviceFilterVisitor();
            private IDeviceSchemaInfo next;

            @Override
            public boolean isSuccess() {
                return collector.isSuccess();
            }

            @Override
            public Throwable getFailure() {
                return collector.getFailure();
            }

            @Override
            public void close() {
                collector.close();
            }

            @Override
            public ListenableFuture<?> isBlocked() {
                return NOT_BLOCKED;
            }

            @Override
            public boolean hasNext() {
                while (this.next == null && collector.hasNext()) {
                    IDeviceSchemaInfo temp = (IDeviceSchemaInfo)collector.next();
                    if (!this.filterVisitor.process(showDevicesPlan.getSchemaFilter(), temp)) continue;
                    this.next = temp;
                }
                return this.next != null;
            }

            @Override
            public IDeviceSchemaInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IDeviceSchemaInfo result = this.next;
                this.next = null;
                return result;
            }
        };
        if (showDevicesPlan.getLimit() > 0L || showDevicesPlan.getOffset() > 0L) {
            return new SchemaReaderLimitOffsetWrapper<IDeviceSchemaInfo>(reader, showDevicesPlan.getLimit(), showDevicesPlan.getOffset());
        }
        return reader;
    }

    public ISchemaReader<ITimeSeriesSchemaInfo> getTimeSeriesReader(IShowTimeSeriesPlan showTimeSeriesPlan, final Function<Long, Pair<Map<String, String>, Map<String, String>>> tagAndAttributeProvider) throws MetadataException {
        MeasurementCollector<ITimeSeriesSchemaInfo, IMemMNode> collector = new MeasurementCollector<ITimeSeriesSchemaInfo, IMemMNode>(this.rootNode, showTimeSeriesPlan.getPath(), (IMTreeStore)this.store, showTimeSeriesPlan.isPrefixMatch(), showTimeSeriesPlan.getScope()){

            @Override
            protected ITimeSeriesSchemaInfo collectMeasurement(final IMeasurementMNode<IMemMNode> node) {
                return new ITimeSeriesSchemaInfo(){
                    private Pair<Map<String, String>, Map<String, String>> tagAndAttribute = null;

                    @Override
                    public String getAlias() {
                        return node.getAlias();
                    }

                    @Override
                    public IMeasurementSchema getSchema() {
                        return node.getSchema();
                    }

                    @Override
                    public Map<String, String> getTags() {
                        if (this.tagAndAttribute == null) {
                            this.tagAndAttribute = (Pair)tagAndAttributeProvider.apply(node.getOffset());
                        }
                        return (Map)this.tagAndAttribute.left;
                    }

                    @Override
                    public Map<String, String> getAttributes() {
                        if (this.tagAndAttribute == null) {
                            this.tagAndAttribute = (Pair)tagAndAttributeProvider.apply(node.getOffset());
                        }
                        return (Map)this.tagAndAttribute.right;
                    }

                    @Override
                    public boolean isUnderAlignedDevice() {
                        return ((IMemMNode)this.getParentOfNextMatchedNode()).getAsDeviceMNode().isAligned();
                    }

                    @Override
                    public boolean isLogicalView() {
                        return node.isLogicalView();
                    }

                    @Override
                    public String getFullPath() {
                        return this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())).getFullPath();
                    }

                    @Override
                    public PartialPath getPartialPath() {
                        return this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode()));
                    }

                    @Override
                    public ITimeSeriesSchemaInfo snapshot() {
                        return new TimeseriesSchemaInfo(node, this.getPartialPath(), this.getTags(), this.getAttributes(), this.isUnderAlignedDevice());
                    }
                };
            }
        };
        collector.setTemplateMap(showTimeSeriesPlan.getRelatedTemplate(), this.nodeFactory);
        TimeseriesReaderWithViewFetch reader = new TimeseriesReaderWithViewFetch((SchemaIterator<ITimeSeriesSchemaInfo>)collector, showTimeSeriesPlan.getSchemaFilter(), showTimeSeriesPlan.needViewDetail());
        if (showTimeSeriesPlan.getLimit() > 0L || showTimeSeriesPlan.getOffset() > 0L) {
            return new SchemaReaderLimitOffsetWrapper<ITimeSeriesSchemaInfo>(reader, showTimeSeriesPlan.getLimit(), showTimeSeriesPlan.getOffset());
        }
        return reader;
    }

    public ISchemaReader<INodeSchemaInfo> getNodeReader(IShowNodesPlan showNodesPlan) throws MetadataException {
        final MNodeCollector<INodeSchemaInfo, IMemMNode> collector = new MNodeCollector<INodeSchemaInfo, IMemMNode>(this.rootNode, showNodesPlan.getPath(), (IMTreeStore)this.store, showNodesPlan.isPrefixMatch(), showNodesPlan.getScope()){

            @Override
            protected INodeSchemaInfo collectMNode(IMemMNode node) {
                return new ShowNodesResult(this.getPartialPathFromRootToNode((ITreeNode)node).getFullPath(), node.getMNodeType());
            }
        };
        collector.setTargetLevel(showNodesPlan.getLevel());
        return new ISchemaReader<INodeSchemaInfo>(){

            @Override
            public boolean isSuccess() {
                return collector.isSuccess();
            }

            @Override
            public Throwable getFailure() {
                return collector.getFailure();
            }

            @Override
            public void close() {
                collector.close();
            }

            @Override
            public ListenableFuture<?> isBlocked() {
                return NOT_BLOCKED;
            }

            @Override
            public boolean hasNext() {
                return collector.hasNext();
            }

            @Override
            public INodeSchemaInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (INodeSchemaInfo)collector.next();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMeasurementMNode<IMemMNode> createLogicalView(PartialPath path, ViewExpression viewExpression) throws MetadataException {
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= 2) {
            throw new IllegalPathException(path.getFullPath());
        }
        MetaFormatUtils.checkTimeseries(path);
        PartialPath devicePath = path.getDevicePath();
        IMemMNode deviceParent = this.checkAndAutoCreateInternalPath(devicePath);
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            IDeviceMNode<IMemMNode> entityMNode;
            String leafName = path.getMeasurement();
            IMeasurementMNode measurementMNode = this.nodeFactory.createLogicalViewMNode(null, leafName, (IMeasurementSchema)new LogicalViewSchema(leafName, viewExpression));
            IMemMNode device = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), deviceParent);
            if (device.hasChild(leafName)) {
                IMemMNode node = (IMemMNode)device.getChild(leafName);
                if (node.isMeasurement()) {
                    if (node.getAsMeasurementMNode().isPreDeleted()) {
                        throw new MeasurementInBlackListException(path);
                    }
                    throw new MeasurementAlreadyExistException(path.getFullPath(), node.getAsMeasurementMNode().getMeasurementPath());
                }
                throw new PathAlreadyExistException(path.getFullPath());
            }
            if (device.isDevice()) {
                entityMNode = device.getAsDeviceMNode();
            } else {
                entityMNode = this.store.setToEntity(device);
                entityMNode.setAligned(null);
            }
            measurementMNode.setParent((IMNode)((IMemMNode)entityMNode.getAsMNode()));
            this.store.addChild((IMemMNode)entityMNode.getAsMNode(), leafName, (IMemMNode)measurementMNode.getAsMNode());
            return measurementMNode;
        }
    }

    public List<PartialPath> constructLogicalViewBlackList(PartialPath pathPattern) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater<IMemMNode> updater = new MeasurementUpdater<IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateMeasurement(IMeasurementMNode<IMemMNode> node) {
                if (node.isLogicalView()) {
                    node.setPreDeleted(true);
                    result.add(this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())));
                }
            }
        };){
            updater.update();
        }
        return result;
    }

    public List<PartialPath> rollbackLogicalViewBlackList(PartialPath pathPattern) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater<IMemMNode> updater = new MeasurementUpdater<IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateMeasurement(IMeasurementMNode<IMemMNode> node) {
                if (node.isLogicalView()) {
                    node.setPreDeleted(false);
                    result.add(this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())));
                }
            }
        };){
            updater.update();
        }
        return result;
    }

    public List<PartialPath> getPreDeletedLogicalView(PartialPath pathPattern) throws MetadataException {
        final LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        try (MeasurementCollector<Void, IMemMNode> collector = new MeasurementCollector<Void, IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMeasurement(IMeasurementMNode<IMemMNode> node) {
                if (node.isLogicalView() && node.isPreDeleted()) {
                    result.add(this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())));
                }
                return null;
            }
        };){
            collector.traverse();
        }
        return result;
    }
}

