/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus.statemachine.schemaregion;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.ratis.utils.Utils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.statemachine.BaseStateMachine;
import org.apache.iotdb.db.consensus.statemachine.schemaregion.SchemaExecutionVisitor;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.extractor.schemaregion.SchemaRegionListeningQueue;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.tools.schema.SchemaRegionSnapshotParser;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegionStateMachine
extends BaseStateMachine {
    private static final Logger logger = LoggerFactory.getLogger(SchemaRegionStateMachine.class);
    private final ISchemaRegion schemaRegion;
    private static final FragmentInstanceManager QUERY_INSTANCE_MANAGER = FragmentInstanceManager.getInstance();

    public SchemaRegionStateMachine(ISchemaRegion schemaRegion) {
        this.schemaRegion = schemaRegion;
    }

    public void start() {
    }

    public void stop() {
        PipeAgent.runtime().notifySchemaLeaderUnavailable(this.schemaRegion.getSchemaRegionId());
    }

    public void notifyLeaderChanged(ConsensusGroupId groupId, int newLeaderId) {
        if (this.schemaRegion.getSchemaRegionId().equals((Object)groupId) && newLeaderId != IoTDBDescriptor.getInstance().getConfig().getDataNodeId()) {
            logger.info("Current node [nodeId: {}] is no longer the schema region leader [regionId: {}], the new leader is [nodeId:{}]", new Object[]{IoTDBDescriptor.getInstance().getConfig().getDataNodeId(), this.schemaRegion.getSchemaRegionId(), newLeaderId});
            PipeAgent.runtime().notifySchemaLeaderUnavailable(this.schemaRegion.getSchemaRegionId());
            logger.info("Current node [nodeId: {}] is no longer the schema region leader [regionId: {}], all services on old leader are unavailable now.", (Object)IoTDBDescriptor.getInstance().getConfig().getDataNodeId(), (Object)this.schemaRegion.getSchemaRegionId());
        }
    }

    public void notifyLeaderReady() {
        logger.info("Current node [nodeId: {}] becomes schema region leader [regionId: {}]", (Object)IoTDBDescriptor.getInstance().getConfig().getDataNodeId(), (Object)this.schemaRegion.getSchemaRegionId());
        PipeAgent.runtime().notifySchemaLeaderReady(this.schemaRegion.getSchemaRegionId());
        logger.info("Current node [nodeId: {}] as schema region leader [regionId: {}] is ready to work", (Object)IoTDBDescriptor.getInstance().getConfig().getDataNodeId(), (Object)this.schemaRegion.getSchemaRegionId());
    }

    public boolean isReadOnly() {
        return CommonDescriptor.getInstance().getConfig().isReadOnly();
    }

    public boolean takeSnapshot(File snapshotDir) {
        if (this.schemaRegion.createSnapshot(snapshotDir) && PipeAgent.runtime().schemaListener(this.schemaRegion.getSchemaRegionId()).createSnapshot(snapshotDir)) {
            this.listen2Snapshot4PipeListener(true);
            return true;
        }
        return false;
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
        this.schemaRegion.loadSnapshot(latestSnapshotRootDir);
        PipeAgent.runtime().schemaListener(this.schemaRegion.getSchemaRegionId()).loadSnapshot(latestSnapshotRootDir);
        this.listen2Snapshot4PipeListener(false);
    }

    public void listen2Snapshot4PipeListener(boolean isTmp) {
        Pair<Path, Path> snapshotPaths = SchemaRegionSnapshotParser.getSnapshotPaths(Utils.fromConsensusGroupIdToRaftGroupId((ConsensusGroupId)this.schemaRegion.getSchemaRegionId()).getUuid().toString(), isTmp);
        SchemaRegionListeningQueue listener = PipeAgent.runtime().schemaListener(this.schemaRegion.getSchemaRegionId());
        if (Objects.isNull(snapshotPaths) || Objects.isNull(snapshotPaths.getLeft())) {
            if (listener.isOpened()) {
                logger.warn("Schema Region Listening Queue Listen to snapshot failed, the historical data may not be transferred. snapshotPaths:{}", snapshotPaths);
            }
            return;
        }
        listener.tryListenToSnapshot(((Path)snapshotPaths.getLeft()).toString(), Objects.nonNull(snapshotPaths.getRight()) && ((Path)snapshotPaths.getRight()).toFile().length() > 0L ? ((Path)snapshotPaths.getRight()).toString() : null, this.schemaRegion.getDatabaseFullPath());
    }

    public TSStatus write(IConsensusRequest request) {
        try {
            TSStatus result = ((PlanNode)request).accept(new SchemaExecutionVisitor(), this.schemaRegion);
            if (result.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                PipeAgent.runtime().schemaListener(this.schemaRegion.getSchemaRegionId()).tryListenToNode((PlanNode)request);
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    public DataSet read(IConsensusRequest request) {
        FragmentInstance fragmentInstance;
        try {
            fragmentInstance = this.getFragmentInstance(request);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage());
            return null;
        }
        logger.debug("SchemaRegionStateMachine[{}]: Execute read plan: FragmentInstance-{}", (Object)this.schemaRegion.getSchemaRegionId(), (Object)fragmentInstance.getId());
        return QUERY_INSTANCE_MANAGER.execSchemaQueryFragmentInstance(fragmentInstance, this.schemaRegion);
    }
}

