/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.exception.metadata;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class DataTypeMismatchException
extends MetadataException {
    public static final String REGISTERED_TYPE_STRING = "registered type";

    public DataTypeMismatchException(String deviceName, String measurementName, TSDataType insertType, TSDataType typeInSchema, long time, Object value) {
        super(String.format("data type of %s.%s is not consistent, %s %s, inserting type %s, timestamp %s, value %s", deviceName, measurementName, REGISTERED_TYPE_STRING, typeInSchema, insertType, time, value == null ? "null" : DataTypeMismatchException.processValue(value.toString())));
    }

    public DataTypeMismatchException(String deviceName, String measurementName, TSDataType insertType, long time, Object value) {
        super(String.format("data type and value of %s.%s is not consistent, inserting type %s, timestamp %s, value %s", deviceName, measurementName, insertType, time, value == null ? "null" : DataTypeMismatchException.processValue(value.toString())));
    }

    private static String processValue(String value) {
        return value.length() < 100 ? value : value.substring(0, 100);
    }
}

