/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.runtime;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.WrappedRunnable;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipePeriodicalJobExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePeriodicalJobExecutor.class);
    private static final ScheduledExecutorService PERIODICAL_JOB_EXECUTOR = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.PIPE_RUNTIME_PERIODICAL_JOB_EXECUTOR.getName());
    private static final long MIN_INTERVAL_SECONDS = PipeConfig.getInstance().getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds();
    private long rounds;
    private Future<?> executorFuture;
    private final List<Pair<WrappedRunnable, Long>> periodicalJobs = new CopyOnWriteArrayList<Pair<WrappedRunnable, Long>>();

    public void register(final String id, final Runnable periodicalJob, long intervalInSeconds) {
        this.periodicalJobs.add((Pair<WrappedRunnable, Long>)new Pair((Object)new WrappedRunnable(){

            public void runMayThrow() {
                try {
                    periodicalJob.run();
                }
                catch (Exception e) {
                    LOGGER.warn("Periodical job {} failed.", (Object)id, (Object)e);
                }
            }
        }, (Object)Math.max(intervalInSeconds / MIN_INTERVAL_SECONDS, 1L)));
        LOGGER.info("Pipe periodical job {} is registered successfully. Interval: {} seconds.", (Object)id, (Object)(Math.max(intervalInSeconds / MIN_INTERVAL_SECONDS, 1L) * MIN_INTERVAL_SECONDS));
    }

    public synchronized void start() {
        if (this.executorFuture == null) {
            this.rounds = 0L;
            this.executorFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)PERIODICAL_JOB_EXECUTOR, this::execute, (long)MIN_INTERVAL_SECONDS, (long)MIN_INTERVAL_SECONDS, (TimeUnit)TimeUnit.SECONDS);
            LOGGER.info("Pipe periodical job executor is started successfully.");
        }
    }

    private void execute() {
        ++this.rounds;
        for (Pair<WrappedRunnable, Long> periodicalJob : this.periodicalJobs) {
            if (this.rounds % (Long)periodicalJob.right != 0L) continue;
            ((WrappedRunnable)periodicalJob.left).run();
        }
    }

    public synchronized void stop() {
        if (this.executorFuture != null) {
            this.executorFuture.cancel(false);
            this.executorFuture = null;
            LOGGER.info("Pipe periodical job executor is stopped successfully.");
        }
    }

    public void clear() {
        this.periodicalJobs.clear();
        LOGGER.info("All pipe periodical jobs are cleared successfully.");
    }

    public static long getMinIntervalSeconds() {
        return MIN_INTERVAL_SECONDS;
    }
}

