/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBDataRegionAsyncConnector;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeTransferTabletInsertionEventHandler<E extends TPipeTransferResp>
implements AsyncMethodCallback<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferTabletInsertionEventHandler.class);
    protected final TabletInsertionEvent event;
    protected final TPipeTransferReq req;
    protected final IoTDBDataRegionAsyncConnector connector;

    protected PipeTransferTabletInsertionEventHandler(TabletInsertionEvent event, TPipeTransferReq req, IoTDBDataRegionAsyncConnector connector) {
        this.event = event;
        this.req = req;
        this.connector = connector;
    }

    public void transfer(AsyncPipeDataTransferServiceClient client) throws TException {
        this.doTransfer(client, this.req);
    }

    protected abstract void doTransfer(AsyncPipeDataTransferServiceClient var1, TPipeTransferReq var2) throws TException;

    public void onComplete(TPipeTransferResp response) {
        if (response == null) {
            this.onError((Exception)((Object)new PipeException("TPipeTransferResp is null")));
            return;
        }
        TSStatus status = response.getStatus();
        try {
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                this.connector.statusHandler().handle(response.getStatus(), response.getStatus().getMessage(), this.event.toString());
            }
            if (this.event instanceof EnrichedEvent) {
                ((EnrichedEvent)this.event).decreaseReferenceCount(PipeTransferTabletInsertionEventHandler.class.getName(), true);
            }
            if (status.isSetRedirectNode()) {
                this.updateLeaderCache(status);
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    protected abstract void updateLeaderCache(TSStatus var1);

    public void onError(Exception exception) {
        LOGGER.warn("Failed to transfer TabletInsertionEvent {} (committer key={}, commit id={}).", new Object[]{this.event instanceof EnrichedEvent ? ((EnrichedEvent)this.event).coreReportMessage() : this.event.toString(), this.event instanceof EnrichedEvent ? ((EnrichedEvent)this.event).getCommitterKey() : null, this.event instanceof EnrichedEvent ? Long.valueOf(((EnrichedEvent)this.event).getCommitId()) : null, exception});
        this.connector.addFailureEventToRetryQueue((Event)this.event);
    }
}

