/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.schema;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.PipeSnapshotEvent;
import org.apache.iotdb.commons.pipe.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaSerializableEventType;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeSchemaRegionSnapshotEvent
extends PipeSnapshotEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeSchemaRegionSnapshotEvent.class);
    private String mTreeSnapshotPath;
    private String tagLogSnapshotPath;
    private String databaseName;
    private static final Map<Short, StatementType> PLAN_NODE_2_STATEMENT_TYPE_MAP = new HashMap<Short, StatementType>();

    public PipeSchemaRegionSnapshotEvent() {
        this(null, null, null);
    }

    public PipeSchemaRegionSnapshotEvent(String mTreeSnapshotPath, String tagLogSnapshotPath, String databaseName) {
        this(mTreeSnapshotPath, tagLogSnapshotPath, databaseName, null, null, null);
    }

    public PipeSchemaRegionSnapshotEvent(String mTreeSnapshotPath, String tagLogSnapshotPath, String databaseName, String pipeName, PipeTaskMeta pipeTaskMeta, PipePattern pattern) {
        super(pipeName, pipeTaskMeta, pattern, PipeResourceManager.snapshot());
        this.mTreeSnapshotPath = mTreeSnapshotPath;
        this.tagLogSnapshotPath = Objects.nonNull(tagLogSnapshotPath) ? tagLogSnapshotPath : "";
        this.databaseName = databaseName;
    }

    public File getMTreeSnapshotFile() {
        return new File(this.mTreeSnapshotPath);
    }

    public File getTagLogSnapshotFile() {
        return !this.tagLogSnapshotPath.isEmpty() ? new File(this.tagLogSnapshotPath) : null;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        try {
            this.mTreeSnapshotPath = this.resourceManager.increaseSnapshotReference(this.mTreeSnapshotPath);
            if (!this.tagLogSnapshotPath.isEmpty()) {
                this.tagLogSnapshotPath = this.resourceManager.increaseSnapshotReference(this.tagLogSnapshotPath);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Increase reference count for mTree snapshot %s or tLog %s error. Holder Message: %s", this.mTreeSnapshotPath, this.tagLogSnapshotPath, holderMessage), (Throwable)e);
            return false;
        }
    }

    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        try {
            this.resourceManager.decreaseSnapshotReference(this.mTreeSnapshotPath);
            if (!this.tagLogSnapshotPath.isEmpty()) {
                this.resourceManager.decreaseSnapshotReference(this.tagLogSnapshotPath);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Decrease reference count for mTree snapshot %s or tLog %s error. Holder Message: %s", this.mTreeSnapshotPath, this.tagLogSnapshotPath, holderMessage), (Throwable)e);
            return false;
        }
    }

    public EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
        return new PipeSchemaRegionSnapshotEvent(this.mTreeSnapshotPath, this.tagLogSnapshotPath, this.databaseName, pipeName, pipeTaskMeta, pattern);
    }

    public ByteBuffer serializeToByteBuffer() {
        ByteBuffer result = ByteBuffer.allocate(13 + this.mTreeSnapshotPath.getBytes().length + this.tagLogSnapshotPath.getBytes().length + this.databaseName.getBytes().length);
        ReadWriteIOUtils.write((byte)PipeSchemaSerializableEventType.SCHEMA_SNAPSHOT.getType(), (ByteBuffer)result);
        ReadWriteIOUtils.write((String)this.mTreeSnapshotPath, (ByteBuffer)result);
        ReadWriteIOUtils.write((String)this.tagLogSnapshotPath, (ByteBuffer)result);
        ReadWriteIOUtils.write((String)this.databaseName, (ByteBuffer)result);
        return result;
    }

    public void deserializeFromByteBuffer(ByteBuffer buffer) {
        this.mTreeSnapshotPath = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.tagLogSnapshotPath = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.databaseName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
    }

    public static boolean needTransferSnapshot(Set<PlanNodeType> listenedTypeSet) {
        HashSet<Short> types = new HashSet<Short>(PLAN_NODE_2_STATEMENT_TYPE_MAP.keySet());
        types.retainAll(listenedTypeSet.stream().map(PlanNodeType::getNodeType).collect(Collectors.toSet()));
        return !types.isEmpty();
    }

    public void confineTransferredTypes(Set<PlanNodeType> listenedTypeSet) {
        HashSet<Short> types = new HashSet<Short>(PLAN_NODE_2_STATEMENT_TYPE_MAP.keySet());
        types.retainAll(listenedTypeSet.stream().map(PlanNodeType::getNodeType).collect(Collectors.toSet()));
        this.transferredTypes = types;
    }

    public static Set<StatementType> getStatementTypeSet(String sealTypes) {
        HashMap<Short, StatementType> statementTypeMap = new HashMap<Short, StatementType>(PLAN_NODE_2_STATEMENT_TYPE_MAP);
        statementTypeMap.keySet().retainAll(Arrays.stream(sealTypes.split(",")).map(Short::valueOf).collect(Collectors.toSet()));
        return new HashSet<StatementType>(statementTypeMap.values());
    }

    public String toString() {
        return String.format("PipeSchemaRegionSnapshotEvent{mTreeSnapshotPath=%s, tagLogSnapshotPath=%s, databaseName=%s}", this.mTreeSnapshotPath, this.tagLogSnapshotPath, this.databaseName) + " - " + super.toString();
    }

    public String coreReportMessage() {
        return String.format("PipeSchemaRegionSnapshotEvent{mTreeSnapshotPath=%s, tagLogSnapshotPath=%s, databaseName=%s}", this.mTreeSnapshotPath, this.tagLogSnapshotPath, this.databaseName) + " - " + super.coreReportMessage();
    }

    static {
        PLAN_NODE_2_STATEMENT_TYPE_MAP.put(PlanNodeType.CREATE_TIME_SERIES.getNodeType(), StatementType.CREATE_TIME_SERIES);
        PLAN_NODE_2_STATEMENT_TYPE_MAP.put(PlanNodeType.CREATE_ALIGNED_TIME_SERIES.getNodeType(), StatementType.CREATE_ALIGNED_TIME_SERIES);
        PLAN_NODE_2_STATEMENT_TYPE_MAP.put(PlanNodeType.INTERNAL_CREATE_MULTI_TIMESERIES.getNodeType(), StatementType.INTERNAL_CREATE_MULTI_TIMESERIES);
        PLAN_NODE_2_STATEMENT_TYPE_MAP.put(PlanNodeType.ACTIVATE_TEMPLATE.getNodeType(), StatementType.ACTIVATE_TEMPLATE);
        PLAN_NODE_2_STATEMENT_TYPE_MAP.put(PlanNodeType.BATCH_ACTIVATE_TEMPLATE.getNodeType(), StatementType.BATCH_ACTIVATE_TEMPLATE);
        PLAN_NODE_2_STATEMENT_TYPE_MAP.put(PlanNodeType.CREATE_LOGICAL_VIEW.getNodeType(), StatementType.CREATE_LOGICAL_VIEW);
        PLAN_NODE_2_STATEMENT_TYPE_MAP.put(PlanNodeType.ALTER_LOGICAL_VIEW.getNodeType(), StatementType.ALTER_LOGICAL_VIEW);
    }
}

