/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.TsFileInsertionDataContainer;
import org.apache.iotdb.db.pipe.event.common.tsfile.TsFileInsertionPointCounter;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTsFileInsertionEvent
extends EnrichedEvent
implements TsFileInsertionEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFileInsertionEvent.class);
    private final TsFileResource resource;
    private File tsFile;
    private boolean isWithMod;
    private File modFile;
    private final boolean isLoaded;
    private final boolean isGeneratedByPipe;
    private final AtomicBoolean isClosed;
    private TsFileInsertionDataContainer dataContainer;

    public PipeTsFileInsertionEvent(TsFileResource resource, boolean isLoaded, boolean isGeneratedByPipe) {
        this(resource, true, isLoaded, isGeneratedByPipe, null, null, null, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public PipeTsFileInsertionEvent(TsFileResource resource, boolean isWithMod, boolean isLoaded, boolean isGeneratedByPipe, String pipeName, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
        super(pipeName, pipeTaskMeta, pattern, startTime, endTime);
        TsFileProcessor processor;
        this.resource = resource;
        this.tsFile = resource.getTsFile();
        ModificationFile modFile = resource.getModFile();
        this.isWithMod = isWithMod && modFile.exists();
        this.modFile = this.isWithMod ? new File(modFile.getFilePath()) : null;
        this.isLoaded = isLoaded;
        this.isGeneratedByPipe = isGeneratedByPipe;
        this.isClosed = new AtomicBoolean(resource.isClosed());
        if (!this.isClosed.get() && (processor = resource.getProcessor()) != null) {
            processor.addCloseFileListener(o -> {
                AtomicBoolean atomicBoolean = this.isClosed;
                synchronized (atomicBoolean) {
                    this.isClosed.set(true);
                    this.isClosed.notifyAll();
                }
            });
        }
        this.isClosed.set(resource.isClosed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForTsFileClose() throws InterruptedException {
        if (!this.isClosed.get()) {
            AtomicBoolean atomicBoolean = this.isClosed;
            synchronized (atomicBoolean) {
                while (!this.isClosed.get()) {
                    this.isClosed.wait();
                }
            }
        }
        return !this.resource.isEmpty();
    }

    public File getTsFile() {
        return this.tsFile;
    }

    public File getModFile() {
        return this.modFile;
    }

    public boolean isWithMod() {
        return this.isWithMod;
    }

    public void disableMod4NonTransferPipes(boolean isWithMod) {
        this.isWithMod = isWithMod && this.isWithMod;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public long getFileStartTime() {
        return this.resource.getFileStartTime();
    }

    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        try {
            this.tsFile = PipeResourceManager.tsfile().increaseFileReference(this.tsFile, true);
            if (this.isWithMod) {
                this.modFile = PipeResourceManager.tsfile().increaseFileReference(this.modFile, false);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Increase reference count for TsFile %s or modFile %s error. Holder Message: %s", this.tsFile, this.modFile, holderMessage), (Throwable)e);
            return false;
        }
    }

    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        try {
            PipeResourceManager.tsfile().decreaseFileReference(this.tsFile);
            if (this.isWithMod) {
                PipeResourceManager.tsfile().decreaseFileReference(this.modFile);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Decrease reference count for TsFile %s error. Holder Message: %s", this.tsFile.getPath(), holderMessage), (Throwable)e);
            return false;
        }
    }

    public ProgressIndex getProgressIndex() {
        try {
            if (!this.waitForTsFileClose()) {
                LOGGER.warn("Skipping temporary TsFile {}'s progressIndex, will report MinimumProgressIndex", (Object)this.tsFile);
                return MinimumProgressIndex.INSTANCE;
            }
            return this.resource.getMaxProgressIndexAfterClose();
        }
        catch (InterruptedException e) {
            LOGGER.warn(String.format("Interrupted when waiting for closing TsFile %s.", this.resource.getTsFilePath()));
            Thread.currentThread().interrupt();
            return MinimumProgressIndex.INSTANCE;
        }
    }

    public PipeTsFileInsertionEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
        return new PipeTsFileInsertionEvent(this.resource, this.isWithMod, this.isLoaded, this.isGeneratedByPipe, pipeName, pipeTaskMeta, pattern, startTime, endTime);
    }

    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    public boolean mayEventTimeOverlappedWithTimeRange() {
        return this.isClosed.get() ? this.startTime <= this.resource.getFileEndTime() && this.resource.getFileStartTime() <= this.endTime : this.resource.getFileStartTime() <= this.endTime;
    }

    public boolean shouldParseTimeOrPattern() {
        boolean shouldParseTimeOrPattern = false;
        try {
            boolean bl = shouldParseTimeOrPattern = super.shouldParseTimeOrPattern();
            return bl;
        }
        finally {
            if (!shouldParseTimeOrPattern) {
                this.close();
            }
        }
    }

    public boolean shouldParsePattern() {
        return super.shouldParsePattern() && this.initDataContainer().shouldParsePattern();
    }

    public Iterable<TabletInsertionEvent> toTabletInsertionEvents() {
        try {
            if (!this.waitForTsFileClose()) {
                LOGGER.warn("Pipe skipping temporary TsFile's parsing which shouldn't be transferred: {}", (Object)this.tsFile);
                return Collections.emptyList();
            }
            return this.initDataContainer().toTabletInsertionEvents();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.close();
            String errorMsg = String.format("Interrupted when waiting for closing TsFile %s.", this.resource.getTsFilePath());
            LOGGER.warn(errorMsg, (Throwable)e);
            throw new PipeException(errorMsg);
        }
    }

    private TsFileInsertionDataContainer initDataContainer() {
        try {
            if (this.dataContainer == null) {
                this.dataContainer = new TsFileInsertionDataContainer(this.tsFile, this.pipePattern, this.startTime, this.endTime, this.pipeTaskMeta, this);
            }
            return this.dataContainer;
        }
        catch (IOException e) {
            this.close();
            String errorMsg = String.format("Read TsFile %s error.", this.resource.getTsFilePath());
            LOGGER.warn(errorMsg, (Throwable)e);
            throw new PipeException(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(boolean skipReportOnCommit) throws IOException {
        long count = 0L;
        if (this.shouldParseTime()) {
            try {
                for (TabletInsertionEvent event : this.toTabletInsertionEvents()) {
                    PipeRawTabletInsertionEvent rawEvent = (PipeRawTabletInsertionEvent)event;
                    count += rawEvent.count();
                    if (!skipReportOnCommit) continue;
                    rawEvent.skipReportOnCommit();
                }
                long l = count;
                return l;
            }
            finally {
                this.close();
            }
        }
        try (TsFileInsertionPointCounter counter = new TsFileInsertionPointCounter(this.tsFile, this.pipePattern);){
            long l = counter.count();
            return l;
        }
    }

    public void close() {
        if (this.dataContainer != null) {
            this.dataContainer.close();
            this.dataContainer = null;
        }
    }

    public String toString() {
        return String.format("PipeTsFileInsertionEvent{resource=%s, tsFile=%s, isLoaded=%s, isGeneratedByPipe=%s, isClosed=%s, dataContainer=%s}", this.resource, this.tsFile, this.isLoaded, this.isGeneratedByPipe, this.isClosed.get(), this.dataContainer) + " - " + super.toString();
    }

    public String coreReportMessage() {
        return String.format("PipeTsFileInsertionEvent{resource=%s, tsFile=%s, isLoaded=%s, isGeneratedByPipe=%s, isClosed=%s}", this.resource, this.tsFile, this.isLoaded, this.isGeneratedByPipe, this.isClosed.get()) + " - " + super.coreReportMessage();
    }
}

