/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.dataregion;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.pipe.extractor.IoTDBExtractor;
import org.apache.iotdb.commons.pipe.pattern.PipePattern;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.extractor.dataregion.DataRegionListeningFilter;
import org.apache.iotdb.db.pipe.extractor.dataregion.DataRegionWatermarkInjector;
import org.apache.iotdb.db.pipe.extractor.dataregion.historical.PipeHistoricalDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.dataregion.historical.PipeHistoricalDataRegionTsFileExtractor;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.PipeRealtimeDataRegionFakeExtractor;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.PipeRealtimeDataRegionHybridExtractor;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.PipeRealtimeDataRegionLogExtractor;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.PipeRealtimeDataRegionTsFileExtractor;
import org.apache.iotdb.db.pipe.metric.PipeExtractorMetrics;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALMode;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataRegionExtractor
extends IoTDBExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataRegionExtractor.class);
    private PipeHistoricalDataRegionExtractor historicalExtractor;
    private PipeRealtimeDataRegionExtractor realtimeExtractor;
    private DataRegionWatermarkInjector watermarkInjector;
    private boolean hasNoExtractionNeed = true;

    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        Pair<Boolean, Boolean> insertionDeletionListeningOptionPair = DataRegionListeningFilter.parseInsertionDeletionListeningOptionPair(validator.getParameters());
        if (((Boolean)insertionDeletionListeningOptionPair.getLeft()).equals(false) && ((Boolean)insertionDeletionListeningOptionPair.getRight()).equals(false)) {
            return;
        }
        this.hasNoExtractionNeed = false;
        if (((Boolean)insertionDeletionListeningOptionPair.getLeft()).equals(true) && IoTDBDescriptor.getInstance().getConfig().getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            throw new PipeException("The pipe cannot transfer data when data region is using ratis consensus.");
        }
        validator.validateAttributeValueRange("extractor.pattern.format", true, new String[]{"prefix", "iotdb"}).validateAttributeValueRange("source.pattern.format", true, new String[]{"prefix", "iotdb"});
        PipePattern pattern = PipePattern.parsePipePatternFromSourceParameters((PipeParameters)validator.getParameters());
        this.validatePattern(pattern);
        validator.validateAttributeValueRange("extractor.history.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("extractor.realtime.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("source.history.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("source.realtime.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validate(args -> (Boolean)args[0] != false || (Boolean)args[1] != false, "Should not set both history.enable and realtime.enable to false.", new Object[]{validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.history.enable", "source.history.enable"), true), validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.realtime.enable", "source.realtime.enable"), true)});
        if (validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.realtime.enable", "source.realtime.enable"), true) || validator.getParameters().hasAnyAttributes(new String[]{"source.start-time", "source.end-time"})) {
            validator.validateAttributeValueRange(validator.getParameters().hasAttribute("extractor.realtime.mode") ? "extractor.realtime.mode" : "source.realtime.mode", true, new String[]{"file", "hybrid", "log", "forced-log", "stream", "batch"});
        }
        if (validator.getParameters().hasAnyAttributes(new String[]{"source.start-time", "source.end-time"}) && validator.getParameters().hasAnyAttributes(new String[]{"extractor.history.enable", "extractor.realtime.enable", "source.history.enable", "source.realtime.enable"})) {
            LOGGER.warn("When {}, {}, {} or {} is specified, specifying {}, {}, {} and {} is invalid.", new Object[]{"source.start-time", "extractor.start-time", "source.end-time", "extractor.end-time", "source.history.start-time", "extractor.history.start-time", "source.history.end-time", "extractor.history.end-time"});
        }
        this.constructHistoricalExtractor();
        this.constructRealtimeExtractor(validator.getParameters());
        this.historicalExtractor.validate(validator);
        this.realtimeExtractor.validate(validator);
    }

    private void validatePattern(PipePattern pattern) {
        if (!pattern.isLegal()) {
            throw new IllegalArgumentException(String.format("Pattern \"%s\" is illegal.", pattern));
        }
    }

    private void constructHistoricalExtractor() {
        this.historicalExtractor = new PipeHistoricalDataRegionTsFileExtractor();
    }

    private void constructRealtimeExtractor(PipeParameters parameters) throws IllegalPathException {
        if (!parameters.getBooleanOrDefault(Arrays.asList("extractor.realtime.enable", "source.realtime.enable"), true)) {
            this.realtimeExtractor = new PipeRealtimeDataRegionFakeExtractor();
            LOGGER.info("Pipe: '{}' is set to false, use fake realtime extractor.", (Object)"extractor.realtime.enable");
            return;
        }
        if (!parameters.hasAnyAttributes(new String[]{"extractor.realtime.mode", "source.realtime.mode"})) {
            this.checkWalEnable(parameters);
            this.realtimeExtractor = new PipeRealtimeDataRegionHybridExtractor();
            LOGGER.info("Pipe: '{}' is not set, use hybrid mode by default.", (Object)"extractor.realtime.mode");
            return;
        }
        switch (parameters.getStringByKeys(new String[]{"extractor.realtime.mode", "source.realtime.mode"})) {
            case "file": 
            case "batch": {
                this.realtimeExtractor = new PipeRealtimeDataRegionTsFileExtractor();
                break;
            }
            case "hybrid": 
            case "log": 
            case "stream": {
                this.checkWalEnable(parameters);
                this.realtimeExtractor = new PipeRealtimeDataRegionHybridExtractor();
                break;
            }
            case "forced-log": {
                this.checkWalEnable(parameters);
                this.realtimeExtractor = new PipeRealtimeDataRegionLogExtractor();
                break;
            }
            default: {
                this.checkWalEnable(parameters);
                this.realtimeExtractor = new PipeRealtimeDataRegionHybridExtractor();
                if (!LOGGER.isWarnEnabled()) break;
                LOGGER.warn("Pipe: Unsupported extractor realtime mode: {}, create a hybrid extractor.", (Object)parameters.getStringByKeys(new String[]{"extractor.realtime.mode", "source.realtime.mode"}));
            }
        }
    }

    private void checkWalEnable(PipeParameters parameters) throws IllegalPathException {
        if (Boolean.TRUE.equals(DataRegionListeningFilter.parseInsertionDeletionListeningOptionPair(parameters).getLeft()) && IoTDBDescriptor.getInstance().getConfig().getWalMode().equals((Object)WALMode.DISABLE)) {
            throw new PipeException("The pipe cannot transfer realtime insertion if data region disables wal. Please set 'realtime.mode'='batch' in source parameters when enabling realtime transmission.");
        }
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        long watermarkIntervalInMs;
        if (this.hasNoExtractionNeed) {
            return;
        }
        super.customize(parameters, configuration);
        this.historicalExtractor.customize(parameters, configuration);
        this.realtimeExtractor.customize(parameters, configuration);
        if (parameters.hasAnyAttributes(new String[]{"extractor.watermark-interval-ms", "source.watermark-interval-ms"}) && (watermarkIntervalInMs = parameters.getLongOrDefault(Arrays.asList("extractor.watermark-interval-ms", "source.watermark-interval-ms"), -1L)) > 0L) {
            this.watermarkInjector = new DataRegionWatermarkInjector(this.regionId, watermarkIntervalInMs);
            LOGGER.info("Pipe {}@{}: Set watermark injector with interval {} ms.", new Object[]{this.pipeName, this.regionId, this.watermarkInjector.getInjectionIntervalInMs()});
        }
        PipeExtractorMetrics.getInstance().register(this);
    }

    public void start() throws Exception {
        if (this.hasNoExtractionNeed || this.hasBeenStarted.get()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        LOGGER.info("Pipe {}@{}: Starting historical extractor {} and realtime extractor {}.", new Object[]{this.pipeName, this.regionId, this.historicalExtractor.getClass().getSimpleName(), this.realtimeExtractor.getClass().getSimpleName()});
        super.start();
        AtomicReference<Object> exceptionHolder = new AtomicReference<Object>(null);
        DataRegionId dataRegionIdObject = new DataRegionId(this.regionId);
        while (true) {
            if (StorageEngine.getInstance().runIfPresent(dataRegionIdObject, dataRegion -> {
                dataRegion.writeLock(String.format("Pipe: starting %s", IoTDBDataRegionExtractor.class.getName()));
                try {
                    this.startHistoricalExtractorAndRealtimeExtractor(exceptionHolder);
                }
                finally {
                    dataRegion.writeUnlock();
                }
            }) || StorageEngine.getInstance().runIfAbsent(dataRegionIdObject, () -> this.startHistoricalExtractorAndRealtimeExtractor(exceptionHolder))) {
                this.rethrowExceptionIfAny(exceptionHolder);
                LOGGER.info("Pipe {}@{}: Started historical extractor {} and realtime extractor {} successfully within {} ms.", new Object[]{this.pipeName, this.regionId, this.historicalExtractor.getClass().getSimpleName(), this.realtimeExtractor.getClass().getSimpleName(), System.currentTimeMillis() - startTime});
                return;
            }
            this.rethrowExceptionIfAny(exceptionHolder);
        }
    }

    private void startHistoricalExtractorAndRealtimeExtractor(AtomicReference<Exception> exceptionHolder) {
        try {
            this.realtimeExtractor.start();
            this.historicalExtractor.start();
        }
        catch (Exception e) {
            exceptionHolder.set(e);
            LOGGER.warn("Pipe {}@{}: Start historical extractor {} and realtime extractor {} error.", new Object[]{this.pipeName, this.regionId, this.historicalExtractor.getClass().getSimpleName(), this.realtimeExtractor.getClass().getSimpleName(), e});
        }
    }

    private void rethrowExceptionIfAny(AtomicReference<Exception> exceptionHolder) {
        if (exceptionHolder.get() != null) {
            throw new PipeException("failed to start extractors.", (Throwable)exceptionHolder.get());
        }
    }

    public Event supply() throws Exception {
        if (this.hasNoExtractionNeed) {
            return null;
        }
        Event event = null;
        if (!this.historicalExtractor.hasConsumedAll()) {
            event = this.historicalExtractor.supply();
        } else {
            if (Objects.nonNull(this.watermarkInjector)) {
                event = this.watermarkInjector.inject();
            }
            if (Objects.isNull(event)) {
                event = this.realtimeExtractor.supply();
            }
        }
        if (Objects.nonNull(event)) {
            if (event instanceof TabletInsertionEvent) {
                PipeExtractorMetrics.getInstance().markTabletEvent(this.taskID);
            } else if (event instanceof TsFileInsertionEvent) {
                PipeExtractorMetrics.getInstance().markTsFileEvent(this.taskID);
            } else if (event instanceof PipeHeartbeatEvent) {
                PipeExtractorMetrics.getInstance().markPipeHeartbeatEvent(this.taskID);
            }
        }
        return event;
    }

    public void close() throws Exception {
        if (this.hasNoExtractionNeed || !this.hasBeenStarted.get()) {
            return;
        }
        this.historicalExtractor.close();
        this.realtimeExtractor.close();
        if (Objects.nonNull(this.taskID)) {
            PipeExtractorMetrics.getInstance().deregister(this.taskID);
        }
    }

    public boolean isStreamMode() {
        return this.realtimeExtractor instanceof PipeRealtimeDataRegionHybridExtractor || this.realtimeExtractor instanceof PipeRealtimeDataRegionLogExtractor;
    }

    public boolean hasConsumedAllHistoricalTsFiles() {
        return this.historicalExtractor.hasConsumedAll();
    }

    public String getTaskID() {
        return this.taskID;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public int getDataRegionId() {
        return this.regionId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getHistoricalTsFileInsertionEventCount() {
        return this.hasBeenStarted.get() ? this.historicalExtractor.getPendingQueueSize() : 0;
    }

    public int getTabletInsertionEventCount() {
        return this.hasBeenStarted.get() ? this.realtimeExtractor.getTabletInsertionEventCount() : 0;
    }

    public int getRealtimeTsFileInsertionEventCount() {
        return this.hasBeenStarted.get() ? this.realtimeExtractor.getTsFileInsertionEventCount() : 0;
    }

    public int getPipeHeartbeatEventCount() {
        return this.hasBeenStarted.get() ? this.realtimeExtractor.getPipeHeartbeatEventCount() : 0;
    }
}

