/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.dataregion.realtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.metric.PipeEventCounter;
import org.apache.iotdb.commons.pipe.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.dataregion.DataRegionListeningFilter;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.listener.PipeInsertionDataNodeListener;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.listener.PipeTimePartitionListener;
import org.apache.iotdb.db.pipe.metric.PipeDataRegionEventCounter;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;
import org.apache.iotdb.tsfile.utils.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeRealtimeDataRegionExtractor
implements PipeExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeRealtimeDataRegionExtractor.class);
    protected String pipeName;
    protected String dataRegionId;
    protected PipeTaskMeta pipeTaskMeta;
    protected boolean shouldExtractInsertion;
    protected boolean shouldExtractDeletion;
    protected PipePattern pipePattern;
    private boolean isDbNameCoveredByPattern = false;
    protected long realtimeDataExtractionStartTime = Long.MIN_VALUE;
    protected long realtimeDataExtractionEndTime = Long.MAX_VALUE;
    private boolean disableSkippingTimeParse = false;
    private long startTimePartitionIdLowerBound;
    private long endTimePartitionIdUpperBound;
    private final AtomicReference<Pair<Long, Long>> dataRegionTimePartitionIdBound = new AtomicReference();
    protected boolean isForwardingPipeRequests;
    private boolean shouldTransferModFile;
    protected final UnboundedBlockingPendingQueue<Event> pendingQueue = new UnboundedBlockingPendingQueue((PipeEventCounter)new PipeDataRegionEventCounter());
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    private String taskID;

    protected PipeRealtimeDataRegionExtractor() {
    }

    public void validate(PipeParameterValidator validator) throws Exception {
        PipeParameters parameters = validator.getParameters();
        try {
            this.realtimeDataExtractionStartTime = parameters.hasAnyAttributes(new String[]{"source.start-time", "extractor.start-time"}) ? DateTimeUtils.convertTimestampOrDatetimeStrToLongWithDefaultZone(parameters.getStringByKeys(new String[]{"source.start-time", "extractor.start-time"})) : Long.MIN_VALUE;
            long l = this.realtimeDataExtractionEndTime = parameters.hasAnyAttributes(new String[]{"source.end-time", "extractor.end-time"}) ? DateTimeUtils.convertTimestampOrDatetimeStrToLongWithDefaultZone(parameters.getStringByKeys(new String[]{"source.end-time", "extractor.end-time"})) : Long.MAX_VALUE;
            if (this.realtimeDataExtractionStartTime > this.realtimeDataExtractionEndTime) {
                throw new PipeParameterNotValidException(String.format("%s or %s should be less than or equal to %s or %s.", "source.start-time", "extractor.start-time", "source.end-time", "extractor.end-time"));
            }
        }
        catch (Exception e) {
            throw new PipeParameterNotValidException(e.getMessage());
        }
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        String databaseName;
        PipeTaskExtractorRuntimeEnvironment environment = (PipeTaskExtractorRuntimeEnvironment)configuration.getRuntimeEnvironment();
        Pair<Boolean, Boolean> insertionDeletionListeningOptionPair = DataRegionListeningFilter.parseInsertionDeletionListeningOptionPair(parameters);
        this.shouldExtractInsertion = (Boolean)insertionDeletionListeningOptionPair.getLeft();
        this.shouldExtractDeletion = (Boolean)insertionDeletionListeningOptionPair.getRight();
        this.pipeName = environment.getPipeName();
        this.dataRegionId = String.valueOf(environment.getRegionId());
        this.pipeTaskMeta = environment.getPipeTaskMeta();
        long creationTime = environment.getCreationTime();
        this.taskID = this.pipeName + "_" + this.dataRegionId + "_" + creationTime;
        this.pipePattern = PipePattern.parsePipePatternFromSourceParameters((PipeParameters)parameters);
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(environment.getRegionId()));
        if (dataRegion != null && (databaseName = dataRegion.getDatabaseName()) != null) {
            this.isDbNameCoveredByPattern = this.pipePattern.coversDb(databaseName);
        }
        this.startTimePartitionIdLowerBound = this.realtimeDataExtractionStartTime % TimePartitionUtils.getTimePartitionInterval() == 0L ? TimePartitionUtils.getTimePartitionId((long)this.realtimeDataExtractionStartTime) : TimePartitionUtils.getTimePartitionId((long)this.realtimeDataExtractionStartTime) + 1L;
        this.endTimePartitionIdUpperBound = this.realtimeDataExtractionEndTime % TimePartitionUtils.getTimePartitionInterval() == 0L ? TimePartitionUtils.getTimePartitionId((long)this.realtimeDataExtractionEndTime) : TimePartitionUtils.getTimePartitionId((long)this.realtimeDataExtractionEndTime) - 1L;
        this.isForwardingPipeRequests = parameters.getBooleanOrDefault(Arrays.asList("extractor.forwarding-pipe-requests", "source.forwarding-pipe-requests"), true);
        this.shouldTransferModFile = parameters.getBooleanOrDefault(Arrays.asList("source.mods.enable", "extractor.mods.enable"), this.shouldExtractDeletion);
    }

    public void start() throws Exception {
        PipeTimePartitionListener.getInstance().startListen(this.dataRegionId, this);
        PipeInsertionDataNodeListener.getInstance().startListenAndAssign(this.dataRegionId, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        if (Objects.nonNull(this.dataRegionId)) {
            PipeInsertionDataNodeListener.getInstance().stopListenAndAssign(this.dataRegionId, this);
            PipeTimePartitionListener.getInstance().stopListen(this.dataRegionId, this);
        }
        AtomicBoolean atomicBoolean = this.isClosed;
        synchronized (atomicBoolean) {
            this.clearPendingQueue();
            this.isClosed.set(true);
        }
    }

    private void clearPendingQueue() {
        ArrayList eventsToDrop = new ArrayList(this.pendingQueue.size());
        this.pendingQueue.forEach(eventsToDrop::add);
        this.pendingQueue.clear();
        eventsToDrop.forEach(event -> {
            if (event instanceof EnrichedEvent) {
                ((EnrichedEvent)event).clearReferenceCount(PipeRealtimeDataRegionExtractor.class.getName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extract(PipeRealtimeEvent event) {
        if (this.isDbNameCoveredByPattern) {
            event.skipParsingPattern();
        }
        if (!this.disableSkippingTimeParse && Objects.nonNull(this.dataRegionTimePartitionIdBound.get())) {
            if (this.isDataRegionTimePartitionCoveredByTimeRange()) {
                event.skipParsingTime();
            } else {
                this.disableSkippingTimeParse = true;
            }
        }
        if (!event.shouldParseTime() || event.getEvent().mayEventTimeOverlappedWithTimeRange()) {
            this.doExtract(event);
        } else {
            event.decreaseReferenceCount(PipeRealtimeDataRegionExtractor.class.getName(), false);
        }
        AtomicBoolean atomicBoolean = this.isClosed;
        synchronized (atomicBoolean) {
            if (this.isClosed.get()) {
                this.clearPendingQueue();
            }
        }
    }

    protected abstract void doExtract(PipeRealtimeEvent var1);

    protected void extractHeartbeat(PipeRealtimeEvent event) {
        ((PipeHeartbeatEvent)event.getEvent()).bindExtractor(this);
        ((PipeHeartbeatEvent)event.getEvent()).recordExtractorQueueSize(this.pendingQueue);
        Event lastEvent = this.pendingQueue.peekLast();
        if (lastEvent instanceof PipeRealtimeEvent && ((PipeRealtimeEvent)lastEvent).getEvent() instanceof PipeHeartbeatEvent && (((PipeHeartbeatEvent)((PipeRealtimeEvent)lastEvent).getEvent()).isShouldPrintMessage() || !((PipeHeartbeatEvent)event.getEvent()).isShouldPrintMessage())) {
            event.decreaseReferenceCount(PipeRealtimeDataRegionExtractor.class.getName(), false);
            return;
        }
        if (!this.pendingQueue.waitedOffer((Event)event)) {
            LOGGER.error("extract: pending queue of PipeRealtimeDataRegionHybridExtractor {} has reached capacity, discard heartbeat event {}", (Object)this, (Object)event);
            event.decreaseReferenceCount(PipeRealtimeDataRegionExtractor.class.getName(), false);
        }
    }

    protected void extractDeletion(PipeRealtimeEvent event) {
        if (!this.pendingQueue.waitedOffer((Event)event)) {
            String errorMessage = String.format("extract: pending queue of %s %s has reached capacity, discard deletion event %s", new Object[]{this.getClass().getSimpleName(), this, event});
            LOGGER.error(errorMessage);
            PipeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
            event.decreaseReferenceCount(PipeRealtimeDataRegionExtractor.class.getName(), false);
        }
    }

    protected Event supplyHeartbeat(PipeRealtimeEvent event) {
        if (event.increaseReferenceCount(PipeRealtimeDataRegionExtractor.class.getName())) {
            return event.getEvent();
        }
        LOGGER.error("Heartbeat Event {} can not be supplied because the reference count can not be increased", (Object)event.getEvent());
        return null;
    }

    protected Event supplyDeletion(PipeRealtimeEvent event) {
        if (event.increaseReferenceCount(PipeRealtimeDataRegionExtractor.class.getName())) {
            return event.getEvent();
        }
        String errorMessage = String.format("TsFile Event %s can not be supplied because the reference count can not be increased, the data represented by this event is lost", event.getEvent());
        LOGGER.error(errorMessage);
        PipeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
        return null;
    }

    public final String getPipeName() {
        return this.pipeName;
    }

    public final PipeTaskMeta getPipeTaskMeta() {
        return this.pipeTaskMeta;
    }

    public final boolean shouldExtractInsertion() {
        return this.shouldExtractInsertion;
    }

    public final boolean shouldExtractDeletion() {
        return this.shouldExtractDeletion;
    }

    public final String getPatternString() {
        return this.pipePattern != null ? this.pipePattern.getPattern() : null;
    }

    public final PipePattern getPipePattern() {
        return this.pipePattern;
    }

    public final long getRealtimeDataExtractionStartTime() {
        return this.realtimeDataExtractionStartTime;
    }

    public final long getRealtimeDataExtractionEndTime() {
        return this.realtimeDataExtractionEndTime;
    }

    public void setDataRegionTimePartitionIdBound(@NonNull Pair<Long, Long> timePartitionIdBound) {
        LOGGER.info("PipeRealtimeDataRegionExtractor({}) observed data region {} time partition growth, recording time partition id bound: {}.", new Object[]{this.taskID, this.dataRegionId, timePartitionIdBound});
        this.dataRegionTimePartitionIdBound.set(timePartitionIdBound);
    }

    private boolean isDataRegionTimePartitionCoveredByTimeRange() {
        Pair<Long, Long> timePartitionIdBound = this.dataRegionTimePartitionIdBound.get();
        return this.startTimePartitionIdLowerBound <= (Long)timePartitionIdBound.left && (Long)timePartitionIdBound.right <= this.endTimePartitionIdUpperBound;
    }

    public final boolean isForwardingPipeRequests() {
        return this.isForwardingPipeRequests;
    }

    public abstract boolean isNeedListenToTsFile();

    public abstract boolean isNeedListenToInsertNode();

    public final boolean isShouldTransferModFile() {
        return this.shouldTransferModFile;
    }

    public String toString() {
        return "PipeRealtimeDataRegionExtractor{pipePattern='" + this.pipePattern + '\'' + ", dataRegionId='" + this.dataRegionId + '\'' + '}';
    }

    public int getTabletInsertionEventCount() {
        return this.pendingQueue.getTabletInsertionEventCount();
    }

    public int getTsFileInsertionEventCount() {
        return this.pendingQueue.getTsFileInsertionEventCount();
    }

    public int getPipeHeartbeatEventCount() {
        return this.pendingQueue.getPipeHeartbeatEventCount();
    }

    public String getTaskID() {
        return this.taskID;
    }
}

