/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.dataregion.realtime.assigner;

import com.lmax.disruptor.EventHandler;
import java.io.Closeable;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.assigner.DisruptorQueue;
import org.apache.iotdb.db.pipe.metric.PipeAssignerMetrics;
import org.apache.iotdb.db.pipe.pattern.CachedSchemaPatternMatcher;
import org.apache.iotdb.db.pipe.pattern.PipeDataRegionMatcher;

public class PipeDataRegionAssigner
implements Closeable {
    private final PipeDataRegionMatcher matcher = new CachedSchemaPatternMatcher();
    private final DisruptorQueue disruptor = new DisruptorQueue((EventHandler<PipeRealtimeEvent>)((EventHandler)this::assignToExtractor));
    private final String dataRegionId;

    public String getDataRegionId() {
        return this.dataRegionId;
    }

    public PipeDataRegionAssigner(String dataRegionId) {
        this.dataRegionId = dataRegionId;
        PipeAssignerMetrics.getInstance().register(this);
    }

    public void publishToAssign(PipeRealtimeEvent event) {
        event.increaseReferenceCount(PipeDataRegionAssigner.class.getName());
        this.disruptor.publish(event);
        if (event.getEvent() instanceof PipeHeartbeatEvent) {
            ((PipeHeartbeatEvent)event.getEvent()).onPublished();
        }
    }

    public void assignToExtractor(PipeRealtimeEvent event, long sequence, boolean endOfBatch) {
        this.matcher.match(event).forEach(extractor -> {
            if (event.getEvent().isGeneratedByPipe() && !extractor.isForwardingPipeRequests()) {
                return;
            }
            PipeRealtimeEvent copiedEvent = event.shallowCopySelfAndBindPipeTaskMetaForProgressReport(extractor.getPipeName(), extractor.getPipeTaskMeta(), extractor.getPipePattern(), extractor.getRealtimeDataExtractionStartTime(), extractor.getRealtimeDataExtractionEndTime());
            EnrichedEvent innerEvent = copiedEvent.getEvent();
            if (innerEvent instanceof PipeTsFileInsertionEvent) {
                ((PipeTsFileInsertionEvent)innerEvent).disableMod4NonTransferPipes(extractor.isShouldTransferModFile());
            }
            copiedEvent.increaseReferenceCount(PipeDataRegionAssigner.class.getName());
            extractor.extract(copiedEvent);
            if (innerEvent instanceof PipeHeartbeatEvent) {
                ((PipeHeartbeatEvent)innerEvent).bindPipeName(extractor.getPipeName());
                ((PipeHeartbeatEvent)innerEvent).onAssigned();
            }
        });
        event.gcSchemaInfo();
        event.decreaseReferenceCount(PipeDataRegionAssigner.class.getName(), false);
    }

    public void startAssignTo(PipeRealtimeDataRegionExtractor extractor) {
        this.matcher.register(extractor);
    }

    public void stopAssignTo(PipeRealtimeDataRegionExtractor extractor) {
        this.matcher.deregister(extractor);
    }

    public boolean notMoreExtractorNeededToBeAssigned() {
        return this.matcher.getRegisterCount() == 0;
    }

    @Override
    public void close() {
        PipeAssignerMetrics.getInstance().deregister(this.dataRegionId);
        this.matcher.clear();
        this.disruptor.clear();
    }

    public int getTabletInsertionEventCount() {
        return this.disruptor.getTabletInsertionEventCount();
    }

    public int getTsFileInsertionEventCount() {
        return this.disruptor.getTsFileInsertionEventCount();
    }

    public int getPipeHeartbeatEventCount() {
        return this.disruptor.getPipeHeartbeatEventCount();
    }
}

