/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.dataregion.realtime.epoch;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.epoch.TsFileEpochStateMigrator;
import org.apache.iotdb.db.pipe.metric.PipeExtractorMetrics;

public class TsFileEpoch {
    private final String filePath;
    private final ConcurrentMap<PipeRealtimeDataRegionExtractor, AtomicReference<State>> dataRegionExtractor2State;
    private final AtomicLong insertNodeMinTime;

    public TsFileEpoch(String filePath) {
        this.filePath = filePath;
        this.dataRegionExtractor2State = new ConcurrentHashMap<PipeRealtimeDataRegionExtractor, AtomicReference<State>>();
        this.insertNodeMinTime = new AtomicLong(Long.MAX_VALUE);
    }

    public State getState(PipeRealtimeDataRegionExtractor extractor) {
        return (State)((Object)this.dataRegionExtractor2State.computeIfAbsent(extractor, o -> new AtomicReference<State>(State.EMPTY)).get());
    }

    public void migrateState(PipeRealtimeDataRegionExtractor extractor, TsFileEpochStateMigrator visitor) {
        this.dataRegionExtractor2State.computeIfAbsent(extractor, o -> new AtomicReference<State>(State.EMPTY)).getAndUpdate(visitor::migrate);
    }

    public void setExtractorsRecentProcessedTsFileEpochState() {
        this.dataRegionExtractor2State.forEach((extractor, state) -> PipeExtractorMetrics.getInstance().setRecentProcessedTsFileEpochState(extractor.getTaskID(), (State)((Object)((Object)state.get()))));
    }

    public void updateInsertNodeMinTime(long newComingMinTime) {
        this.insertNodeMinTime.updateAndGet(recordedMinTime -> Math.min(recordedMinTime, newComingMinTime));
    }

    public long getInsertNodeMinTime() {
        return this.insertNodeMinTime.get();
    }

    public String toString() {
        return "TsFileEpoch{filePath='" + this.filePath + '\'' + ", dataRegionExtractor2State=" + this.dataRegionExtractor2State + '\'' + ", insertNodeMinTime=" + this.insertNodeMinTime.get() + '}';
    }

    public static enum State {
        EMPTY(0),
        USING_TABLET(1),
        USING_BOTH(2),
        USING_TSFILE(3);

        private final int id;

        private State(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

