/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.pattern;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.pattern.PipePattern;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.pattern.PipeDataRegionMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedSchemaPatternMatcher
implements PipeDataRegionMatcher {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CachedSchemaPatternMatcher.class);
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected final Set<PipeRealtimeDataRegionExtractor> extractors = new CopyOnWriteArraySet<PipeRealtimeDataRegionExtractor>();
    protected final Cache<String, Set<PipeRealtimeDataRegionExtractor>> deviceToExtractorsCache = Caffeine.newBuilder().maximumSize((long)PipeConfig.getInstance().getPipeExtractorMatcherCacheSize()).build();

    @Override
    public void register(PipeRealtimeDataRegionExtractor extractor) {
        this.lock.writeLock().lock();
        try {
            this.extractors.add(extractor);
            this.deviceToExtractorsCache.invalidateAll();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void deregister(PipeRealtimeDataRegionExtractor extractor) {
        this.lock.writeLock().lock();
        try {
            this.extractors.remove(extractor);
            this.deviceToExtractorsCache.invalidateAll();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int getRegisterCount() {
        this.lock.readLock().lock();
        try {
            int n = this.extractors.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PipeRealtimeDataRegionExtractor> match(PipeRealtimeEvent event) {
        HashSet<PipeRealtimeDataRegionExtractor> matchedExtractors = new HashSet<PipeRealtimeDataRegionExtractor>();
        this.lock.readLock().lock();
        try {
            if (this.extractors.isEmpty()) {
                HashSet<PipeRealtimeDataRegionExtractor> hashSet = matchedExtractors;
                return hashSet;
            }
            if (event.getEvent() instanceof PipeHeartbeatEvent) {
                Set<PipeRealtimeDataRegionExtractor> set = this.extractors;
                return set;
            }
            if (event.getEvent() instanceof PipeSchemaRegionWritePlanEvent) {
                Set<PipeRealtimeDataRegionExtractor> set = this.extractors.stream().filter(PipeRealtimeDataRegionExtractor::shouldExtractDeletion).collect(Collectors.toSet());
                return set;
            }
            for (Map.Entry<String, String[]> entry : event.getSchemaInfo().entrySet()) {
                String device = entry.getKey();
                String[] measurements = entry.getValue();
                Set extractorsFilteredByDevice = (Set)this.deviceToExtractorsCache.get((Object)device, this::filterExtractorsByDevice);
                if (extractorsFilteredByDevice == null) {
                    LOGGER.warn("Match result NPE when handle device {}", (Object)device);
                    continue;
                }
                if (measurements.length == 0) {
                    matchedExtractors.addAll(extractorsFilteredByDevice);
                } else {
                    extractorsFilteredByDevice.forEach(extractor -> {
                        PipePattern pattern = extractor.getPipePattern();
                        if (Objects.isNull(pattern) || pattern.isRoot() || pattern.coversDevice(device)) {
                            matchedExtractors.add((PipeRealtimeDataRegionExtractor)extractor);
                        } else {
                            for (String measurement : measurements) {
                                if (measurement == null || !pattern.matchesMeasurement(device, measurement)) continue;
                                matchedExtractors.add((PipeRealtimeDataRegionExtractor)extractor);
                                break;
                            }
                        }
                    });
                }
                if (matchedExtractors.size() != this.extractors.size()) continue;
                break;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return matchedExtractors;
    }

    protected Set<PipeRealtimeDataRegionExtractor> filterExtractorsByDevice(String device) {
        HashSet<PipeRealtimeDataRegionExtractor> filteredExtractors = new HashSet<PipeRealtimeDataRegionExtractor>();
        for (PipeRealtimeDataRegionExtractor extractor : this.extractors) {
            PipePattern pipePattern;
            if (!extractor.shouldExtractInsertion() || !Objects.isNull(pipePattern = extractor.getPipePattern()) && !pipePattern.mayOverlapWithDevice(device)) continue;
            filteredExtractors.add(extractor);
        }
        return filteredExtractors;
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.extractors.clear();
            this.deviceToExtractorsCache.invalidateAll();
            this.deviceToExtractorsCache.cleanUp();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

