/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.aggregate.window.datastructure;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.iotdb.db.pipe.processor.aggregate.operator.aggregatedresult.AggregatedResultOperator;
import org.apache.iotdb.db.pipe.processor.aggregate.operator.intermediateresult.CustomizedReadableIntermediateResults;
import org.apache.iotdb.db.pipe.processor.aggregate.operator.intermediateresult.IntermediateResultOperator;
import org.apache.iotdb.db.pipe.processor.aggregate.window.datastructure.WindowOutput;
import org.apache.iotdb.db.pipe.processor.aggregate.window.datastructure.WindowState;
import org.apache.iotdb.db.pipe.processor.aggregate.window.processor.AbstractWindowingProcessor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesWindow {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeSeriesWindow.class);
    private long timestamp = 0L;
    private Map<String, AggregatedResultOperator> aggregatedOutputName2OperatorMap;
    private final Map<String, Pair<TSDataType, IntermediateResultOperator>> intermediateResultName2tsTypeAndOperatorMap = new HashMap<String, Pair<TSDataType, IntermediateResultOperator>>();
    private Object customizedRuntimeValue;
    private final AbstractWindowingProcessor processor;

    public TimeSeriesWindow(AbstractWindowingProcessor processor, Object customizedRuntimeValue) {
        this.processor = processor;
        this.customizedRuntimeValue = customizedRuntimeValue;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Object getCustomizedRuntimeValue() {
        return this.customizedRuntimeValue;
    }

    public void setCustomizedRuntimeValue(Object customizedRuntimeValue) {
        this.customizedRuntimeValue = customizedRuntimeValue;
    }

    public void initWindow(Map<String, Supplier<IntermediateResultOperator>> intermediateResult2OperatorSupplierMap, Map<String, AggregatedResultOperator> aggregatedResultOperatorMap, Map<String, String> systemParameters) {
        for (Map.Entry<String, Supplier<IntermediateResultOperator>> entry : intermediateResult2OperatorSupplierMap.entrySet()) {
            this.intermediateResultName2tsTypeAndOperatorMap.put(entry.getKey(), (Pair<TSDataType, IntermediateResultOperator>)new Pair((Object)TSDataType.UNKNOWN, (Object)entry.getValue().get()));
        }
        this.aggregatedOutputName2OperatorMap = new HashMap<String, AggregatedResultOperator>(aggregatedResultOperatorMap);
        this.intermediateResultName2tsTypeAndOperatorMap.values().stream().map(Pair::getRight).forEach(operator -> operator.configureSystemParameters(systemParameters));
    }

    public Pair<WindowState, WindowOutput> updateIntermediateResult(long timestamp, boolean value) {
        Pair<WindowState, WindowOutput> stateOutputPair = this.processor.updateAndMaySetWindowState(this, timestamp, value);
        WindowState state = (WindowState)((Object)stateOutputPair.getLeft());
        if (state.isEmitWithoutCompute()) {
            ((WindowOutput)stateOutputPair.getRight()).setAggregatedResults(this.getAggregatedResults(TSDataType.BOOLEAN));
        }
        if (state.isCalculate()) {
            Iterator<Map.Entry<String, Pair<TSDataType, IntermediateResultOperator>>> iterator = this.intermediateResultName2tsTypeAndOperatorMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Pair<TSDataType, IntermediateResultOperator>> entry = iterator.next();
                IntermediateResultOperator operator = (IntermediateResultOperator)entry.getValue().getRight();
                if (entry.getValue().getLeft() == TSDataType.UNKNOWN) {
                    if (!operator.initAndGetIsSupport(value, timestamp)) {
                        this.aggregatedOutputName2OperatorMap.entrySet().removeIf(entry1 -> ((AggregatedResultOperator)entry1.getValue()).getDeclaredIntermediateValueNames().contains(operator.getName()));
                        if (this.aggregatedOutputName2OperatorMap.isEmpty()) {
                            return new Pair((Object)WindowState.PURGE, null);
                        }
                        iterator.remove();
                        continue;
                    }
                    entry.getValue().setLeft((Object)TSDataType.BOOLEAN);
                    continue;
                }
                if (entry.getValue().getLeft() != TSDataType.BOOLEAN) {
                    LOGGER.warn("Different data type encountered in one window, will purge. Previous type: {}, now type: {}", entry.getValue().getLeft(), (Object)TSDataType.BOOLEAN);
                    return new Pair((Object)WindowState.PURGE, null);
                }
                operator.updateValue(value, timestamp);
            }
        }
        if (state.isEmitWithCompute()) {
            ((WindowOutput)stateOutputPair.getRight()).setAggregatedResults(this.getAggregatedResults(TSDataType.BOOLEAN));
        }
        return state.isEmit() ? stateOutputPair : null;
    }

    public Pair<WindowState, WindowOutput> updateIntermediateResult(long timestamp, int value) {
        Pair<WindowState, WindowOutput> stateOutputPair = this.processor.updateAndMaySetWindowState(this, timestamp, value);
        WindowState state = (WindowState)((Object)stateOutputPair.getLeft());
        if (state.isEmitWithoutCompute()) {
            ((WindowOutput)stateOutputPair.getRight()).setAggregatedResults(this.getAggregatedResults(TSDataType.INT32));
        }
        if (state.isCalculate()) {
            Iterator<Map.Entry<String, Pair<TSDataType, IntermediateResultOperator>>> iterator = this.intermediateResultName2tsTypeAndOperatorMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Pair<TSDataType, IntermediateResultOperator>> entry = iterator.next();
                IntermediateResultOperator operator = (IntermediateResultOperator)entry.getValue().getRight();
                if (entry.getValue().getLeft() == TSDataType.UNKNOWN) {
                    if (!operator.initAndGetIsSupport(value, timestamp)) {
                        this.aggregatedOutputName2OperatorMap.entrySet().removeIf(entry1 -> ((AggregatedResultOperator)entry1.getValue()).getDeclaredIntermediateValueNames().contains(operator.getName()));
                        if (this.aggregatedOutputName2OperatorMap.isEmpty()) {
                            return new Pair((Object)WindowState.PURGE, null);
                        }
                        iterator.remove();
                        continue;
                    }
                    entry.getValue().setLeft((Object)TSDataType.INT32);
                    continue;
                }
                if (entry.getValue().getLeft() != TSDataType.INT32) {
                    LOGGER.warn("Different data type encountered in one window, will purge. Previous type: {}, now type: {}", entry.getValue().getLeft(), (Object)TSDataType.INT32);
                    return new Pair((Object)WindowState.PURGE, null);
                }
                operator.updateValue(value, timestamp);
            }
        }
        if (state.isEmitWithCompute()) {
            ((WindowOutput)stateOutputPair.getRight()).setAggregatedResults(this.getAggregatedResults(TSDataType.INT32));
        }
        return state.isEmit() ? stateOutputPair : null;
    }

    public Pair<WindowState, WindowOutput> updateIntermediateResult(long timestamp, long value) {
        Pair<WindowState, WindowOutput> stateOutputPair = this.processor.updateAndMaySetWindowState(this, timestamp, value);
        WindowState state = (WindowState)((Object)stateOutputPair.getLeft());
        if (state.isEmitWithoutCompute()) {
            ((WindowOutput)stateOutputPair.getRight()).setAggregatedResults(this.getAggregatedResults(TSDataType.INT64));
        }
        if (state.isCalculate()) {
            Iterator<Map.Entry<String, Pair<TSDataType, IntermediateResultOperator>>> iterator = this.intermediateResultName2tsTypeAndOperatorMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Pair<TSDataType, IntermediateResultOperator>> entry = iterator.next();
                IntermediateResultOperator operator = (IntermediateResultOperator)entry.getValue().getRight();
                if (entry.getValue().getLeft() == TSDataType.UNKNOWN) {
                    if (!operator.initAndGetIsSupport(value, timestamp)) {
                        this.aggregatedOutputName2OperatorMap.entrySet().removeIf(entry1 -> ((AggregatedResultOperator)entry1.getValue()).getDeclaredIntermediateValueNames().contains(operator.getName()));
                        if (this.aggregatedOutputName2OperatorMap.isEmpty()) {
                            return new Pair((Object)WindowState.PURGE, null);
                        }
                        iterator.remove();
                        continue;
                    }
                    entry.getValue().setLeft((Object)TSDataType.INT64);
                    continue;
                }
                if (entry.getValue().getLeft() != TSDataType.INT64) {
                    LOGGER.warn("Different data type encountered in one window, will purge. Previous type: {}, now type: {}", entry.getValue().getLeft(), (Object)TSDataType.INT64);
                    return new Pair((Object)WindowState.PURGE, null);
                }
                operator.updateValue(value, timestamp);
            }
        }
        if (state.isEmitWithCompute()) {
            ((WindowOutput)stateOutputPair.getRight()).setAggregatedResults(this.getAggregatedResults(TSDataType.INT64));
        }
        return state.isEmit() ? stateOutputPair : null;
    }

    public Pair<WindowState, WindowOutput> updateIntermediateResult(long timestamp, float value) {
        Pair<WindowState, WindowOutput> stateOutputPair = this.processor.updateAndMaySetWindowState(this, timestamp, value);
        WindowState state = (WindowState)((Object)stateOutputPair.getLeft());
        if (state.isEmitWithoutCompute()) {
            ((WindowOutput)stateOutputPair.getRight()).setAggregatedResults(this.getAggregatedResults(TSDataType.FLOAT));
        }
        if (state.isCalculate()) {
            Iterator<Map.Entry<String, Pair<TSDataType, IntermediateResultOperator>>> iterator = this.intermediateResultName2tsTypeAndOperatorMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Pair<TSDataType, IntermediateResultOperator>> entry = iterator.next();
                IntermediateResultOperator operator = (IntermediateResultOperator)entry.getValue().getRight();
                if (entry.getValue().getLeft() == TSDataType.UNKNOWN) {
                    if (!operator.initAndGetIsSupport(value, timestamp)) {
                        this.aggregatedOutputName2OperatorMap.entrySet().removeIf(entry1 -> ((AggregatedResultOperator)entry1.getValue()).getDeclaredIntermediateValueNames().contains(operator.getName()));
                        if (this.aggregatedOutputName2OperatorMap.isEmpty()) {
                            return new Pair((Object)WindowState.PURGE, null);
                        }
                        iterator.remove();
                        continue;
                    }
                    entry.getValue().setLeft((Object)TSDataType.FLOAT);
                    continue;
                }
                if (entry.getValue().getLeft() != TSDataType.FLOAT) {
                    LOGGER.warn("Different data type encountered in one window, will purge. Previous type: {}, now type: {}", entry.getValue().getLeft(), (Object)TSDataType.FLOAT);
                    return new Pair((Object)WindowState.PURGE, null);
                }
                operator.updateValue(value, timestamp);
            }
        }
        if (state.isEmitWithCompute()) {
            ((WindowOutput)stateOutputPair.getRight()).setAggregatedResults(this.getAggregatedResults(TSDataType.FLOAT));
        }
        return state.isEmit() ? stateOutputPair : null;
    }

    public Pair<WindowState, WindowOutput> updateIntermediateResult(long timestamp, double value) {
        Pair<WindowState, WindowOutput> stateOutputPair = this.processor.updateAndMaySetWindowState(this, timestamp, value);
        WindowState state = (WindowState)((Object)stateOutputPair.getLeft());
        if (state.isEmitWithoutCompute()) {
            ((WindowOutput)stateOutputPair.getRight()).setAggregatedResults(this.getAggregatedResults(TSDataType.DOUBLE));
        }
        if (state.isCalculate()) {
            Iterator<Map.Entry<String, Pair<TSDataType, IntermediateResultOperator>>> iterator = this.intermediateResultName2tsTypeAndOperatorMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Pair<TSDataType, IntermediateResultOperator>> entry = iterator.next();
                IntermediateResultOperator operator = (IntermediateResultOperator)entry.getValue().getRight();
                if (entry.getValue().getLeft() == TSDataType.UNKNOWN) {
                    if (!operator.initAndGetIsSupport(value, timestamp)) {
                        this.aggregatedOutputName2OperatorMap.entrySet().removeIf(entry1 -> ((AggregatedResultOperator)entry1.getValue()).getDeclaredIntermediateValueNames().contains(operator.getName()));
                        if (this.aggregatedOutputName2OperatorMap.isEmpty()) {
                            return new Pair((Object)WindowState.PURGE, null);
                        }
                        iterator.remove();
                        continue;
                    }
                    entry.getValue().setLeft((Object)TSDataType.DOUBLE);
                    continue;
                }
                if (entry.getValue().getLeft() != TSDataType.DOUBLE) {
                    LOGGER.warn("Different data type encountered in one window, will purge. Previous type: {}, now type: {}", entry.getValue().getLeft(), (Object)TSDataType.DOUBLE);
                    return new Pair((Object)WindowState.PURGE, null);
                }
                operator.updateValue(value, timestamp);
            }
        }
        if (state.isEmitWithCompute()) {
            ((WindowOutput)stateOutputPair.getRight()).setAggregatedResults(this.getAggregatedResults(TSDataType.DOUBLE));
        }
        return state.isEmit() ? stateOutputPair : null;
    }

    public Pair<WindowState, WindowOutput> updateIntermediateResult(long timestamp, String value) {
        Pair<WindowState, WindowOutput> stateOutputPair = this.processor.updateAndMaySetWindowState(this, timestamp, value);
        WindowState state = (WindowState)((Object)stateOutputPair.getLeft());
        if (state.isEmitWithoutCompute()) {
            ((WindowOutput)stateOutputPair.getRight()).setAggregatedResults(this.getAggregatedResults(TSDataType.TEXT));
        }
        if (state.isCalculate()) {
            Iterator<Map.Entry<String, Pair<TSDataType, IntermediateResultOperator>>> iterator = this.intermediateResultName2tsTypeAndOperatorMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Pair<TSDataType, IntermediateResultOperator>> entry = iterator.next();
                IntermediateResultOperator operator = (IntermediateResultOperator)entry.getValue().getRight();
                if (entry.getValue().getLeft() == TSDataType.UNKNOWN) {
                    if (!operator.initAndGetIsSupport(value, timestamp)) {
                        this.aggregatedOutputName2OperatorMap.entrySet().removeIf(entry1 -> ((AggregatedResultOperator)entry1.getValue()).getDeclaredIntermediateValueNames().contains(operator.getName()));
                        if (this.aggregatedOutputName2OperatorMap.isEmpty()) {
                            return new Pair((Object)WindowState.PURGE, null);
                        }
                        iterator.remove();
                        continue;
                    }
                    entry.getValue().setLeft((Object)TSDataType.TEXT);
                    continue;
                }
                if (entry.getValue().getLeft() != TSDataType.TEXT) {
                    LOGGER.warn("Different data type encountered in one window, will purge. Previous type: {}, now type: {}", entry.getValue().getLeft(), (Object)TSDataType.TEXT);
                    return new Pair((Object)WindowState.PURGE, null);
                }
                operator.updateValue(value, timestamp);
            }
        }
        if (state.isEmitWithCompute()) {
            ((WindowOutput)stateOutputPair.getRight()).setAggregatedResults(this.getAggregatedResults(TSDataType.TEXT));
        }
        return state.isEmit() ? stateOutputPair : null;
    }

    public WindowOutput forceOutput() {
        return this.processor.forceOutput(this).setAggregatedResults(this.getAggregatedResults(this.intermediateResultName2tsTypeAndOperatorMap.values().stream().findFirst().map(Pair::getLeft).orElse(TSDataType.UNKNOWN)));
    }

    private Map<String, Pair<TSDataType, Object>> getAggregatedResults(TSDataType dataType) {
        if (dataType == TSDataType.UNKNOWN || this.intermediateResultName2tsTypeAndOperatorMap.entrySet().stream().anyMatch(entry -> ((Pair)entry.getValue()).getLeft() != dataType)) {
            return Collections.emptyMap();
        }
        CustomizedReadableIntermediateResults readableIntermediateResults = new CustomizedReadableIntermediateResults(this.intermediateResultName2tsTypeAndOperatorMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((IntermediateResultOperator)((Pair)entry.getValue()).getRight()).getResult())));
        return this.aggregatedOutputName2OperatorMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AggregatedResultOperator)entry.getValue()).terminateWindow(dataType, readableIntermediateResults)));
    }

    public void serialize(DataOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((long)this.timestamp, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.intermediateResultName2tsTypeAndOperatorMap.size(), (OutputStream)outputStream);
        for (Map.Entry<String, Pair<TSDataType, IntermediateResultOperator>> entry : this.intermediateResultName2tsTypeAndOperatorMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
            ((TSDataType)entry.getValue().getLeft()).serializeTo(outputStream);
            ((IntermediateResultOperator)entry.getValue().getRight()).serialize(outputStream);
        }
        this.processor.serializeCustomizedAttributes(this, outputStream);
    }

    public void deserialize(ByteBuffer byteBuffer) throws IOException {
        this.timestamp = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < size; ++i) {
            String intermediateResultName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            Pair<TSDataType, IntermediateResultOperator> initializedAndOperatorPair = this.intermediateResultName2tsTypeAndOperatorMap.get(intermediateResultName);
            if (!Objects.nonNull(initializedAndOperatorPair)) continue;
            initializedAndOperatorPair.setLeft((Object)TSDataType.deserializeFrom((ByteBuffer)byteBuffer));
            ((IntermediateResultOperator)initializedAndOperatorPair.getRight()).deserialize(byteBuffer);
        }
        this.processor.deserializeCustomizedAttributes(this, byteBuffer);
    }
}

