/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.builder;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeType;
import org.apache.iotdb.db.pipe.execution.PipeConnectorSubtaskExecutor;
import org.apache.iotdb.db.pipe.execution.PipeProcessorSubtaskExecutor;
import org.apache.iotdb.db.pipe.execution.PipeSubtaskExecutorManager;
import org.apache.iotdb.db.pipe.task.PipeDataNodeTask;
import org.apache.iotdb.db.pipe.task.stage.PipeTaskConnectorStage;
import org.apache.iotdb.db.pipe.task.stage.PipeTaskExtractorStage;
import org.apache.iotdb.db.pipe.task.stage.PipeTaskProcessorStage;
import org.apache.iotdb.db.subscription.task.stage.SubscriptionTaskConnectorStage;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;

public class PipeDataNodeTaskBuilder {
    private final PipeStaticMeta pipeStaticMeta;
    private final int regionId;
    private final PipeTaskMeta pipeTaskMeta;
    private static final PipeProcessorSubtaskExecutor PROCESSOR_EXECUTOR = PipeSubtaskExecutorManager.getInstance().getProcessorExecutor();
    private static final Map<PipeType, PipeConnectorSubtaskExecutor> CONNECTOR_EXECUTOR_MAP = new HashMap<PipeType, PipeConnectorSubtaskExecutor>();
    protected final Map<String, String> systemParameters = new HashMap<String, String>();

    public PipeDataNodeTaskBuilder(PipeStaticMeta pipeStaticMeta, int regionId, PipeTaskMeta pipeTaskMeta) {
        this.pipeStaticMeta = pipeStaticMeta;
        this.regionId = regionId;
        this.pipeTaskMeta = pipeTaskMeta;
        this.generateSystemParameters();
    }

    public PipeDataNodeTask build() {
        PipeTaskExtractorStage extractorStage = new PipeTaskExtractorStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), this.blendUserAndSystemParameters(this.pipeStaticMeta.getExtractorParameters()), this.regionId, this.pipeTaskMeta);
        PipeType pipeType = this.pipeStaticMeta.getPipeType();
        PipeTaskConnectorStage connectorStage = PipeType.SUBSCRIPTION.equals((Object)pipeType) ? new SubscriptionTaskConnectorStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), this.blendUserAndSystemParameters(this.pipeStaticMeta.getConnectorParameters()), this.regionId, CONNECTOR_EXECUTOR_MAP.get(pipeType)) : new PipeTaskConnectorStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), this.blendUserAndSystemParameters(this.pipeStaticMeta.getConnectorParameters()), this.regionId, CONNECTOR_EXECUTOR_MAP.get(pipeType));
        PipeTaskProcessorStage processorStage = new PipeTaskProcessorStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), this.blendUserAndSystemParameters(this.pipeStaticMeta.getProcessorParameters()), this.regionId, extractorStage.getEventSupplier(), connectorStage.getPipeConnectorPendingQueue(), PROCESSOR_EXECUTOR, this.pipeTaskMeta);
        return new PipeDataNodeTask(this.pipeStaticMeta.getPipeName(), this.regionId, extractorStage, processorStage, connectorStage);
    }

    private void generateSystemParameters() {
        if (!(this.pipeTaskMeta.getProgressIndex() instanceof MinimumProgressIndex)) {
            this.systemParameters.put("__system.restart", Boolean.TRUE.toString());
        }
    }

    private PipeParameters blendUserAndSystemParameters(PipeParameters userParameters) {
        HashMap<String, String> blendedParameters = new HashMap<String, String>(userParameters.getAttribute());
        blendedParameters.putAll(this.systemParameters);
        return new PipeParameters(blendedParameters);
    }

    static {
        CONNECTOR_EXECUTOR_MAP.put(PipeType.USER, PipeSubtaskExecutorManager.getInstance().getConnectorExecutor());
        CONNECTOR_EXECUTOR_MAP.put(PipeType.SUBSCRIPTION, PipeSubtaskExecutorManager.getInstance().getSubscriptionExecutor());
    }
}

