/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class ExtremeAccumulator
implements Accumulator {
    private final TSDataType seriesDataType;
    private final TsPrimitiveType extremeResult;
    private boolean initResult;

    public ExtremeAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
        this.extremeResult = TsPrimitiveType.getByType((TSDataType)seriesDataType);
    }

    @Override
    public void addInput(Column[] columns, BitMap bitMap) {
        switch (this.seriesDataType) {
            case INT32: {
                this.addIntInput(columns, bitMap);
                return;
            }
            case INT64: {
                this.addLongInput(columns, bitMap);
                return;
            }
            case FLOAT: {
                this.addFloatInput(columns, bitMap);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(columns, bitMap);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in Extreme: %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 1 ? 1 : 0) != 0, (Object)"partialResult of ExtremeValue should be 1");
        if (partialResult[0].isNull(0)) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                this.updateIntResult(partialResult[0].getInt(0));
                break;
            }
            case INT64: {
                this.updateLongResult(partialResult[0].getLong(0));
                break;
            }
            case FLOAT: {
                this.updateFloatResult(partialResult[0].getFloat(0));
                break;
            }
            case DOUBLE: {
                this.updateDoubleResult(partialResult[0].getDouble(0));
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Extreme: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void addStatistics(Statistics statistics) {
        if (statistics == null) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                this.updateIntResult((Integer)statistics.getMaxValue());
                this.updateIntResult((Integer)statistics.getMinValue());
                break;
            }
            case INT64: {
                this.updateLongResult((Long)statistics.getMaxValue());
                this.updateLongResult((Long)statistics.getMinValue());
                break;
            }
            case FLOAT: {
                this.updateFloatResult(((Float)statistics.getMaxValue()).floatValue());
                this.updateFloatResult(((Float)statistics.getMinValue()).floatValue());
                break;
            }
            case DOUBLE: {
                this.updateDoubleResult((Double)statistics.getMaxValue());
                this.updateDoubleResult((Double)statistics.getMinValue());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Extreme: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void setFinal(Column finalResult) {
        if (finalResult.isNull(0)) {
            return;
        }
        this.initResult = true;
        switch (this.seriesDataType) {
            case INT32: {
                this.extremeResult.setInt(finalResult.getInt(0));
                break;
            }
            case INT64: {
                this.extremeResult.setLong(finalResult.getLong(0));
                break;
            }
            case FLOAT: {
                this.extremeResult.setFloat(finalResult.getFloat(0));
                break;
            }
            case DOUBLE: {
                this.extremeResult.setDouble(finalResult.getDouble(0));
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Extreme: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 1 ? 1 : 0) != 0, (Object)"partialResult of ExtremeValue should be 1");
        if (!this.initResult) {
            columnBuilders[0].appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                columnBuilders[0].writeInt(this.extremeResult.getInt());
                break;
            }
            case INT64: {
                columnBuilders[0].writeLong(this.extremeResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilders[0].writeFloat(this.extremeResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilders[0].writeDouble(this.extremeResult.getDouble());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Extreme: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                columnBuilder.writeInt(this.extremeResult.getInt());
                break;
            }
            case INT64: {
                columnBuilder.writeLong(this.extremeResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.extremeResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.extremeResult.getDouble());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Extreme: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.extremeResult.reset();
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{this.extremeResult.getDataType()};
    }

    @Override
    public TSDataType getFinalType() {
        return this.extremeResult.getDataType();
    }

    private void addIntInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateIntResult(column[1].getInt(i));
        }
    }

    private void updateIntResult(int extVal) {
        int absExtVal = Math.abs(extVal);
        int candidateResult = this.extremeResult.getInt();
        int absCandidateResult = Math.abs(this.extremeResult.getInt());
        if (!this.initResult || absExtVal > absCandidateResult || absExtVal == absCandidateResult && extVal > candidateResult) {
            this.initResult = true;
            this.extremeResult.setInt(extVal);
        }
    }

    private void addLongInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateLongResult(column[1].getLong(i));
        }
    }

    private void updateLongResult(long extVal) {
        long absExtVal = Math.abs(extVal);
        long candidateResult = this.extremeResult.getLong();
        long absCandidateResult = Math.abs(this.extremeResult.getLong());
        if (!this.initResult || absExtVal > absCandidateResult || absExtVal == absCandidateResult && extVal > candidateResult) {
            this.initResult = true;
            this.extremeResult.setLong(extVal);
        }
    }

    private void addFloatInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateFloatResult(column[1].getFloat(i));
        }
    }

    private void updateFloatResult(float extVal) {
        float absExtVal = Math.abs(extVal);
        float candidateResult = this.extremeResult.getFloat();
        float absCandidateResult = Math.abs(this.extremeResult.getFloat());
        if (!this.initResult || absExtVal > absCandidateResult || absExtVal == absCandidateResult && extVal > candidateResult) {
            this.initResult = true;
            this.extremeResult.setFloat(extVal);
        }
    }

    private void addDoubleInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateDoubleResult(column[1].getDouble(i));
        }
    }

    private void updateDoubleResult(double extVal) {
        double absExtVal = Math.abs(extVal);
        double candidateResult = this.extremeResult.getDouble();
        double absCandidateResult = Math.abs(this.extremeResult.getDouble());
        if (!this.initResult || absExtVal > absCandidateResult || absExtVal == absCandidateResult && extVal > candidateResult) {
            this.initResult = true;
            this.extremeResult.setDouble(extVal);
        }
    }
}

